/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.ircbot.SCIRCBot;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.main.mod_SecurityCraft;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.network.packets.PacketCPlaySoundAtPos;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ForgeEventHandler {
    private static HashMap<String, String> tipsWithLink = new HashMap();

    public ForgeEventHandler() {
        tipsWithLink.put("trello", "https://trello.com/b/dbCNZwx0/securitycraft");
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/RYsKYx5");
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        mod_SecurityCraft.instance.createIrcBot(event.player.func_70005_c_());
        String tipKey = this.getRandomTip();
        Object chatcomponenttext = tipsWithLink.containsKey(tipKey.split("\\.")[2]) ? new ChatComponentText("[" + EnumChatFormatting.GOLD + "SecurityCraft" + EnumChatFormatting.WHITE + "] " + StatCollector.func_74838_a((String)"messages.thanks").replace("#", mod_SecurityCraft.getVersion()) + " " + StatCollector.func_74838_a((String)"messages.tip") + " " + StatCollector.func_74838_a((String)tipKey) + " ").func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2]))) : new ChatComponentText("[" + EnumChatFormatting.GOLD + "SecurityCraft" + EnumChatFormatting.WHITE + "] " + StatCollector.func_74838_a((String)"messages.thanks").replace("#", mod_SecurityCraft.getVersion()) + " " + StatCollector.func_74838_a((String)"messages.tip") + " " + StatCollector.func_74838_a((String)tipKey));
        if (mod_SecurityCraft.configHandler.sayThanksMessage) {
            event.player.func_146105_b((IChatComponent)chatcomponenttext);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (mod_SecurityCraft.configHandler.disconnectOnWorldClose && mod_SecurityCraft.instance.getIrcBot(event.player.func_70005_c_()) != null) {
            mod_SecurityCraft.instance.getIrcBot(event.player.func_70005_c_()).disconnect();
            mod_SecurityCraft.instance.removeIrcBot(event.player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void onDamageTaken(LivingHurtEvent event) {
        if (event.entityLiving != null && PlayerUtils.isPlayerMountedOnCamera(event.entityLiving)) {
            event.setCanceled(true);
            return;
        }
        if (event.source == CustomDamageSources.electricity) {
            mod_SecurityCraft.network.sendToAll((IMessage)new PacketCPlaySoundAtPos(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, SCSounds.ELECTRIFIED.path, 0.25));
        }
    }

    @SubscribeEvent
    public void onBucketUsed(FillBucketEvent event) {
        ItemStack result = this.fillBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onServerChatEvent(ServerChatEvent event) {
        SCIRCBot bot = mod_SecurityCraft.instance.getIrcBot(event.player.func_70005_c_());
        if (bot != null && bot.getMessageMode()) {
            event.setCanceled(true);
            bot.sendMessage("> " + event.message);
            bot.sendMessageToPlayer(EnumChatFormatting.GRAY + "<" + event.player.func_70005_c_() + " --> IRC> " + event.message, (EntityPlayer)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldUnloaded(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            ((ClientProxy)mod_SecurityCraft.serverProxy).worldViews.clear();
        }
    }

    @SubscribeEvent
    public void onPlayerInteracted(PlayerInteractEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            World world = event.entityPlayer.field_70170_p;
            TileEntity tileEntity = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
            Block block = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z);
            if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && PlayerUtils.isHoldingItem(event.entityPlayer, mod_SecurityCraft.codebreaker) && this.handleCodebreaking(event)) {
                event.setCanceled(true);
                return;
            }
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && tileEntity != null && tileEntity instanceof CustomizableSCTE && PlayerUtils.isHoldingItem(event.entityPlayer, mod_SecurityCraft.universalBlockModifier)) {
                event.setCanceled(true);
                if (!((IOwnable)tileEntity).getOwner().isOwner(event.entityPlayer)) {
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, StatCollector.func_74838_a((String)"item.universalBlockModifier.name"), StatCollector.func_74838_a((String)"messages.notOwned").replace("#", ((IOwnable)tileEntity).getOwner().getName()), EnumChatFormatting.RED);
                    return;
                }
                event.entityPlayer.openGui((Object)mod_SecurityCraft.instance, 100, world, event.x, event.y, event.z);
                return;
            }
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && tileEntity instanceof INameable && ((INameable)tileEntity).canBeNamed() && PlayerUtils.isHoldingItem(event.entityPlayer, Items.field_151057_cb) && event.entityPlayer.func_71045_bC().func_82837_s()) {
                event.setCanceled(true);
                for (String character : new String[]{"(", ")"}) {
                    if (!event.entityPlayer.func_71045_bC().func_82833_r().contains(character)) continue;
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, "Naming", StatCollector.func_74838_a((String)"messages.naming.error").replace("#n", event.entityPlayer.func_71045_bC().func_82833_r()).replace("#c", character), EnumChatFormatting.RED);
                    return;
                }
                if (((INameable)tileEntity).getCustomName().matches(event.entityPlayer.func_71045_bC().func_82833_r())) {
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, "Naming", StatCollector.func_74838_a((String)"messages.naming.alreadyMatches").replace("#n", ((INameable)tileEntity).getCustomName()), EnumChatFormatting.RED);
                    return;
                }
                --event.entityPlayer.func_71045_bC().field_77994_a;
                ((INameable)tileEntity).setCustomName(event.entityPlayer.func_71045_bC().func_82833_r());
                return;
            }
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && tileEntity != null && this.isOwnableBlock(block, tileEntity) && PlayerUtils.isHoldingItem(event.entityPlayer, mod_SecurityCraft.universalBlockRemover)) {
                event.setCanceled(true);
                if (!((IOwnable)tileEntity).getOwner().isOwner(event.entityPlayer)) {
                    PlayerUtils.sendMessageToPlayer(event.entityPlayer, StatCollector.func_74838_a((String)"item.universalBlockRemover.name"), StatCollector.func_74838_a((String)"messages.notOwned").replace("#", ((IOwnable)tileEntity).getOwner().getName()), EnumChatFormatting.RED);
                    return;
                }
                if (block == mod_SecurityCraft.laserBlock) {
                    world.func_147480_a(event.x, event.y, event.z, true);
                    BlockLaserBlock.destroyAdjacentLasers(event.world, event.x, event.y, event.z);
                    event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
                } else {
                    world.func_147480_a(event.x, event.y, event.z, true);
                    world.func_147475_p(event.x, event.y, event.z);
                    event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
                }
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("securitycraft")) {
            mod_SecurityCraft.configFile.save();
            mod_SecurityCraft.configHandler.setupConfiguration();
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        this.handleOwnableTEs(event);
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K && event.world.func_147438_o(event.x, event.y, event.z) != null && event.world.func_147438_o(event.x, event.y, event.z) instanceof CustomizableSCTE) {
            CustomizableSCTE te = (CustomizableSCTE)event.world.func_147438_o(event.x, event.y, event.z);
            for (int i = 0; i < te.getNumberOfCustomizableOptions(); ++i) {
                if (te.itemStacks[i] == null) continue;
                ItemStack stack = te.itemStacks[i];
                EntityItem item = new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, stack);
                event.world.func_72838_d((Entity)item);
                te.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModule());
                te.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, te);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.target != null && event.target instanceof EntityPlayer && event.target != event.entityLiving.func_94060_bK() && PlayerUtils.isPlayerMountedOnCamera(event.target)) {
            ((EntityLiving)event.entityLiving).func_70624_b(null);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE && Minecraft.func_71410_x().field_71441_e.func_147439_a((int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70165_t), (int)(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70163_u - 1.0), (int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70161_v)) instanceof BlockSecurityCamera) {
            GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, event.resolution, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70165_t), (int)(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70163_u - 1.0), (int)Math.floor(Minecraft.func_71410_x().field_71439_g.field_70154_o.field_70161_v), event.mouseX, event.mouseY);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.entity)) {
            event.newfov = ((EntitySecurityCamera)event.entity.field_70154_o).getZoomAmount();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseClicked(MouseEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    private String getRandomTip() {
        String[] tips = new String[]{"messages.tip.scHelp", "messages.tip.scConnect", "messages.tip.trello", "messages.tip.patreon", "messages.tip.discord", "messages.tip.scserver"};
        return tips[new Random().nextInt(tips.length)];
    }

    private ItemStack fillBucket(World world, MovingObjectPosition position) {
        Block block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
        if (block == mod_SecurityCraft.bogusWater) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(mod_SecurityCraft.fWaterBucket, 1);
        }
        if (block == mod_SecurityCraft.bogusLava) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(mod_SecurityCraft.fLavaBucket, 1);
        }
        return null;
    }

    private void handleOwnableTEs(BlockEvent.PlaceEvent event) {
        if (event.world.func_147438_o(event.x, event.y, event.z) instanceof IOwnable) {
            String name = event.player.func_70005_c_();
            String uuid = event.player.func_146103_bH().getId().toString();
            ((IOwnable)event.world.func_147438_o(event.x, event.y, event.z)).getOwner().set(uuid, name);
        }
    }

    private boolean handleCodebreaking(PlayerInteractEvent event) {
        World world = event.entityPlayer.field_70170_p;
        TileEntity tileEntity = event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z);
        if (mod_SecurityCraft.configHandler.allowCodebreakerItem) {
            event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
        }
        if (tileEntity != null && tileEntity instanceof IPasswordProtected && new Random().nextInt(3) == 1) {
            return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_72805_g(event.x, event.y, event.z), event.entityPlayer, !mod_SecurityCraft.configHandler.allowCodebreakerItem);
        }
        return false;
    }

    private boolean isOwnableBlock(Block block, TileEntity tileEntity) {
        return tileEntity instanceof TileEntityOwnable || tileEntity instanceof IOwnable || block instanceof BlockOwnable;
    }
}

