/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctmlib;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import team.chisel.ctmlib.CTM;
import team.chisel.ctmlib.ISubmapManager;
import team.chisel.ctmlib.TextureSubmap;

public class RenderBlocksCTM
extends RenderBlocks {
    public CTM ctm = CTM.getInstance();
    protected int blockLightBitChannel = 0;
    protected int redBitChannel = 0;
    protected int greenBitChannel = 0;
    protected int blueBitChannel = 0;
    protected int sunlightBitChannel = 0;
    protected Tessellator tessellator = Tessellator.field_78398_a;
    protected double minU;
    protected double maxU;
    protected double minV;
    protected double maxV;
    protected int[] lightingCache = new int[4];
    protected float[] redCache = new float[4];
    protected float[] grnCache = new float[4];
    protected float[] bluCache = new float[4];
    public TextureSubmap submap;
    public TextureSubmap submapSmall;
    public RenderBlocks rendererOld;
    public ISubmapManager manager;
    protected int[][] lightmap = new int[3][3];
    protected float[][] redmap = new float[3][3];
    protected float[][] grnmap = new float[3][3];
    protected float[][] blumap = new float[3][3];
    protected int bx;
    protected int by;
    protected int bz;
    protected int meta;
    protected boolean inWorld = false;

    public RenderBlocksCTM() {
        this.field_147853_m = 1.0;
        this.field_147857_k = 1.0;
        this.field_147861_i = 1.0;
    }

    public boolean func_147784_q(Block block, int x, int y, int z) {
        this.bx = x;
        this.by = y;
        this.bz = z;
        this.meta = Minecraft.func_71410_x().field_71441_e.func_72805_g(x, y, z);
        this.tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        this.tessellator.func_78372_c((float)x, (float)y, (float)z);
        if (this.rendererOld != null && this.rendererOld.func_147744_b()) {
            this.func_147757_a(this.rendererOld.field_147840_d);
        }
        this.inWorld = true;
        boolean res = super.func_147784_q(block, x, y, z);
        this.inWorld = false;
        this.tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return res;
    }

    protected void fillLightmap(int bottomLeft, int bottomRight, int topRight, int topLeft) {
        this.lightmap[0][0] = bottomLeft;
        this.lightmap[2][0] = bottomRight;
        this.lightmap[2][2] = topRight;
        this.lightmap[0][2] = topLeft;
        this.lightmap[1][0] = this.avg(bottomLeft, bottomRight);
        this.lightmap[2][1] = this.avg(bottomRight, topRight);
        this.lightmap[1][2] = this.avg(topRight, topLeft);
        this.lightmap[0][1] = this.avg(topLeft, bottomLeft);
        this.lightmap[1][1] = this.avg(bottomLeft, bottomRight, topRight, topLeft);
    }

    protected void fillColormap(float bottomLeft, float bottomRight, float topRight, float topLeft, float[][] map) {
        map[0][0] = bottomLeft;
        map[2][0] = bottomRight;
        map[2][2] = topRight;
        map[0][2] = topLeft;
        map[1][0] = (bottomLeft + bottomRight) / 2.0f;
        map[2][1] = (bottomRight + topRight) / 2.0f;
        map[1][2] = (topRight + topLeft) / 2.0f;
        map[0][1] = (topLeft + bottomLeft) / 2.0f;
        map[1][1] = (bottomLeft + bottomRight + topRight + topLeft) / 4.0f;
    }

    protected void getLight(int x, int y) {
        this.lightingCache[0] = this.lightmap[0 + x][0 + y];
        this.lightingCache[1] = this.lightmap[1 + x][0 + y];
        this.lightingCache[2] = this.lightmap[1 + x][1 + y];
        this.lightingCache[3] = this.lightmap[0 + x][1 + y];
        this.redCache[0] = this.redmap[0 + x][0 + y];
        this.redCache[1] = this.redmap[1 + x][0 + y];
        this.redCache[2] = this.redmap[1 + x][1 + y];
        this.redCache[3] = this.redmap[0 + x][1 + y];
        this.grnCache[0] = this.grnmap[0 + x][0 + y];
        this.grnCache[1] = this.grnmap[1 + x][0 + y];
        this.grnCache[2] = this.grnmap[1 + x][1 + y];
        this.grnCache[3] = this.grnmap[0 + x][1 + y];
        this.bluCache[0] = this.blumap[0 + x][0 + y];
        this.bluCache[1] = this.blumap[1 + x][0 + y];
        this.bluCache[2] = this.blumap[1 + x][1 + y];
        this.bluCache[3] = this.blumap[0 + x][1 + y];
    }

    private int avg(int ... lightVals) {
        this.blockLightBitChannel = 0;
        this.redBitChannel = 0;
        this.greenBitChannel = 0;
        this.blueBitChannel = 0;
        this.sunlightBitChannel = 0;
        for (int light : lightVals) {
            this.blockLightBitChannel += light & 0xFF;
            this.redBitChannel += light & 0xF00;
            this.greenBitChannel += light & 0xF000;
            this.blueBitChannel += light & 0xF0000;
            this.sunlightBitChannel += light & 0xF00000;
        }
        return this.blockLightBitChannel / lightVals.length & 0xFF | this.redBitChannel / lightVals.length & 0xF00 | this.greenBitChannel / lightVals.length & 0xF000 | this.blueBitChannel / lightVals.length & 0xF0000 | this.sunlightBitChannel / lightVals.length & 0xF00000;
    }

    protected void side(Block block, SubSide side, int iconIndex) {
        IIcon icon;
        TextureSubmap map;
        if (iconIndex >= 16) {
            iconIndex -= 16;
            map = this.submapSmall;
        } else {
            map = this.submap;
        }
        if (map == null) {
            icon = this.func_147787_a(block, side.normal.ordinal(), this.meta);
        } else {
            int x = iconIndex % map.getWidth();
            int y = iconIndex / map.getHeight();
            icon = map.getSubIcon(x, y);
        }
        double umax = icon.func_94212_f();
        double umin = icon.func_94209_e();
        double vmax = icon.func_94210_h();
        double vmin = icon.func_94206_g();
        this.minU = umin;
        this.maxU = umax;
        this.minV = vmin;
        this.maxV = vmax;
        side.render(this);
    }

    public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
        if (!this.inWorld || this.func_147744_b() || this.submap == null) {
            super.func_147798_e(block, 0.0, 0.0, 0.0, icon);
        } else {
            int[] tex = this.ctm.getSubmapIndices(this.field_147845_a, this.bx, this.by, this.bz, 4);
            this.pre(ForgeDirection.WEST);
            this.fillLightmap(this.field_147876_an, this.field_147870_ao, this.field_147864_al, this.field_147874_am);
            this.fillColormap(this.field_147850_ar, this.field_147848_as, this.field_147872_ap, this.field_147852_aq, this.redmap);
            this.fillColormap(this.field_147858_av, this.field_147856_aw, this.field_147846_at, this.field_147860_au, this.grnmap);
            this.fillColormap(this.field_147839_az, this.field_147833_aA, this.field_147854_ax, this.field_147841_ay, this.blumap);
            this.getLight(0, 0);
            this.side(block, SubSide.XNEG_LB, tex[0]);
            this.getLight(1, 0);
            this.side(block, SubSide.XNEG_RB, tex[1]);
            this.getLight(1, 1);
            this.side(block, SubSide.XNEG_RT, tex[2]);
            this.getLight(0, 1);
            this.side(block, SubSide.XNEG_LT, tex[3]);
            this.post(ForgeDirection.WEST);
        }
    }

    public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
        if (!this.inWorld || this.func_147744_b() || this.submap == null) {
            super.func_147764_f(block, 0.0, 0.0, 0.0, icon);
        } else {
            int[] tex = this.ctm.getSubmapIndices(this.field_147845_a, this.bx, this.by, this.bz, 5);
            this.pre(ForgeDirection.EAST);
            this.fillLightmap(this.field_147864_al, this.field_147874_am, this.field_147876_an, this.field_147870_ao);
            this.fillColormap(this.field_147872_ap, this.field_147852_aq, this.field_147850_ar, this.field_147848_as, this.redmap);
            this.fillColormap(this.field_147846_at, this.field_147860_au, this.field_147858_av, this.field_147856_aw, this.grnmap);
            this.fillColormap(this.field_147854_ax, this.field_147841_ay, this.field_147839_az, this.field_147833_aA, this.blumap);
            this.getLight(0, 0);
            this.side(block, SubSide.XPOS_LB, tex[0]);
            this.getLight(1, 0);
            this.side(block, SubSide.XPOS_RB, tex[1]);
            this.getLight(1, 1);
            this.side(block, SubSide.XPOS_RT, tex[2]);
            this.getLight(0, 1);
            this.side(block, SubSide.XPOS_LT, tex[3]);
            this.post(ForgeDirection.EAST);
        }
    }

    public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
        if (!this.inWorld || this.func_147744_b() || this.submap == null) {
            super.func_147761_c(block, 0.0, 0.0, 0.0, icon);
        } else {
            int[] tex = this.ctm.getSubmapIndices(this.field_147845_a, this.bx, this.by, this.bz, 2);
            this.pre(ForgeDirection.NORTH);
            this.fillLightmap(this.field_147876_an, this.field_147870_ao, this.field_147864_al, this.field_147874_am);
            this.fillColormap(this.field_147850_ar, this.field_147848_as, this.field_147872_ap, this.field_147852_aq, this.redmap);
            this.fillColormap(this.field_147858_av, this.field_147856_aw, this.field_147846_at, this.field_147860_au, this.grnmap);
            this.fillColormap(this.field_147839_az, this.field_147833_aA, this.field_147854_ax, this.field_147841_ay, this.blumap);
            this.getLight(0, 0);
            this.side(block, SubSide.ZNEG_LB, tex[0]);
            this.getLight(1, 0);
            this.side(block, SubSide.ZNEG_RB, tex[1]);
            this.getLight(1, 1);
            this.side(block, SubSide.ZNEG_RT, tex[2]);
            this.getLight(0, 1);
            this.side(block, SubSide.ZNEG_LT, tex[3]);
            this.post(ForgeDirection.NORTH);
        }
    }

    public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
        if (!this.inWorld || this.func_147744_b() || this.submap == null) {
            super.func_147734_d(block, 0.0, 0.0, 0.0, icon);
        } else {
            int[] tex = this.ctm.getSubmapIndices(this.field_147845_a, this.bx, this.by, this.bz, 3);
            this.pre(ForgeDirection.SOUTH);
            this.fillLightmap(this.field_147874_am, this.field_147876_an, this.field_147870_ao, this.field_147864_al);
            this.fillColormap(this.field_147852_aq, this.field_147850_ar, this.field_147848_as, this.field_147872_ap, this.redmap);
            this.fillColormap(this.field_147860_au, this.field_147858_av, this.field_147856_aw, this.field_147846_at, this.grnmap);
            this.fillColormap(this.field_147841_ay, this.field_147839_az, this.field_147833_aA, this.field_147854_ax, this.blumap);
            this.getLight(0, 0);
            this.side(block, SubSide.ZPOS_LB, tex[0]);
            this.getLight(1, 0);
            this.side(block, SubSide.ZPOS_RB, tex[1]);
            this.getLight(1, 1);
            this.side(block, SubSide.ZPOS_RT, tex[2]);
            this.getLight(0, 1);
            this.side(block, SubSide.ZPOS_LT, tex[3]);
            this.post(ForgeDirection.SOUTH);
        }
    }

    public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
        if (!this.inWorld || this.func_147744_b() || this.submap == null) {
            super.func_147768_a(block, 0.0, 0.0, 0.0, icon);
        } else {
            int[] tex = this.ctm.getSubmapIndices(this.field_147845_a, this.bx, this.by, this.bz, 0);
            this.pre(ForgeDirection.DOWN);
            this.fillLightmap(this.field_147874_am, this.field_147876_an, this.field_147870_ao, this.field_147864_al);
            this.fillColormap(this.field_147852_aq, this.field_147850_ar, this.field_147848_as, this.field_147872_ap, this.redmap);
            this.fillColormap(this.field_147860_au, this.field_147858_av, this.field_147856_aw, this.field_147846_at, this.grnmap);
            this.fillColormap(this.field_147841_ay, this.field_147839_az, this.field_147833_aA, this.field_147854_ax, this.blumap);
            this.getLight(0, 0);
            this.side(block, SubSide.YNEG_LB, tex[0]);
            this.getLight(1, 0);
            this.side(block, SubSide.YNEG_RB, tex[1]);
            this.getLight(1, 1);
            this.side(block, SubSide.YNEG_RT, tex[2]);
            this.getLight(0, 1);
            this.side(block, SubSide.YNEG_LT, tex[3]);
            this.post(ForgeDirection.DOWN);
        }
    }

    public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
        if (!this.inWorld || this.func_147744_b() || this.submap == null) {
            super.func_147806_b(block, 0.0, 0.0, 0.0, icon);
        } else {
            int[] tex = this.ctm.getSubmapIndices(this.field_147845_a, this.bx, this.by, this.bz, 1);
            this.pre(ForgeDirection.UP);
            this.fillLightmap(this.field_147870_ao, this.field_147864_al, this.field_147874_am, this.field_147876_an);
            this.fillColormap(this.field_147848_as, this.field_147872_ap, this.field_147852_aq, this.field_147850_ar, this.redmap);
            this.fillColormap(this.field_147856_aw, this.field_147846_at, this.field_147860_au, this.field_147858_av, this.grnmap);
            this.fillColormap(this.field_147833_aA, this.field_147854_ax, this.field_147841_ay, this.field_147839_az, this.blumap);
            this.getLight(0, 0);
            this.side(block, SubSide.YPOS_LB, tex[0]);
            this.getLight(1, 0);
            this.side(block, SubSide.YPOS_RB, tex[1]);
            this.getLight(1, 1);
            this.side(block, SubSide.YPOS_RT, tex[2]);
            this.getLight(0, 1);
            this.side(block, SubSide.YPOS_LT, tex[3]);
            this.post(ForgeDirection.UP);
        }
    }

    protected void pre(ForgeDirection face) {
        this.manager.preRenderSide(this, this.field_147845_a, this.bx, this.by, this.bz, face);
    }

    protected void post(ForgeDirection face) {
        this.manager.postRenderSide(this, this.field_147845_a, this.bx, this.by, this.bz, face);
    }

    public boolean isInWorld() {
        return this.inWorld;
    }

    protected static enum SubSide {
        XNEG_LB(Vert.ZERO, Vert.Z_HALF, Vert.YZ_HALF, Vert.Y_HALF),
        XNEG_RB(Vert.Z_HALF, Vert.Z, Vert.Y_HALF_Z, Vert.YZ_HALF),
        XNEG_RT(Vert.YZ_HALF, Vert.Y_HALF_Z, Vert.YZ, Vert.Z_HALF_Y),
        XNEG_LT(Vert.Y_HALF, Vert.YZ_HALF, Vert.Z_HALF_Y, Vert.Y),
        XPOS_LB(Vert.XZ, Vert.Z_HALF_X, Vert.YZ_HALF_X, Vert.Y_HALF_XZ),
        XPOS_RB(Vert.Z_HALF_X, Vert.X, Vert.Y_HALF_X, Vert.YZ_HALF_X),
        XPOS_RT(Vert.YZ_HALF_X, Vert.Y_HALF_X, Vert.XY, Vert.Z_HALF_XY),
        XPOS_LT(Vert.Y_HALF_XZ, Vert.YZ_HALF_X, Vert.Z_HALF_XY, Vert.XYZ),
        ZNEG_LB(Vert.X, Vert.X_HALF, Vert.XY_HALF, Vert.Y_HALF_X),
        ZNEG_RB(Vert.X_HALF, Vert.ZERO, Vert.Y_HALF, Vert.XY_HALF),
        ZNEG_RT(Vert.XY_HALF, Vert.Y_HALF, Vert.Y, Vert.X_HALF_Y),
        ZNEG_LT(Vert.Y_HALF_X, Vert.XY_HALF, Vert.X_HALF_Y, Vert.XY),
        ZPOS_LB(Vert.Z, Vert.X_HALF_Z, Vert.XY_HALF_Z, Vert.Y_HALF_Z),
        ZPOS_RB(Vert.X_HALF_Z, Vert.XZ, Vert.Y_HALF_XZ, Vert.XY_HALF_Z),
        ZPOS_RT(Vert.XY_HALF_Z, Vert.Y_HALF_XZ, Vert.XYZ, Vert.X_HALF_YZ),
        ZPOS_LT(Vert.Y_HALF_Z, Vert.XY_HALF_Z, Vert.X_HALF_YZ, Vert.YZ),
        YNEG_LB(Vert.ZERO, Vert.X_HALF, Vert.XZ_HALF, Vert.Z_HALF),
        YNEG_RB(Vert.X_HALF, Vert.X, Vert.Z_HALF_X, Vert.XZ_HALF),
        YNEG_RT(Vert.XZ_HALF, Vert.Z_HALF_X, Vert.XZ, Vert.X_HALF_Z),
        YNEG_LT(Vert.Z_HALF, Vert.XZ_HALF, Vert.X_HALF_Z, Vert.Z),
        YPOS_LB(Vert.YZ, Vert.X_HALF_YZ, Vert.XZ_HALF_Y, Vert.Z_HALF_Y),
        YPOS_RB(Vert.X_HALF_YZ, Vert.XYZ, Vert.Z_HALF_XY, Vert.XZ_HALF_Y),
        YPOS_RT(Vert.XZ_HALF_Y, Vert.Z_HALF_XY, Vert.XY, Vert.X_HALF_Y),
        YPOS_LT(Vert.Z_HALF_Y, Vert.XZ_HALF_Y, Vert.X_HALF_Y, Vert.Y);

        private Vert xmin;
        private Vert xmax;
        private Vert ymin;
        private Vert ymax;
        private ForgeDirection normal;

        private SubSide(Vert xmin, Vert ymin, Vert ymax, Vert xmax) {
            this.xmin = xmin;
            this.ymin = ymin;
            this.ymax = ymax;
            this.xmax = xmax;
            this.normal = this.calcNormal();
        }

        private ForgeDirection calcNormal() {
            double xTot = this.xmin.x + this.xmax.x + this.ymin.x + this.ymax.x;
            double yTot = this.xmin.y + this.xmax.y + this.ymin.y + this.ymax.y;
            double zTot = this.xmin.z + this.xmax.z + this.ymin.z + this.ymax.z;
            if (xTot % 4.0 == 0.0) {
                return xTot > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST;
            }
            if (yTot % 4.0 == 0.0) {
                return yTot > 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
            }
            if (zTot % 4.0 == 0.0) {
                return zTot > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
            }
            return ForgeDirection.UNKNOWN;
        }

        void render(RenderBlocksCTM inst) {
            this.xmin.render(inst, this.normal, 0);
            this.ymin.render(inst, this.normal, 1);
            this.ymax.render(inst, this.normal, 2);
            this.xmax.render(inst, this.normal, 3);
        }
    }

    protected static enum Vert {
        ZERO(0.0, 0.0, 0.0),
        XYZ(1.0, 1.0, 1.0),
        X(1.0, 0.0, 0.0),
        Y(0.0, 1.0, 0.0),
        Z(0.0, 0.0, 1.0),
        XY(1.0, 1.0, 0.0),
        YZ(0.0, 1.0, 1.0),
        XZ(1.0, 0.0, 1.0),
        X_HALF(0.5, 0.0, 0.0),
        Y_HALF(0.0, 0.5, 0.0),
        Z_HALF(0.0, 0.0, 0.5),
        XY_HALF(0.5, 0.5, 0.0),
        YZ_HALF(0.0, 0.5, 0.5),
        XZ_HALF(0.5, 0.0, 0.5),
        X_HALF_Y(0.5, 1.0, 0.0),
        X_HALF_Z(0.5, 0.0, 1.0),
        Y_HALF_X(1.0, 0.5, 0.0),
        Y_HALF_Z(0.0, 0.5, 1.0),
        Z_HALF_X(1.0, 0.0, 0.5),
        Z_HALF_Y(0.0, 1.0, 0.5),
        X_HALF_YZ(0.5, 1.0, 1.0),
        Y_HALF_XZ(1.0, 0.5, 1.0),
        Z_HALF_XY(1.0, 1.0, 0.5),
        XY_HALF_Z(0.5, 0.5, 1.0),
        YZ_HALF_X(1.0, 0.5, 0.5),
        XZ_HALF_Y(0.5, 1.0, 0.5);

        private double x;
        private double y;
        private double z;
        private static double u;
        private static double v;
        private static double xDiff;
        private static double yDiff;
        private static double zDiff;
        private static double uDiff;
        private static double vDiff;

        private Vert(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        void render(RenderBlocksCTM inst, ForgeDirection normal, int cacheID) {
            if (inst.field_147863_w) {
                inst.tessellator.func_78386_a(inst.redCache[cacheID], inst.grnCache[cacheID], inst.bluCache[cacheID]);
                inst.tessellator.func_78380_c(inst.lightingCache[cacheID]);
            }
            u = cacheID == 1 || cacheID == 2 ? inst.maxU : inst.minU;
            v = cacheID < 2 ? inst.maxV : inst.minV;
            uDiff = inst.maxU - inst.minU;
            vDiff = inst.maxV - inst.minV;
            if (inst.field_147859_h + inst.field_147855_j + inst.field_147851_l != 0.0 || inst.field_147861_i + inst.field_147857_k + inst.field_147853_m != 3.0) {
                boolean uMin = u == inst.minU;
                boolean vMin = v == inst.minV;
                xDiff = inst.field_147861_i - inst.field_147859_h;
                yDiff = inst.field_147857_k - inst.field_147855_j;
                zDiff = inst.field_147853_m - inst.field_147851_l;
                if (normal.offsetY != 0) {
                    uDiff *= uMin ? inst.field_147859_h : 1.0 - inst.field_147861_i;
                    vDiff *= vMin ? inst.field_147851_l : 1.0 - inst.field_147853_m;
                } else if (normal.offsetX != 0) {
                    uDiff *= uMin ? inst.field_147851_l : 1.0 - inst.field_147853_m;
                    vDiff *= vMin ? inst.field_147855_j : 1.0 - inst.field_147857_k;
                } else if (normal.offsetZ != 0) {
                    uDiff *= uMin ? inst.field_147859_h : 1.0 - inst.field_147861_i;
                    vDiff *= vMin ? inst.field_147855_j : 1.0 - inst.field_147857_k;
                }
                u = u == inst.minU ? inst.minU + uDiff : inst.maxU - uDiff;
                v = v == inst.minV ? inst.minV + vDiff : inst.maxV - vDiff;
            } else {
                zDiff = 1.0;
                yDiff = 1.0;
                xDiff = 1.0;
            }
            inst.tessellator.func_78374_a(inst.field_147859_h + this.x * xDiff, inst.field_147855_j + this.y * yDiff, inst.field_147851_l + this.z * zDiff, u, v);
        }
    }
}

