/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.util.CustomEntry;
import chanceCubes.util.Location2I;
import chanceCubes.util.Location3I;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.world.World;

public class MazeGenerator {
    private int width;
    private int height;
    private int[][] map;
    private ArrayList<Location2I> walls = new ArrayList();
    private Map<Location3I, CustomEntry<Block, Integer>> blockStorgae = new HashMap<Location3I, CustomEntry<Block, Integer>>();
    private Map<Location3I, NBTTagCompound> tileStorgae = new HashMap<Location3I, NBTTagCompound>();
    private Random r = new Random();
    private int currentX = 1;
    private int currentY = 1;
    private final int nonWall = 0;
    private final int wall = 1;
    private Location2I endBlock;
    public Location3I endBlockWorldCords;

    public void generate(World world, int x1, int y1, int z1, int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.map[x][y] = 1;
            }
        }
        this.map[1][1] = 0;
        this.currentX = 1;
        this.currentY = 1;
        Location2I current = new Location2I(this.currentX, this.currentY);
        Location2I north = current.add(0, -1);
        Location2I east = current.add(1, 0);
        Location2I south = current.add(0, 1);
        Location2I west = current.add(-1, 0);
        if (north.getY() > 0 && this.map[north.getX()][north.getY()] == 1 && this.map[north.getX()][north.getY() - 1] == 1) {
            this.walls.add(north);
        }
        if (east.getX() < width && this.map[east.getX()][east.getY()] == 1 && this.map[east.getX() + 1][east.getY()] == 1) {
            this.walls.add(east);
        }
        if (south.getY() < height && this.map[south.getX()][south.getY()] == 1 && this.map[south.getX()][south.getY() + 1] == 1) {
            this.walls.add(south);
        }
        if (west.getX() > 0 && this.map[west.getX()][west.getY()] == 1 && this.map[west.getX() - 1][west.getY()] == 1) {
            this.walls.add(west);
        }
        int randomLoc = 0;
        while (this.walls.size() > 0) {
            randomLoc = this.r.nextInt(this.walls.size());
            this.currentX = this.walls.get(randomLoc).getX();
            this.currentY = this.walls.get(randomLoc).getY();
            current.setXY(this.currentX, this.currentY);
            north = current.add(0, -1);
            east = current.add(1, 0);
            south = current.add(0, 1);
            west = current.add(-1, 0);
            if (!this.checkwalls(current)) {
                this.map[this.currentX][this.currentY] = 0;
                this.walls.remove(randomLoc);
                if (north.getY() - 1 > 0 && this.map[north.getX()][north.getY()] == 1 && this.map[north.getX()][north.getY() - 1] == 1) {
                    this.walls.add(north);
                }
                if (east.getX() + 1 < width && this.map[east.getX()][east.getY()] == 1 && this.map[east.getX() + 1][east.getY()] == 1) {
                    this.walls.add(east);
                }
                if (south.getY() + 1 < height && this.map[south.getX()][south.getY()] == 1 && this.map[south.getX()][south.getY() + 1] == 1) {
                    this.walls.add(south);
                }
                if (west.getX() - 1 <= 0 || this.map[west.getX()][west.getY()] != 1 || this.map[west.getX() - 1][west.getY()] != 1) continue;
                this.walls.add(west);
                continue;
            }
            this.walls.remove(randomLoc);
        }
        int endBlockX = width - 1;
        int endBlockZ = height - 1;
        boolean run = true;
        int i = 0;
        int xx = 0;
        int zz = 0;
        while (run) {
            for (xx = 0; xx <= i; ++xx) {
                for (zz = i; zz >= 0; --zz) {
                    if (this.map[endBlockX - xx][endBlockZ - zz] != this.nonWall || !run) continue;
                    this.endBlock = new Location2I(endBlockX - xx, endBlockZ - zz);
                    run = false;
                }
            }
            ++i;
        }
        this.placeBlocks(world, x1, y1, z1);
    }

    private boolean checkwalls(Location2I loc) {
        Location2I north = loc.add(0, -1);
        Location2I east = loc.add(1, 0);
        Location2I south = loc.add(0, 1);
        Location2I west = loc.add(-1, 0);
        int yes = 0;
        if (north.getY() >= 0 && this.map[north.getX()][north.getY()] == 0) {
            ++yes;
        }
        if (east.getX() < this.width && this.map[east.getX()][east.getY()] == 0) {
            ++yes;
        }
        if (south.getY() < this.height && this.map[south.getX()][south.getY()] == 0) {
            ++yes;
        }
        if (west.getX() >= 0 && this.map[west.getX()][west.getY()] == 0) {
            ++yes;
        }
        return yes > 1;
    }

    private void placeBlocks(World world, int x, int y, int z) {
        TileEntity temp;
        int xoff = x - this.width / 2;
        int zoff = z - this.height / 2;
        NBTTagCompound nbt = new NBTTagCompound();
        for (int xx = 0; xx < this.width; ++xx) {
            for (int zz = 0; zz < this.height; ++zz) {
                int yy;
                if (this.map[xx][zz] == 0) {
                    for (yy = -1; yy < 3; ++yy) {
                        this.blockStorgae.put(new Location3I(xoff + xx, y + yy, zoff + zz), new CustomEntry<Block, Integer>(world.func_147439_a(xoff + xx, y + yy, zoff + zz), world.func_72805_g(xoff + xx, y + yy, zoff + zz)));
                        temp = world.func_147438_o(xoff + xx, y + yy, zoff + zz);
                        if (temp == null) continue;
                        temp.func_145841_b(nbt);
                        this.tileStorgae.put(new Location3I(xoff + xx, y + yy, zoff + zz), nbt);
                    }
                    world.func_147449_b(xoff + xx, y - 1, zoff + zz, Blocks.field_150357_h);
                    world.func_147449_b(xoff + xx, y, zoff + zz, Blocks.field_150478_aa);
                    world.func_72921_c(xoff + xx, y, zoff + zz, 0, 3);
                    world.func_147468_f(xoff + xx, y + 1, zoff + zz);
                    world.func_147449_b(xoff + xx, y + 2, zoff + zz, Blocks.field_150357_h);
                    continue;
                }
                for (yy = -1; yy < 3; ++yy) {
                    this.blockStorgae.put(new Location3I(xoff + xx, y + yy, zoff + zz), new CustomEntry<Block, Integer>(world.func_147439_a(xoff + xx, y + yy, zoff + zz), world.func_72805_g(xoff + xx, y + yy, zoff + zz)));
                    temp = world.func_147438_o(xoff + xx, y + yy, zoff + zz);
                    if (temp == null) continue;
                    temp.func_145841_b(nbt);
                    this.tileStorgae.put(new Location3I(xoff + xx, y + yy, zoff + zz), nbt);
                }
                world.func_147468_f(xoff + xx, y - 1, zoff + zz);
                world.func_147449_b(xoff + xx, y, zoff + zz, Blocks.field_150357_h);
                world.func_147449_b(xoff + xx, y + 1, zoff + zz, Blocks.field_150357_h);
                world.func_147468_f(xoff + xx, y + 2, zoff + zz);
            }
        }
        this.endBlockWorldCords = new Location3I(xoff + this.endBlock.getX(), y, zoff + this.endBlock.getY());
        world.func_147465_d(xoff + this.endBlock.getX(), y, zoff + this.endBlock.getY(), Blocks.field_150472_an, 6, 2);
        temp = world.func_147438_o(xoff + this.endBlock.getX(), y, zoff + this.endBlock.getY());
        if (temp instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)temp;
            sign.field_145915_a[0] = "Break me";
            sign.field_145915_a[1] = "To beat the";
            sign.field_145915_a[2] = "Maze";
        }
    }

    public void endMaze(World world) {
        for (Location3I loc : this.blockStorgae.keySet()) {
            world.func_147465_d(loc.getX(), loc.getY(), loc.getZ(), this.blockStorgae.get(loc).getKey(), this.blockStorgae.get(loc).getValue().intValue(), 2);
        }
        for (Location3I loc : this.tileStorgae.keySet()) {
            world.func_147455_a(loc.getX(), loc.getY(), loc.getZ(), TileEntity.func_145827_c((NBTTagCompound)this.tileStorgae.get(loc)));
        }
    }
}

