/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.config.CCubesSettings;
import chanceCubes.registry.ChanceCubeRegistry;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileChanceD20
extends TileEntity {
    private static final float BASE_SPIN_SPEED = 0.5f;
    private Random random = new Random();
    private boolean breaking = false;
    private int stage = 0;
    public float rotation = 0.0f;
    public float rotationDelta = 0.0f;
    private EntityPlayer player;
    private int chance;
    private boolean isScanned = false;

    public TileChanceD20() {
        if (!CCubesSettings.d20UseNormalChances) {
            this.chance = this.random.nextBoolean() ? -100 : 100;
        } else {
            this.chance = Math.round((float)(this.random.nextGaussian() * 40.0));
            while (this.chance > 100 || this.chance < -100) {
                this.chance = Math.round((float)(this.random.nextGaussian() * 40.0));
            }
        }
    }

    public TileChanceD20(int initialChance) {
        this.chance = initialChance;
    }

    public void setChance(int newChance) {
        this.chance = newChance;
    }

    public int getChance() {
        return this.chance;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a((double)this.field_145851_c, (double)(this.field_145848_d + 3), (double)this.field_145849_e).func_72314_b(5.0, 5.0, 5.0);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeSyncableDataToNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readSyncableDataFromNBT(nbt);
    }

    public void func_145845_h() {
        if (!this.breaking) {
            return;
        }
        ++this.stage;
        if (this.stage > 200) {
            this.breaking = false;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ChanceCubeRegistry.INSTANCE.triggerRandomReward(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.player, this.getChance());
            }
        } else if (this.field_145850_b.field_72995_K) {
            this.rotationDelta = (float)(0.5 + Math.pow(1.02, this.getStage() + 1));
            this.rotation += (float)(0.5 + Math.pow(1.02, this.getStage()));
        }
    }

    public void startBreaking(EntityPlayer player) {
        if (!this.breaking) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "chancecubes:d20_Break", 1.0f, 1.0f);
                this.player = player;
            }
            this.breaking = true;
            this.stage = 0;
        }
    }

    public int getStage() {
        return this.stage;
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    private void writeSyncableDataToNBT(NBTTagCompound syncData) {
        syncData.func_74768_a("chance", this.getChance());
    }

    private void readSyncableDataFromNBT(NBTTagCompound nbt) {
        this.chance = nbt.func_74762_e("chance");
    }

    public boolean isScanned() {
        return this.isScanned;
    }

    public void setScanned(boolean isScanned) {
        this.isScanned = isScanned;
    }
}

