/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.CustomEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ChunkReverserReward
implements IChanceCubeReward {
    private List<Map.Entry<Block, Block>> swappedMap = new ArrayList<Map.Entry<Block, Block>>();

    public ChunkReverserReward() {
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150348_b, Blocks.field_150346_d));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150346_d, Blocks.field_150347_e));
        this.swappedMap.add(new CustomEntry<BlockGrass, Block>(Blocks.field_150349_c, Blocks.field_150348_b));
        this.swappedMap.add(new CustomEntry<Block, BlockSand>(Blocks.field_150351_n, Blocks.field_150354_m));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150366_p, Blocks.field_150352_o));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150365_q, Blocks.field_150482_ag));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150482_ag, Blocks.field_150365_q));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150352_o, Blocks.field_150366_p));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150353_l, Blocks.field_150355_j));
        this.swappedMap.add(new CustomEntry<Block, Block>(Blocks.field_150355_j, Blocks.field_150353_l));
        this.swappedMap.add(new CustomEntry<Block, BlockLeaves>(Blocks.field_150364_r, Blocks.field_150362_t));
        this.swappedMap.add(new CustomEntry<Block, BlockLeaves>(Blocks.field_150363_s, Blocks.field_150361_u));
        this.swappedMap.add(new CustomEntry<BlockLeaves, Block>(Blocks.field_150362_t, Blocks.field_150364_r));
        this.swappedMap.add(new CustomEntry<BlockLeaves, Block>(Blocks.field_150361_u, Blocks.field_150363_s));
    }

    @Override
    public void trigger(World world, int x, int y, int z, EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText("Initiating Block Inverter"));
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int yy = 256; yy > 0; --yy) {
            int xx = 0;
            int zz = 0;
            int dx = 0;
            int dy = -1;
            int t = 16;
            int maxI = t * t;
            for (int i = 0; i < maxI; ++i) {
                if (-8 <= xx && xx <= 8 && -8 <= zz && zz <= 8) {
                    Block blockAt = world.func_147439_a(x + xx, yy, z + zz);
                    Block toSwapTo = null;
                    for (Map.Entry<Block, Block> blockSwap : this.swappedMap) {
                        if (!blockSwap.getKey().equals(blockAt)) continue;
                        toSwapTo = blockSwap.getValue();
                    }
                    if (toSwapTo != null) {
                        blocks.add(new OffsetBlock(xx, yy - y, zz, toSwapTo, false, delay / 5));
                        ++delay;
                    }
                }
                if (xx == zz || xx < 0 && xx == -zz || xx > 0 && xx == 1 - zz) {
                    t = dx;
                    dx = -dy;
                    dy = t;
                }
                xx += dx;
                zz += dy;
            }
        }
        player.func_145747_a((IChatComponent)new ChatComponentText("Inverting " + blocks.size() + " Blocks... May take a minute..."));
        for (OffsetBlock b : blocks) {
            b.spawnInWorld(world, x, y, z);
        }
    }

    @Override
    public int getChanceValue() {
        return 0;
    }

    @Override
    public String getName() {
        return "chancecubes:Chuck_Reverse";
    }
}

