/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import framesapi.BlockPos;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSlider
extends TilePusher {
    private static Random rand = new Random();
    private ForgeDirection slideDir = ForgeDirection.UNKNOWN;
    private static final int[][] orthog = new int[][]{{6, 6, 5, 4, 3, 2, 6}, {6, 6, 4, 5, 2, 3, 6}, {5, 4, 6, 6, 1, 0, 6}, {4, 5, 6, 6, 0, 1, 6}, {3, 2, 1, 0, 6, 6, 6}, {2, 3, 0, 1, 6, 6, 6}, {6, 6, 6, 6, 6, 6, 6}};

    public void rotateAboutAxis() {
        ForgeDirection dir = this.getFacing();
        ForgeDirection slide = this.getSlideDir();
        this.slideDir = slide.getRotation(dir);
    }

    public static ForgeDirection getOrthogonal(ForgeDirection a, ForgeDirection b) {
        return ForgeDirection.getOrientation((int)orthog[a.ordinal()][b.ordinal()]);
    }

    public ForgeDirection getSlideDir() {
        ForgeDirection ang = this.getFacing();
        if (TileSlider.getOrthogonal(ang, this.slideDir) == ForgeDirection.UNKNOWN) {
            int j = (this.field_145851_c + this.field_145848_d + this.field_145849_e) % 6;
            while (j >= 6 || TileSlider.getOrthogonal(ForgeDirection.getOrientation((int)j), ang) == ForgeDirection.UNKNOWN) {
                j = (j + 1) % 6;
            }
            this.slideDir = ForgeDirection.getOrientation((int)j);
        }
        return this.slideDir;
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() % 6));
    }

    public void setSlideDir(ForgeDirection dir) {
        this.slideDir = dir;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.slideDir = ForgeDirection.getOrientation((int)tag.func_74771_c("SlideDirection"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("SlideDirection", (byte)this.slideDir.ordinal());
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.slideDir = ForgeDirection.getOrientation((int)pkt.func_148857_g().func_74771_c("dir"));
        if (this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("dir", (byte)this.getSlideDir().ordinal());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    @Override
    public ForgeDirection getDirection() {
        return this.getSlideDir();
    }

    @Override
    public List<BlockPos> getBlocks(World world, BlockPos home, ForgeDirection dir, boolean push) {
        ForgeDirection slide = this.getSlideDir();
        BlockPos advance = home.advance(dir);
        if (BlockHelper.canStick(world, advance, dir.getOpposite())) {
            return this.getBlocks(world, home, advance, slide);
        }
        return null;
    }
}

