/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.reference;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.util.HashMap;

public class Mods {
    public static final String AsieLib = "asielib";
    public static final String AsieLib_NAME = "AsieLib";
    public static final String AE2 = "appliedenergistics2";
    public static final String IC2 = "IC2";
    public static final String IC2Classic = "IC2-Classic";
    public static final String GregTech = "gregtech";
    public static final String Mekanism = "Mekanism";
    public static final String ProjectRed = "ProjRed|Core";
    public static final String RedLogic = "RedLogic";
    private static boolean checkedEnergyMods = false;
    private static boolean hasEnergyMod = false;

    public static boolean isLoaded(String name) {
        return Loader.isModLoaded((String)name);
    }

    public static boolean hasEnergyMod() {
        if (!checkedEnergyMods) {
            hasEnergyMod = API.hasAPI("CoFHAPI|energy") || Mods.isLoaded(IC2) || Mods.isLoaded(IC2Classic);
            checkedEnergyMods = true;
        }
        return hasEnergyMod;
    }

    public static class API {
        public static final String BuildCraftTools = "BuildCraftAPI|tools";
        public static final String CoFHBlocks = "CoFHAPI|block";
        public static final String CoFHEnergy = "CoFHAPI|energy";
        public static final String CoFHItems = "CoFHAPI|item";
        public static final String CoFHTileEntities = "CoFHAPI|tileentity";
        public static final String EiraIRC = "EiraIRC|API";
        public static final String EnderIOTools = "EnderIOAPI|Tools";
        public static final String OpenComputersInternal = "OpenComputersAPI|Internal";
        private static HashMap<String, ArtifactVersion> apiList;

        public static ArtifactVersion getVersion(String name) {
            if (apiList == null) {
                apiList = new HashMap();
                Iterable apis = ModAPIManager.INSTANCE.getAPIList();
                for (ModContainer api : apis) {
                    apiList.put(api.getModId(), api.getProcessedVersion());
                }
            }
            if (apiList.containsKey(name)) {
                return apiList.get(name);
            }
            throw new IllegalArgumentException("API '" + name + "' does not exist!");
        }

        public static boolean hasVersion(String name, String version) {
            if (ModAPIManager.INSTANCE.hasAPI(name)) {
                ArtifactVersion v1 = VersionParser.parseVersionReference((String)(name + "@" + version));
                ArtifactVersion v2 = API.getVersion(name);
                return v1.containsVersion(v2);
            }
            return false;
        }

        public static boolean hasAPI(String name) {
            return ModAPIManager.INSTANCE.hasAPI(name);
        }
    }
}

