/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.init.recipes;

import com.google.common.collect.Lists;
import com.nauktis.solarflux.init.ModBlocks;
import com.nauktis.solarflux.init.ModItems;
import com.nauktis.solarflux.init.recipes.AbstractRecipeRegistrar;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class VanillaRecipeRegistrar
extends AbstractRecipeRegistrar {
    @Override
    public void registerRecipes() {
        this.registerCellRecipes();
        this.registerSolarPanelRecipes();
        this.registerUpgradeRecipes();
    }

    protected void registerCellRecipes() {
        this.registerMirrorRecipe();
        this.registerCell1Recipe();
        this.registerCell2Recipe();
        this.registerCell3Recipe();
        this.registerCell4Recipe();
    }

    protected void registerSolarPanelRecipes() {
        if (ModBlocks.getSolarPanels().size() > 0) {
            this.registerSolarPanel0();
        }
        if (ModBlocks.getSolarPanels().size() > 1) {
            this.registerSolarPanel1();
        }
        if (ModBlocks.getSolarPanels().size() > 2) {
            this.registerSolarPanel2();
        }
        if (ModBlocks.getSolarPanels().size() > 3) {
            this.registerSolarPanel3();
        }
        if (ModBlocks.getSolarPanels().size() > 4) {
            this.registerSolarPanel4();
        }
        if (ModBlocks.getSolarPanels().size() > 5) {
            this.registerSolarPanel5();
        }
        for (int tier = 6; tier < ModBlocks.getSolarPanels().size(); ++tier) {
            this.registerSolarPanel(tier);
        }
    }

    protected void registerUpgradeRecipes() {
        if (ModItems.mUpgradeBlank != null) {
            this.registerUpgradeBlank();
        }
        if (ModItems.mUpgradeEfficiency != null) {
            this.registerUpgradeEfficiency();
        }
        if (ModItems.mUpgradeLowLight != null) {
            this.registerUpgradeLowLight();
        }
        if (ModItems.mUpgradeTraversal != null) {
            this.registerUpgradeTraversal();
        }
        if (ModItems.mUpgradeTransferRate != null) {
            this.registerUpgradeTransferRate();
        }
        if (ModItems.mUpgradeCapacity != null) {
            this.registerUpgradeCapacity();
        }
        if (ModItems.mUpgradeFurnace != null) {
            this.registerUpgradeFurnace();
        }
    }

    protected void registerMirrorRecipe() {
        ArrayList metals = Lists.newArrayList((Object[])new String[]{"ingotIron"});
        if (VanillaRecipeRegistrar.knowsOre("ingotTin")) {
            metals.add("ingotTin");
        }
        if (VanillaRecipeRegistrar.knowsOre("ingotAluminum")) {
            metals.add("ingotAluminum");
        }
        if (VanillaRecipeRegistrar.knowsOre("ingotAluminium")) {
            metals.add("ingotAluminium");
        }
        for (String metal : metals) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModItems.mMirror, 2), new Object[]{"ggg", " i ", Character.valueOf('g'), "blockGlass", Character.valueOf('i'), metal}));
        }
    }

    protected void registerCell1Recipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell1, new Object[]{"ggg", "lll", "mmm", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), "gemLapis", Character.valueOf('m'), ModItems.mMirror}));
    }

    protected void registerCell2Recipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell2, new Object[]{"clc", "lcl", "msm", Character.valueOf('c'), Items.field_151119_aD, Character.valueOf('l'), "gemLapis", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('s'), ModItems.mSolarCell1}));
    }

    protected void registerCell3Recipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell3, new Object[]{"ggg", "lll", "oco", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), "dustGlowstone", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('c'), ModItems.mSolarCell2}));
    }

    protected void registerCell4Recipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mSolarCell4, new Object[]{"bbb", "gdg", "qcq", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('g'), "dustGlowstone", Character.valueOf('d'), "blockDiamond", Character.valueOf('q'), "blockQuartz", Character.valueOf('c'), ModItems.mSolarCell3}));
    }

    protected void registerSolarPanel0() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(0), new Object[]{"mmm", "prp", "ppp", Character.valueOf('m'), ModItems.mMirror, Character.valueOf('p'), "plankWood", Character.valueOf('r'), "dustRedstone"}));
    }

    protected void registerSolarPanel1() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(1), new Object[]{"sss", "sps", "sss", Character.valueOf('s'), ModBlocks.getSolarPanels().get(0), Character.valueOf('p'), Blocks.field_150331_J}));
    }

    protected void registerSolarPanel2() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(2), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell1, Character.valueOf('s'), ModBlocks.getSolarPanels().get(1), Character.valueOf('c'), Items.field_151107_aW, Character.valueOf('b'), this.getFirstOreAvailable("blockCopper", "blockIron")}));
    }

    protected void registerSolarPanel3() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(3), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell2, Character.valueOf('s'), ModBlocks.getSolarPanels().get(2), Character.valueOf('c'), Items.field_151113_aN, Character.valueOf('b'), "blockIron"}));
    }

    protected void registerSolarPanel4() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(4), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell3, Character.valueOf('s'), ModBlocks.getSolarPanels().get(3), Character.valueOf('c'), Blocks.field_150379_bu, Character.valueOf('b'), "blockGold"}));
    }

    protected void registerSolarPanel5() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(5), new Object[]{"ppp", "scs", "sbs", Character.valueOf('p'), ModItems.mSolarCell4, Character.valueOf('s'), ModBlocks.getSolarPanels().get(4), Character.valueOf('c'), Blocks.field_150379_bu, Character.valueOf('b'), "blockDiamond"}));
    }

    protected void registerSolarPanel(int pTier) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Block)ModBlocks.getSolarPanels().get(pTier), new Object[]{"ccc", "sbs", "ccc", Character.valueOf('c'), ModItems.mSolarCell4, Character.valueOf('s'), ModBlocks.getSolarPanels().get(pTier - 1), Character.valueOf('b'), "blockDiamond"}));
    }

    protected void registerUpgradeBlank() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeBlank, new Object[]{" c ", "cmc", " c ", Character.valueOf('c'), "cobblestone", Character.valueOf('m'), ModItems.mMirror}));
    }

    protected void registerUpgradeEfficiency() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeEfficiency, new Object[]{" c ", "cuc", " s ", Character.valueOf('c'), ModItems.mSolarCell1, Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('s'), ModItems.mSolarCell2}));
    }

    protected void registerUpgradeLowLight() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeLowLight, new Object[]{"ggg", "lul", "ggg", Character.valueOf('g'), "blockGlass", Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('l'), "dustGlowstone"}));
    }

    protected void registerUpgradeTraversal() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeTraversal, new Object[]{"i i", "rur", "i i", Character.valueOf('i'), this.getFirstOreAvailable("ingotAluminum", "ingotAluminium", "ingotTin", "ingotIron"), Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('r'), "dustRedstone"}));
    }

    protected void registerUpgradeTransferRate() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeTransferRate, new Object[]{"rrr", "gug", "rrr", Character.valueOf('r'), "dustRedstone", Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('g'), "ingotGold"}));
    }

    protected void registerUpgradeCapacity() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeCapacity, new Object[]{" r ", "rur", "rcr", Character.valueOf('r'), "dustRedstone", Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('c'), "blockRedstone"}));
    }

    protected void registerUpgradeFurnace() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ModItems.mUpgradeFurnace, new Object[]{"ccc", "cuc", "cfc", Character.valueOf('c'), Items.field_151044_h, Character.valueOf('u'), ModItems.mUpgradeBlank, Character.valueOf('f'), Blocks.field_150460_al}));
    }
}

