/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledConductor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IInsulatedRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.redstone.RedstoneConnection;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.misc.Pair;

public class BundledDeviceWrapper
implements IRedstoneConductor.IAdvancedRedstoneConductor {
    private static List<BundledDeviceWrapper> l = new ArrayList<BundledDeviceWrapper>();
    private IBundledDevice device;
    private MinecraftColor color;
    private RedstoneConnectionCacheWrapper connections = new RedstoneConnectionCacheWrapper(this);

    public static BundledDeviceWrapper wrap(IBundledDevice device, MinecraftColor color) {
        for (BundledDeviceWrapper w : l) {
            if (!w.device.equals(device) || w.color != color) continue;
            return w;
        }
        BundledDeviceWrapper w = new BundledDeviceWrapper(device, color);
        l.add(w);
        return w;
    }

    private BundledDeviceWrapper(IBundledDevice device, MinecraftColor color) {
        this.device = device;
        this.color = color;
    }

    public World getWorld() {
        return this.device.getWorld();
    }

    public int getX() {
        return this.device.getX();
    }

    public int getY() {
        return this.device.getY();
    }

    public int getZ() {
        return this.device.getZ();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice dev, ConnectionType type) {
        return true;
    }

    @Override
    public IConnectionCache<? extends IRedstoneDevice> getRedstoneConnectionCache() {
        return this.connections;
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        byte[] b = this.device.getBundledOutput(side);
        if (b == null) {
            return 0;
        }
        return b[this.color.ordinal()];
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
        byte[] b = this.device.getBundledPower(side);
        if (b == null) {
            b = new byte[16];
        }
        b[this.color.ordinal()] = power;
        this.device.setBundledPower(side, b);
    }

    @Override
    public void onRedstoneUpdate() {
        this.device.onBundledUpdate();
    }

    @Override
    public boolean canPropagateFrom(ForgeDirection fromSide) {
        if (!(this.device instanceof IBundledConductor)) {
            return false;
        }
        return ((IBundledConductor)this.device).canPropagateBundledFrom(fromSide);
    }

    @Override
    public boolean hasLoss(ForgeDirection side) {
        if (!(this.device instanceof IBundledConductor)) {
            return false;
        }
        return ((IBundledConductor)this.device).hasLoss(side);
    }

    @Override
    public boolean isAnalogue(ForgeDirection side) {
        if (!(this.device instanceof IBundledConductor)) {
            return false;
        }
        return ((IBundledConductor)this.device).isAnalogue(side);
    }

    @Override
    public Collection<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
        ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            IConnection<IRedstoneDevice> c = this.connections.getConnectionOnSide(d);
            if (c == null) continue;
            l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)(c.getB() instanceof IRedwire && this.device instanceof IRedwire && ((IRedwire)((Object)c.getB())).getRedwireType(c.getSideB()) != ((IRedwire)((Object)this.device)).getRedwireType(c.getSideA()) ? 1 : 0)));
        }
        return l;
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return this.device.isNormalFace(side);
    }

    private class RedstoneConnectionCacheWrapper
    extends RedstoneConnectionCache {
        private BundledDeviceWrapper wrapper;
        private IConnection[] originalCons;
        private IConnection[] cons;

        public RedstoneConnectionCacheWrapper(BundledDeviceWrapper dev) {
            super(dev);
            this.originalCons = new IConnection[7];
            this.cons = new IConnection[7];
            this.wrapper = dev;
        }

        @Override
        public IConnection<IRedstoneDevice> getConnectionOnSide(ForgeDirection side) {
            IConnection<IRedstoneDevice> c;
            if (this.wrapper.device instanceof IRedwire.IInsulatedRedwire && ((IRedstoneDevice)((Object)this.wrapper.device)).getRedstoneConnectionCache() != null && (c = ((IRedstoneDevice)((Object)this.wrapper.device)).getRedstoneConnectionCache().getConnectionOnSide(side)) != null) {
                return c;
            }
            IConnection<? extends IBundledDevice> original = this.wrapper.device.getBundledConnectionCache().getConnectionOnSide(side);
            if (original != this.originalCons[side.ordinal()]) {
                this.cons[side.ordinal()] = original != null ? (!(original.getB() instanceof IInsulatedRedstoneDevice) || original.getB() instanceof IInsulatedRedstoneDevice && this.wrapper.color.equals((Object)((IInsulatedRedstoneDevice)((Object)original.getB())).getInsulationColor(original.getSideB())) ? new RedstoneConnection(BundledDeviceWrapper.this, BundledDeviceWrapper.wrap(original.getB(), BundledDeviceWrapper.this.color), side, original.getSideB(), original.getType()) : null) : null;
                this.originalCons[side.ordinal()] = original;
            }
            return this.cons[side.ordinal()];
        }

        @Override
        public void recalculateConnections() {
        }
    }
}

