/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.Camera;

public class TileCamera
extends TileEntityPeripheralBase {
    private static final int CALL_LIMIT = 20;
    private final Camera camera = new Camera();
    private final Camera cameraRedstone = new Camera();
    private int tick;
    private float _nedo_xDir;
    private float _nedo_yDir;

    public TileCamera() {
        super("camera");
    }

    public boolean canUpdate() {
        return true;
    }

    private ForgeDirection getFacingDirection() {
        return Computronics.camera.getFacingDirection(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int requestCurrentRedstoneValue(int side) {
        double distance = this.cameraRedstone.getDistance();
        if (distance > 0.0) {
            return 15 - (int)Math.min(15L, Math.round(distance / 2.0));
        }
        return 0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.tick % 20 == 0 && Config.REDSTONE_REFRESH) {
            this.cameraRedstone.ray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getFacingDirection(), 0.0f, 0.0f);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        ++this.tick;
    }

    @Callback(doc="function([x:number, y:number]):number; Returns the distance to the block the ray is shot at with the specified x-y offset, or of the block directly in front", direct=true, limit=20)
    @Optional.Method(modid="OpenComputers")
    public Object[] distance(Context context, Arguments args) {
        float x = 0.0f;
        float y = 0.0f;
        if (args.count() == 2) {
            x = (float)args.checkDouble(0);
            y = (float)args.checkDouble(1);
        }
        this.camera.ray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getFacingDirection(), x, y);
        return new Object[]{this.camera.getDistance()};
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"distance"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (this.camera == null) {
            return null;
        }
        switch (method) {
            case 0: {
                float x = 0.0f;
                float y = 0.0f;
                if (arguments.length == 2 && arguments[0] instanceof Double && arguments[1] instanceof Double) {
                    x = ((Double)arguments[0]).floatValue();
                    y = ((Double)arguments[1]).floatValue();
                }
                this.camera.ray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getFacingDirection(), x, y);
                return new Object[]{this.camera.getDistance()};
            }
        }
        return null;
    }

    @Optional.Method(modid="nedocomputers")
    public short busRead(int addr) {
        switch (addr & 0xFFFE) {
            case 4: {
                return (short)(this.camera.getDistance() * 64.0);
            }
        }
        return 0;
    }

    @Optional.Method(modid="nedocomputers")
    public void busWrite(int addr, short data) {
        float dataAsDir = (float)data / 32768.0f;
        switch (addr & 0xFFFE) {
            case 0: {
                this._nedo_xDir = dataAsDir;
                break;
            }
            case 2: {
                this._nedo_yDir = dataAsDir;
            }
        }
        if (addr < 4) {
            this.camera.ray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getFacingDirection(), this._nedo_xDir, this._nedo_yDir);
        }
    }
}

