/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc;

import java.io.IOException;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.util.boom.SelfDestruct;
import pl.asie.lib.network.Packet;

public class DriverCardBoom
extends li.cil.oc.api.prefab.ManagedEnvironment {
    protected final EnvironmentHost container;
    private ManagedEnvironment oc_fs;
    private int time = -1;

    public DriverCardBoom(EnvironmentHost container) {
        this.container = container;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("self_destruct").create());
        if (this.node() != null) {
            this.initOCFilesystem();
        }
    }

    private void initOCFilesystem() {
        this.oc_fs = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(Computronics.class, (String)"computronics", (String)"lua/component/self_destruct"), (String)"self_destruct");
        ((Component)this.oc_fs.node()).setVisibility(Visibility.Neighbors);
    }

    public void onConnect(Node node) {
        if (node.host() instanceof Context) {
            node.connect(this.oc_fs.node());
        }
    }

    public void onDisconnect(Node node) {
        if (node.host() instanceof Context) {
            node.disconnect(this.oc_fs.node());
        } else if (node == this.node()) {
            this.time = -1;
            this.oc_fs.node().remove();
        }
    }

    public void onMessage(Message message) {
        super.onMessage(message);
        if ((message.name().equals("computer.stopped") || message.name().equals("computer.started")) && this.node().isNeighborOf(message.source())) {
            this.time = -1;
        }
    }

    @Callback(doc="function([time:number]):number; Starts the countdown; Will be ticking down until the time is reached. 5 seconds by default. Returns the time set")
    public Object[] start(Context context, Arguments args) {
        if (this.time >= 0) {
            return new Object[]{-1, "fuse has already been set"};
        }
        double fuse = args.optDouble(0, 5.0);
        if (fuse > 100000.0) {
            throw new IllegalArgumentException("time may not be greater than 100000");
        }
        this.time = (int)Math.round(Math.floor(fuse * 20.0));
        return new Object[]{fuse};
    }

    @Callback(doc="function():number; Returns the time in seconds left", direct=true)
    public Object[] time(Context context, Arguments args) {
        if (this.time < 0) {
            return new Object[]{-1, "fuse has not been set"};
        }
        return new Object[]{(double)this.time / 20.0};
    }

    public boolean canUpdate() {
        return true;
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (this.oc_fs != null && this.oc_fs.node() != null) {
            this.oc_fs.node().load(nbt.func_74775_l("oc:fs"));
        }
        if (nbt.func_74767_n("ticking")) {
            this.time = nbt.func_74762_e("time");
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.oc_fs != null && this.oc_fs.node() != null) {
            NBTTagCompound fsNbt = new NBTTagCompound();
            this.oc_fs.node().save(fsNbt);
            nbt.func_74782_a("oc:fs", (NBTBase)fsNbt);
        }
        if (this.time >= 0) {
            nbt.func_74757_a("ticking", true);
            nbt.func_74768_a("time", this.time);
        } else {
            nbt.func_74757_a("ticking", false);
        }
    }

    public void update() {
        super.update();
        if (this.time < 0) {
            return;
        }
        --this.time;
        if (this.time <= 0) {
            this.time = -1;
            this.goBoom();
        }
    }

    private void goBoom() {
        SelfDestruct explosion = new SelfDestruct(this.container.world(), null, this.container.xPosition(), this.container.yPosition(), this.container.zPosition(), 4.0f);
        explosion.field_82755_b = true;
        explosion.field_77286_a = false;
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        int x = (int)this.container.xPosition();
        int y = (int)this.container.yPosition();
        int z = (int)this.container.zPosition();
        for (Object playerEntity : this.container.world().field_73010_i) {
            EntityPlayerMP entityplayer;
            if (!(playerEntity instanceof EntityPlayerMP) || !((entityplayer = (EntityPlayerMP)playerEntity).func_70092_e(this.container.xPosition(), this.container.yPosition(), this.container.zPosition()) < 4096.0)) continue;
            try {
                Packet p = Computronics.packet.create(5).writeDouble(this.container.xPosition()).writeDouble(this.container.yPosition()).writeDouble(this.container.zPosition()).writeFloat(4.0f);
                p.writeInt(explosion.field_77281_g.size());
                for (Object affectedBlockPosition1 : explosion.field_77281_g) {
                    ChunkPosition chunkposition = (ChunkPosition)affectedBlockPosition1;
                    byte j = (byte)(chunkposition.field_151329_a - x);
                    byte k = (byte)(chunkposition.field_151327_b - y);
                    byte l = (byte)(chunkposition.field_151328_c - z);
                    p.writeByte(j);
                    p.writeByte(k);
                    p.writeByte(l);
                }
                Vec3 motion = (Vec3)explosion.func_77277_b().get(entityplayer);
                float motionX = 0.0f;
                float motionY = 0.0f;
                float motionZ = 0.0f;
                if (motion != null) {
                    motionY = (float)motion.field_72450_a;
                    motionX = (float)motion.field_72448_b;
                    motionZ = (float)motion.field_72449_c;
                }
                p.writeFloat(motionY);
                p.writeFloat(motionX);
                p.writeFloat(motionZ);
                Computronics.packet.sendTo(p, entityplayer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

