/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.network;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.DriverCardSound;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.lib.audio.StreamingAudioPlayer;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.Packet;
import pl.asie.lib.util.WorldUtils;

public class NetworkHandlerClient
extends MessageHandlerBase {
    private static final AudioFormat DFPWM_DECODED_FORMAT = new AudioFormat(32768.0f, 8, 1, false, false);

    public void onMessage(Packet packet, INetHandler handler, EntityPlayer player, int command) throws IOException {
        switch (command) {
            case 2: {
                TileEntity entity = packet.readTileEntity();
                TapeDriveState.State state = TapeDriveState.State.values()[packet.readUnsignedByte()];
                if (!(entity instanceof TileTapeDrive)) break;
                TileTapeDrive tile = (TileTapeDrive)entity;
                tile.switchState(state);
                break;
            }
            case 0: {
                int dimId = packet.readInt();
                int x = packet.readInt();
                int y = packet.readInt();
                int z = packet.readInt();
                int packetId = packet.readInt();
                int codecId = packet.readInt();
                short packetSize = packet.readShort();
                short volume = packet.readByte();
                byte[] data = packet.readByteArrayData((int)packetSize);
                byte[] audio = new byte[packetSize * 8];
                String sourceName = "dfpwm_" + codecId;
                StreamingAudioPlayer codec = Computronics.instance.audio.getPlayer(codecId);
                if (dimId != WorldUtils.getCurrentClientDimension()) {
                    return;
                }
                codec.decompress(audio, data, 0, 0, (int)packetSize);
                for (int i = 0; i < packetSize * 8; ++i) {
                    audio[i] = (byte)(audio[i] & 0xFF ^ 0x80);
                }
                if (codec.lastPacketId + 1 != packetId) {
                    codec.reset();
                }
                codec.setSampleRate(packetSize * 32);
                codec.setDistance((float)Config.TAPEDRIVE_DISTANCE);
                codec.setVolume((float)volume / 127.0f);
                codec.playPacket(audio, x, y, z);
                codec.lastPacketId = packetId;
                break;
            }
            case 1: {
                int codecId = packet.readInt();
                Computronics.instance.audio.removePlayer(codecId);
                break;
            }
            case 3: {
                double x = packet.readFloat();
                double y = packet.readFloat();
                double z = packet.readFloat();
                double vx = packet.readFloat();
                double vy = packet.readFloat();
                double vz = packet.readFloat();
                String name = packet.readString();
                Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_72869_a(name, x, y, z, vx, vy, vz);
                break;
            }
            case 4: {
                if (!Mods.isLoaded("OpenComputers")) break;
                DriverCardSound.onSound(packet, player);
                break;
            }
            case 5: {
                if (!Mods.isLoaded("OpenComputers")) break;
                Computronics.proxy.goBoom(packet);
                break;
            }
            case 6: {
                if (!Mods.isLoaded("Railcraft")) break;
                Computronics.railcraft.onMessageRailcraft(packet, player, false);
            }
        }
    }
}

