/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.driver.EnvironmentAware;
import li.cil.oc.api.driver.EnvironmentHost;
import li.cil.oc.api.driver.Item;
import li.cil.oc.api.driver.item.HostAware;
import li.cil.oc.api.driver.item.UpgradeRenderer;
import li.cil.oc.api.event.RobotRenderEvent;
import li.cil.oc.api.internal.Adapter;
import li.cil.oc.api.internal.Drone;
import li.cil.oc.api.internal.Microcontroller;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.internal.Tablet;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.client.KeyBindings;
import li.cil.oc.util.ItemCosts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.DriverCardBoom;
import pl.asie.computronics.oc.DriverCardFX;
import pl.asie.computronics.oc.DriverCardSound;
import pl.asie.computronics.oc.DriverCardSpoof;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.oc.RobotUpgradeCamera;
import pl.asie.computronics.oc.RobotUpgradeChatBox;
import pl.asie.computronics.oc.RobotUpgradeColorful;
import pl.asie.computronics.oc.RobotUpgradeRadar;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.StringUtil;
import pl.asie.lib.item.ItemMultiple;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.driver.Item", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.EnvironmentAware", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.item.HostAware", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.item.UpgradeRenderer", modid="OpenComputers")})
public class ItemOpenComputers
extends ItemMultiple
implements Item,
EnvironmentAware,
HostAware,
UpgradeRenderer,
IItemWithDocumentation {
    private IIcon colorfulUpgradeCanvasIcon;
    private IIcon colorfulUpgradeTopIcon;
    private static final int maxWidth = 220;

    public ItemOpenComputers() {
        super("computronics", new String[]{"robot_upgrade_camera", "robot_upgrade_chatbox", "robot_upgrade_radar", "card_fx", "card_spoof", "card_beep", "card_boom", "robot_upgrade_colorful"});
        this.func_77637_a(Computronics.tab);
    }

    @Optional.Method(modid="OpenComputers")
    public boolean worksWith(ItemStack stack) {
        return stack.func_77973_b().equals(this);
    }

    @Optional.Method(modid="OpenComputers")
    public boolean worksWith(ItemStack stack, Class<? extends EnvironmentHost> host) {
        boolean works = this.worksWith(stack);
        works = works && !Adapter.class.isAssignableFrom(host);
        switch (stack.func_77960_j()) {
            case 4: {
                works = works && !Tablet.class.isAssignableFrom(host) && !Drone.class.isAssignableFrom(host) && !Microcontroller.class.isAssignableFrom(host);
                break;
            }
            case 6: {
                works = works && !Tablet.class.isAssignableFrom(host) && !Drone.class.isAssignableFrom(host);
                break;
            }
            case 7: {
                works = works && Robot.class.isAssignableFrom(host);
            }
        }
        return works;
    }

    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> providedEnvironment(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return RobotUpgradeCamera.class;
            }
            case 1: {
                return RobotUpgradeChatBox.class;
            }
            case 2: {
                return RobotUpgradeRadar.class;
            }
            case 3: {
                return DriverCardFX.class;
            }
            case 4: {
                return DriverCardSpoof.class;
            }
            case 5: {
                return DriverCardSound.class;
            }
            case 6: {
                return DriverCardBoom.class;
            }
            case 7: {
                return RobotUpgradeColorful.class;
            }
        }
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    public ManagedEnvironment createEnvironment(ItemStack stack, EnvironmentHost container) {
        switch (stack.func_77960_j()) {
            case 0: {
                return new RobotUpgradeCamera(container);
            }
            case 1: {
                return new RobotUpgradeChatBox(container);
            }
            case 2: {
                return new RobotUpgradeRadar(container);
            }
            case 3: {
                return new DriverCardFX(container);
            }
            case 4: {
                return new DriverCardSpoof(container);
            }
            case 5: {
                return new DriverCardSound(container);
            }
            case 6: {
                return new DriverCardBoom(container);
            }
            case 7: {
                return new RobotUpgradeColorful(container);
            }
        }
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    public String slot(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "upgrade";
            }
            case 1: {
                return "upgrade";
            }
            case 2: {
                return "upgrade";
            }
            case 3: {
                return "card";
            }
            case 4: {
                return "card";
            }
            case 5: {
                return "card";
            }
            case 6: {
                return "card";
            }
            case 7: {
                return "upgrade";
            }
        }
        return "none";
    }

    @Optional.Method(modid="OpenComputers")
    public int tier(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    @Optional.Method(modid="OpenComputers")
    public NBTTagCompound dataTag(ItemStack stack) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = stack.func_77978_p()).func_74764_b("oc:data")) {
            nbt.func_74782_a("oc:data", (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l("oc:data");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(net.minecraft.item.Item item, CreativeTabs tabs, List list) {
        if (Config.OC_UPGRADE_CAMERA) {
            list.add(new ItemStack(item, 1, 0));
        }
        if (Config.OC_UPGRADE_CHATBOX) {
            list.add(new ItemStack(item, 1, 1));
        }
        if (Config.OC_UPGRADE_RADAR) {
            list.add(new ItemStack(item, 1, 2));
        }
        if (Config.OC_CARD_FX) {
            list.add(new ItemStack(item, 1, 3));
        }
        if (Config.OC_CARD_SPOOF) {
            list.add(new ItemStack(item, 1, 4));
        }
        if (Config.OC_CARD_SOUND) {
            list.add(new ItemStack(item, 1, 5));
        }
        if (Config.OC_CARD_BOOM) {
            list.add(new ItemStack(item, 1, 6));
        }
        if (Config.OC_UPGRADE_COLORFUL) {
            list.add(new ItemStack(item, 1, 7));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister r) {
        super.func_94581_a(r);
        this.colorfulUpgradeCanvasIcon = r.func_94245_a("computronics:robot_upgrade_colorful_canvas");
        this.colorfulUpgradeTopIcon = r.func_94245_a("computronics:robot_upgrade_colorful_top");
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return meta == 7 ? 3 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        switch (meta) {
            case 7: {
                switch (pass) {
                    case 1: {
                        return this.colorfulUpgradeCanvasIcon;
                    }
                    case 2: {
                        return this.colorfulUpgradeTopIcon;
                    }
                }
            }
        }
        return super.func_77618_c(meta, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        switch (stack.func_77960_j()) {
            case 7: {
                int col;
                if (pass != 1) break;
                NBTTagCompound tag = this.dataTag(stack);
                if (tag.func_74764_b("computronics:color") && (col = tag.func_74762_e("computronics:color")) >= 0) {
                    return col;
                }
                float[] hsb = Color.RGBtoHSB(0, 255, 0, null);
                return Color.HSBtoRGB((float)((System.currentTimeMillis() + (long)(stack.hashCode() % 30000)) % 30000L) / 30000.0f, hsb[1], hsb[2]) & 0xFFFFFF;
            }
        }
        return super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean par4) {
        NBTTagCompound data;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String key = "item.computronics." + this.parts[stack.func_77960_j() % this.parts.length] + ".tip";
        String tip = StringUtil.localize(key);
        if (!tip.equals(key)) {
            boolean shouldShorten;
            String[] lines = tip.split("\n");
            boolean bl = shouldShorten = font.func_78256_a(tip) > 220 && !KeyBindings.showExtendedTooltips();
            if (shouldShorten) {
                tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.TooLong", KeyBindings.getKeyBindingName((KeyBinding)KeyBindings.extendedTooltip())));
            } else {
                for (String line : lines) {
                    List list = font.func_78271_c(line, 220);
                    tooltip.addAll(list);
                }
            }
        }
        if (ItemCosts.hasCosts((ItemStack)stack)) {
            if (KeyBindings.showMaterialCosts()) {
                ItemCosts.addTooltip((ItemStack)stack, (List)tooltip);
            } else {
                tooltip.add(StringUtil.localizeAndFormat("oc:tooltip.MaterialCosts", KeyBindings.getKeyBindingName((KeyBinding)KeyBindings.materialCosts())));
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("oc:data") && (data = stack.func_77978_p().func_74775_l("oc:data")).func_74764_b("node") && data.func_74775_l("node").func_74764_b("address")) {
            tooltip.add(EnumChatFormatting.DARK_GRAY + data.func_74775_l("node").func_74779_i("address").substring(0, 13) + "..." + EnumChatFormatting.GRAY);
        }
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "camera_upgrade";
            }
            case 1: {
                return "chat_upgrade";
            }
            case 2: {
                return "radar_upgrade";
            }
            case 3: {
                return "particle_card";
            }
            case 4: {
                return "spoofing_card";
            }
            case 5: {
                return "beep_card";
            }
            case 6: {
                return "self_destructing_card";
            }
            case 7: {
                return "colorful_upgrade";
            }
        }
        return "index";
    }

    @Optional.Method(modid="OpenComputers")
    public String computePreferredMountPoint(ItemStack stack, Robot robot, Set<String> availableMountPoints) {
        return IntegrationOpenComputers.upgradeRenderer.computePreferredMountPoint(stack, robot, availableMountPoints);
    }

    @Optional.Method(modid="OpenComputers")
    public void render(ItemStack stack, RobotRenderEvent.MountPoint mountPoint, Robot robot, float pt) {
        IntegrationOpenComputers.upgradeRenderer.render(stack, mountPoint, robot, pt);
    }
}

