/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.redlogic;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.DriverBlock;
import mods.immibis.redlogic.api.misc.ILampBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.integration.CCMultiPeripheral;

public class DriverLamp {

    public static class CCDriver
    extends CCMultiPeripheral<ILampBlock> {
        public CCDriver() {
        }

        public CCDriver(ILampBlock block, World world, int x, int y, int z) {
            super(block, "lamp", world, x, y, z);
        }

        @Override
        public IMultiPeripheral getPeripheral(World world, int x, int y, int z, int side) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof ILampBlock) {
                return new CCDriver((ILampBlock)block, world, x, y, z);
            }
            return null;
        }

        public String[] getMethodNames() {
            return new String[]{"getLampColor", "isLampPowered", "getLampType"};
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return new Object[]{((ILampBlock)this.tile).getColourRGB(this.w, this.x, this.y, this.z)};
                }
                case 1: {
                    return new Object[]{((ILampBlock)this.tile).isPowered()};
                }
                case 2: {
                    return new Object[]{((ILampBlock)this.tile).getType().name()};
                }
            }
            return null;
        }
    }

    public static class OCDriver
    extends DriverBlock {
        public OCDriver() {
            super(new ItemStack[0]);
        }

        public boolean worksWith(World world, int x, int y, int z) {
            return world.func_147439_a(x, y, z) instanceof ILampBlock;
        }

        public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof ILampBlock) {
                return new InternalManagedEnvironment((ILampBlock)block, (IBlockAccess)world, x, y, z);
            }
            return null;
        }

        public class InternalManagedEnvironment
        extends li.cil.oc.api.prefab.ManagedEnvironment {
            private ILampBlock block;
            private IBlockAccess w;
            private int x;
            private int y;
            private int z;

            public InternalManagedEnvironment(ILampBlock block, IBlockAccess w, int x, int y, int z) {
                this.block = block;
                this.w = w;
                this.x = x;
                this.y = y;
                this.z = z;
                this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("lamp", Visibility.Network).create());
            }

            @Callback(doc="function():string; Returns the type of this lamp", direct=true)
            public Object[] getLampType(Context c, Arguments a) {
                return new Object[]{this.block.getType().name()};
            }

            @Callback(doc="function():number; Returns the color of this lamp", direct=true)
            public Object[] getLampColor(Context c, Arguments a) {
                return new Object[]{this.block.getColourRGB(this.w, this.x, this.y, this.z)};
            }

            @Callback(doc="function():boolean; Returns whether this lamp is powered", direct=true)
            public Object[] isLampPowered(Context c, Arguments a) {
                return new Object[]{this.block.isPowered()};
            }
        }
    }
}

