/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.driver.track;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverTileEntity;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackLauncher;
import mods.railcraft.common.core.RailcraftConfig;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.integration.CCMultiPeripheral;
import pl.asie.computronics.integration.ManagedEnvironmentOCTile;

public class DriverLauncherTrack {
    private static Object[] getForce(TrackLauncher tile) {
        return new Object[]{(int)tile.getLaunchForce()};
    }

    private static Object[] setForce(TrackLauncher tile, Object[] arguments) {
        int force = ((Double)arguments[0]).intValue();
        if (force >= 5 && force <= RailcraftConfig.getLaunchRailMaxForce()) {
            tile.setLaunchForce(force);
            tile.sendUpdateToClient();
            return new Object[]{true};
        }
        return new Object[]{false, "not a valid force value, needs to be between 5 and " + RailcraftConfig.getLaunchRailMaxForce()};
    }

    public static class CCDriver
    extends CCMultiPeripheral<TrackLauncher> {
        public CCDriver() {
        }

        public CCDriver(TrackLauncher track, World world, int x, int y, int z) {
            super(track, "launcher_track", world, x, y, z);
        }

        @Override
        public IMultiPeripheral getPeripheral(World world, int x, int y, int z, int side) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te != null && te instanceof TileTrack && ((TileTrack)te).getTrackInstance() instanceof TrackLauncher) {
                return new CCDriver((TrackLauncher)((TileTrack)te).getTrackInstance(), world, x, y, z);
            }
            return null;
        }

        public String[] getMethodNames() {
            return new String[]{"getForce", "setForce"};
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
            switch (method) {
                case 0: {
                    return DriverLauncherTrack.getForce((TrackLauncher)this.tile);
                }
                case 1: {
                    if (arguments.length < 1 || !(arguments[0] instanceof Double)) {
                        throw new LuaException("first argument needs to be a number");
                    }
                    return DriverLauncherTrack.setForce((TrackLauncher)this.tile, arguments);
                }
            }
            return null;
        }
    }

    public static class OCDriver
    extends DriverTileEntity {
        public Class<?> getTileEntityClass() {
            return TileTrack.class;
        }

        public boolean worksWith(World world, int x, int y, int z) {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            return tileEntity != null && tileEntity instanceof TileTrack && ((TileTrack)tileEntity).getTrackInstance() instanceof TrackLauncher;
        }

        public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
            return new InternalManagedEnvironment((TrackLauncher)((TileTrack)world.func_147438_o(x, y, z)).getTrackInstance());
        }

        public class InternalManagedEnvironment
        extends ManagedEnvironmentOCTile<TrackLauncher> {
            public InternalManagedEnvironment(TrackLauncher tile) {
                super(tile, "launcher_track");
            }

            @Callback(doc="function():number; returns the current force of the track")
            public Object[] getForce(Context c, Arguments a) {
                return DriverLauncherTrack.getForce((TrackLauncher)this.tile);
            }

            @Callback(doc="function():boolean; sets the force of the track; returns true on success")
            public Object[] setForce(Context c, Arguments a) {
                a.checkInteger(0);
                return DriverLauncherTrack.setForce((TrackLauncher)this.tile, a.toArray());
            }
        }
    }
}

