/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.client;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import pl.asie.computronics.block.BlockColorfulLamp;
import pl.asie.computronics.tile.TileColorfulLamp;

public class LampRender
implements ISimpleBlockRenderingHandler {
    private static int renderId;

    public LampRender() {
        renderId = RenderingRegistry.getNextAvailableRenderId();
    }

    private void renderInventoryIcon(BlockColorfulLamp block, IIcon icon, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a((Block)block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, icon);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        BlockColorfulLamp lb = (BlockColorfulLamp)block;
        GL11.glPushMatrix();
        GL11.glColor3f((float)0.75f, (float)0.75f, (float)0.75f);
        GL11.glScalef((float)0.975f, (float)0.975f, (float)0.975f);
        this.renderInventoryIcon(lb, lb.m0, renderer);
        GL11.glPopMatrix();
        this.renderInventoryIcon(lb, lb.m1, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockColorfulLamp lb = (BlockColorfulLamp)block;
        GL11.glPushMatrix();
        Tessellator t = Tessellator.field_78398_a;
        TileEntity tile = world.func_147438_o(x, y, z);
        int color = 25368;
        if (tile instanceof TileColorfulLamp) {
            color = ((TileColorfulLamp)tile).getLampColor();
        }
        float b = 0.2f + (float)(color & 0x1F) / 31.0f * 0.8f;
        float g = 0.2f + (float)(color >> 5 & 0x1F) / 31.0f * 0.8f;
        float r = 0.2f + (float)(color >> 10 & 0x1F) / 31.0f * 0.8f;
        lb.setRenderingPass(0);
        renderer.func_147736_d((Block)lb, x, y, z, r, g, b);
        GL11.glPopMatrix();
        lb.setRenderingPass(1);
        renderer.func_147784_q((Block)lb, x, y, z);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return renderId;
    }

    public static int id() {
        return renderId;
    }
}

