/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.CommonProxy;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheralProvider;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheralRegistry;
import pl.asie.computronics.audio.DFPWMPlaybackManager;
import pl.asie.computronics.block.BlockCamera;
import pl.asie.computronics.block.BlockChatBox;
import pl.asie.computronics.block.BlockCipher;
import pl.asie.computronics.block.BlockCipherAdvanced;
import pl.asie.computronics.block.BlockColorfulLamp;
import pl.asie.computronics.block.BlockEEPROMReader;
import pl.asie.computronics.block.BlockIronNote;
import pl.asie.computronics.block.BlockRadar;
import pl.asie.computronics.block.BlockTapeReader;
import pl.asie.computronics.cc.IntegrationComputerCraft;
import pl.asie.computronics.cc.multiperipheral.MultiPeripheralRegistry;
import pl.asie.computronics.gui.providers.GuiProviderCipher;
import pl.asie.computronics.gui.providers.GuiProviderTapeDrive;
import pl.asie.computronics.integration.ModRecipes;
import pl.asie.computronics.integration.buildcraft.IntegrationBuildCraft;
import pl.asie.computronics.integration.buildcraft.IntegrationBuildCraftBuilder;
import pl.asie.computronics.integration.buildcraft.statements.ActionProvider;
import pl.asie.computronics.integration.buildcraft.statements.StatementParameters;
import pl.asie.computronics.integration.buildcraft.statements.TriggerProvider;
import pl.asie.computronics.integration.forestry.IntegrationForestry;
import pl.asie.computronics.integration.gregtech.GregTechRecipes;
import pl.asie.computronics.integration.railcraft.IntegrationRailcraft;
import pl.asie.computronics.item.ItemTape;
import pl.asie.computronics.item.block.IBlockWithSpecialText;
import pl.asie.computronics.item.block.ItemBlockWithSpecialText;
import pl.asie.computronics.network.NetworkHandlerClient;
import pl.asie.computronics.network.NetworkHandlerServer;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.reference.Compat;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.StorageManager;
import pl.asie.computronics.tape.TapeStorageEventHandler;
import pl.asie.computronics.tile.TileCamera;
import pl.asie.computronics.tile.TileChatBox;
import pl.asie.computronics.tile.TileCipherBlock;
import pl.asie.computronics.tile.TileCipherBlockAdvanced;
import pl.asie.computronics.tile.TileColorfulLamp;
import pl.asie.computronics.tile.TileEEPROMReader;
import pl.asie.computronics.tile.TileIronNote;
import pl.asie.computronics.tile.TileRadar;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.computronics.util.achievements.ComputronicsAchievements;
import pl.asie.computronics.util.chat.ChatHandler;
import pl.asie.lib.block.BlockBase;
import pl.asie.lib.gui.managed.IGuiProvider;
import pl.asie.lib.gui.managed.ManagedGuiHandler;
import pl.asie.lib.item.ItemMultiple;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.PacketHandler;

@Mod(modid="computronics", name="Computronics", version="1.5.7", dependencies="required-after:asielib@[0.4.2,);required-after:Forge@[10.13.2.1291,);after:ComputerCraft;after:OpenComputers@[1.5.11.25,);after:nedocomputers;before:OpenPeripheralCore@[1.1,);before:OpenPeripheralApi@[3.2,);after:MineFactoryReloaded;after:RedLogic@[59.1.9,);after:ProjRed|Core;after:BuildCraft|Core@[7.0.6,);after:Railcraft@[9.5.0.0,);after:gregtech@[MC1710];after:EnderIO@[1.7.10_2.2.7,);after:Forestry@[3.6.0,);after:Waila@[1.5.10,);after:MekanismAPI|energy@[8.0.0,);after:Flamingo@[1.7.10-1.3,);after:armourersWorkshop@[1.7.10-0.33,)")
public class Computronics {
    public Config config;
    public Compat compat;
    public static Random rand = new Random();
    public static Logger log;
    public static FMLEventChannel channel;
    @Mod.Instance(value="computronics")
    public static Computronics instance;
    public static StorageManager storage;
    public static TapeStorageEventHandler storageEventHandler;
    public static ManagedGuiHandler gui;
    public static PacketHandler packet;
    public DFPWMPlaybackManager audio;
    public static ExecutorService rsaThreads;
    @SidedProxy(clientSide="pl.asie.computronics.ClientProxy", serverSide="pl.asie.computronics.CommonProxy")
    public static CommonProxy proxy;
    public static BlockIronNote ironNote;
    public static BlockTapeReader tapeReader;
    public static BlockCamera camera;
    public static BlockChatBox chatBox;
    public static BlockCipher cipher;
    public static BlockCipherAdvanced cipher_advanced;
    public static BlockRadar radar;
    public static BlockEEPROMReader nc_eepromreader;
    public static BlockColorfulLamp colorfulLamp;
    public static IntegrationOpenComputers opencomputers;
    public static IntegrationComputerCraft computercraft;
    public static IntegrationBuildCraft buildcraft;
    public static IntegrationRailcraft railcraft;
    public static IntegrationForestry forestry;
    public static ItemTape itemTape;
    public static ItemMultiple itemParts;
    public static ItemMultiple itemPartsGreg;
    public static IGuiProvider guiTapeDrive;
    public static IGuiProvider guiCipher;
    public ComputronicsAchievements achievements;
    public static MultiPeripheralRegistry peripheralRegistry;
    public static CreativeTabs tab;

    public boolean isEnabled(String name, boolean def) {
        return this.config.isEnabled(name, def);
    }

    private void registerBlockWithTileEntity(BlockBase block, Class<? extends TileEntity> tile, String name) {
        if (block instanceof IBlockWithSpecialText) {
            this.registerBlockWithTileEntity(block, ItemBlockWithSpecialText.class, tile, name);
        } else {
            this.registerBlockWithTileEntity(block, ItemBlock.class, tile, name);
        }
    }

    private void registerBlockWithTileEntity(BlockBase block, Class<? extends ItemBlock> itemBlock, Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerBlock((Block)block, itemBlock, (String)name);
        GameRegistry.registerTileEntity(tile, (String)name);
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)tile.getCanonicalName());
        IntegrationBuildCraftBuilder.INSTANCE.registerBlockBaseSchematic(block);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = LogManager.getLogger((String)"computronics");
        this.config = new Config(event);
        this.audio = new DFPWMPlaybackManager(proxy.isClient());
        packet = new PacketHandler("computronics", (MessageHandlerBase)new NetworkHandlerClient(), (MessageHandlerBase)new NetworkHandlerServer());
        this.compat = new Compat(this.config.config);
        this.config.preInit();
        gui = new ManagedGuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)gui);
        if (this.isEnabled("ironNoteBlock", true)) {
            ironNote = new BlockIronNote();
            this.registerBlockWithTileEntity(ironNote, TileIronNote.class, "computronics.ironNoteBlock");
        }
        if (this.isEnabled("tape", true)) {
            guiTapeDrive = new GuiProviderTapeDrive();
            gui.registerGuiProvider(guiTapeDrive);
            tapeReader = new BlockTapeReader();
            this.registerBlockWithTileEntity(tapeReader, TileTapeDrive.class, "computronics.tapeReader");
        }
        if (this.isEnabled("camera", true)) {
            camera = new BlockCamera();
            this.registerBlockWithTileEntity(camera, TileCamera.class, "computronics.camera");
        }
        if (this.isEnabled("chatBox", true)) {
            chatBox = new BlockChatBox();
            this.registerBlockWithTileEntity(chatBox, TileChatBox.class, "computronics.chatBox");
        }
        if (this.isEnabled("cipher", true)) {
            guiCipher = new GuiProviderCipher();
            gui.registerGuiProvider(guiCipher);
            cipher = new BlockCipher();
            this.registerBlockWithTileEntity(cipher, TileCipherBlock.class, "computronics.cipher");
        }
        if (this.isEnabled("cipher_advanced", true)) {
            cipher_advanced = new BlockCipherAdvanced();
            this.registerBlockWithTileEntity(cipher_advanced, TileCipherBlockAdvanced.class, "computronics.cipher_advanced");
            rsaThreads = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setPriority(1).build());
        }
        if (this.isEnabled("radar", true)) {
            radar = new BlockRadar();
            this.registerBlockWithTileEntity(radar, TileRadar.class, "computronics.radar");
        }
        if (this.isEnabled("lamp", true)) {
            colorfulLamp = new BlockColorfulLamp();
            this.registerBlockWithTileEntity(colorfulLamp, TileColorfulLamp.class, "computronics.colorfulLamp");
        }
        if (Mods.isLoaded("nedocomputers") && this.isEnabled("eepromReader", true)) {
            nc_eepromreader = new BlockEEPROMReader();
            this.registerBlockWithTileEntity(nc_eepromreader, TileEEPROMReader.class, "computronics.eepromReader");
        }
        if (this.isEnabled("tape", true)) {
            itemTape = new ItemTape(Config.TAPE_LENGTHS);
            GameRegistry.registerItem((Item)itemTape, (String)"computronics.tape");
            if (Mods.isLoaded("gregtech")) {
                itemPartsGreg = new ItemMultiple("computronics", new String[]{"reelChromoxide"});
                itemPartsGreg.func_77637_a(tab);
                GameRegistry.registerItem((Item)itemPartsGreg, (String)"computronics.gt_parts");
                proxy.registerEntities();
            }
            itemParts = new ItemMultiple("computronics", new String[]{"part_tape_track"});
            itemParts.func_77637_a(tab);
            GameRegistry.registerItem((Item)itemParts, (String)"computronics.parts");
        }
        if (Mods.isLoaded("Railcraft")) {
            railcraft = new IntegrationRailcraft();
            railcraft.preInit(this.config.config);
        }
        if (Mods.isLoaded("ComputerCraft")) {
            computercraft = new IntegrationComputerCraft(this);
            peripheralRegistry = new MultiPeripheralRegistry();
        }
        if (Mods.isLoaded("OpenComputers")) {
            opencomputers = new IntegrationOpenComputers(this);
            opencomputers.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ChatHandler());
        if (tapeReader != null) {
            storageEventHandler = new TapeStorageEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)storageEventHandler);
        }
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"pl.asie.computronics.integration.waila.IntegrationWaila.register");
        this.config.setCategoryComment("power", "Every value related to energy in this section uses RF as the base power unit.");
        if (Mods.isLoaded("ComputerCraft")) {
            this.config.setCategoryComment("modCompatibility", "Set anything here to false to prevent Computronics from adding the respective Peripherals and Drivers");
            computercraft.init();
        }
        if (Mods.isLoaded("OpenComputers")) {
            this.config.setCategoryComment("modCompatibility", "Set anything here to false to prevent Computronics from adding the respective Peripherals and Drivers");
            opencomputers.init();
        }
        if (Mods.API.hasAPI("BuildCraftAPI|blueprints")) {
            IntegrationBuildCraftBuilder.INSTANCE.init();
        }
        this.achievements = new ComputronicsAchievements();
        this.achievements.initialize();
        this.config.save();
        proxy.registerRenderers();
    }

    @Optional.Method(modid="ComputerCraft")
    public static void registerMultiPeripheralProvider(IMultiPeripheralProvider provider) {
        if (peripheralRegistry != null) {
            peripheralRegistry.registerPeripheralProvider(provider);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModRecipes.instance = Mods.isLoaded("gregtech") && Config.GREGTECH_RECIPES ? new GregTechRecipes() : new ModRecipes();
        if (ModRecipes.instance != null) {
            ModRecipes.instance.registerRecipes();
        } else {
            log.error("Could not register recipes, an error occured!");
        }
        if (itemTape != null && Mods.isLoaded("gregtech") && itemPartsGreg != null) {
            GregTechRecipes.registerGregTechTapeRecipes();
        }
        if (Mods.isLoaded("OpenComputers")) {
            opencomputers.postInit();
        }
        if (Mods.API.hasAPI("BuildCraftAPI|statements")) {
            TriggerProvider.initialize();
            ActionProvider.initialize();
            StatementParameters.initialize();
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerAboutToStartEvent event) {
        storage = new StorageManager();
        if (Mods.isLoaded("ComputerCraft")) {
            computercraft.serverStart();
        }
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        if (Mods.isLoaded("OpenComputers")) {
            opencomputers.remap(event);
        }
    }

    @Mod.EventHandler
    public void receiveIMC(FMLInterModComms.IMCEvent event) {
        if (Mods.isLoaded("ComputerCraft")) {
            ImmutableList messages = event.getMessages();
            for (FMLInterModComms.IMCMessage message : messages) {
                if (!message.key.equalsIgnoreCase("addmultiperipherals") || !message.isStringMessage()) continue;
                if (peripheralRegistry != null) {
                    try {
                        String methodString = message.getStringValue();
                        String[] methodParts = methodString.split("\\.");
                        String methodName = methodParts[methodParts.length - 1];
                        String className = methodString.substring(0, methodString.length() - methodName.length() - 1);
                        try {
                            Class<?> c = Class.forName(className);
                            Method method = c.getDeclaredMethod(methodName, IMultiPeripheralRegistry.class);
                            method.invoke(null, peripheralRegistry);
                        }
                        catch (ClassNotFoundException e) {
                            log.warn("Could not find class " + className, (Throwable)e);
                        }
                        catch (NoSuchMethodException e) {
                            log.warn("Could not find method " + methodString, (Throwable)e);
                        }
                        catch (Exception e) {
                            log.warn("Exception while trying to call method " + methodString, (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception while trying to register a MultiPeripheral", (Throwable)e);
                    }
                    continue;
                }
                log.warn(String.format(Locale.ENGLISH, "Mod (%s) tried to register MultiPeripheral before Computronics' preInit!", message.getSender()));
            }
        }
    }

    static {
        tab = new CreativeTabs("tabComputronics"){

            public Item func_78016_d() {
                return itemTape;
            }
        };
    }
}

