/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.network.packet;

import com.xcompwiz.lookingglass.client.proxyworld.ProxyWorldManager;
import com.xcompwiz.lookingglass.client.proxyworld.WorldView;
import com.xcompwiz.lookingglass.log.LoggerUtils;
import com.xcompwiz.lookingglass.network.LookingGlassPacketManager;
import com.xcompwiz.lookingglass.network.packet.PacketHandlerBase;
import com.xcompwiz.lookingglass.network.packet.PacketRequestChunk;
import com.xcompwiz.lookingglass.network.packet.PacketRequestTE;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.Semaphore;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class PacketChunkInfo
extends PacketHandlerBase {
    private static byte[] inflatearray;
    private static byte[] dataarray;
    private static Semaphore deflateGate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int deflate(byte[] chunkData, byte[] compressedChunkData) {
        Deflater deflater = new Deflater(-1);
        if (compressedChunkData == null) {
            return 0;
        }
        int bytesize = 0;
        try {
            deflater.setInput(chunkData, 0, chunkData.length);
            deflater.finish();
            bytesize = deflater.deflate(compressedChunkData);
        }
        finally {
            deflater.end();
        }
        return bytesize;
    }

    public static FMLProxyPacket createPacket(Chunk chunk, boolean includeinit, int subid, int dim) {
        int xPos = chunk.field_76635_g;
        int zPos = chunk.field_76647_h;
        S21PacketChunkData.Extracted extracted = PacketChunkInfo.getMapChunkData(chunk, includeinit, subid);
        int yMSBPos = extracted.field_150281_c;
        int yPos = extracted.field_150280_b;
        byte[] chunkData = extracted.field_150282_a;
        deflateGate.acquireUninterruptibly();
        byte[] compressedChunkData = new byte[chunkData.length];
        int len = PacketChunkInfo.deflate(chunkData, compressedChunkData);
        deflateGate.release();
        ByteBuf data = PacketHandlerBase.createDataBuffer(new Object(){}.getClass().getEnclosingClass());
        data.writeInt(dim);
        data.writeInt(xPos);
        data.writeInt(zPos);
        data.writeBoolean(includeinit);
        data.writeShort((int)((short)(yPos & 0xFFFF)));
        data.writeShort((int)((short)(yMSBPos & 0xFFFF)));
        data.writeInt(len);
        data.writeInt(chunkData.length);
        data.ensureWritable(len);
        data.writeBytes(compressedChunkData, 0, len);
        return PacketChunkInfo.buildPacket(data);
    }

    @Override
    public void handle(ByteBuf in, EntityPlayer player) {
        int uncompressedsize;
        int dim = in.readInt();
        int xPos = in.readInt();
        int zPos = in.readInt();
        boolean reqinit = in.readBoolean();
        short yPos = in.readShort();
        short yMSBPos = in.readShort();
        int compressedsize = in.readInt();
        byte[] chunkData = this.inflateChunkData(in, compressedsize, uncompressedsize = in.readInt());
        if (chunkData == null) {
            LookingGlassPacketManager.bus.sendToServer(PacketRequestChunk.createPacket(xPos, yPos, zPos, dim));
            LoggerUtils.error("Chunk decompression failed: %d\t:\t%d\t\t%d : %d\n", yMSBPos, yPos, compressedsize, uncompressedsize);
            return;
        }
        this.handle(player, chunkData, dim, xPos, zPos, reqinit, yPos, yMSBPos);
    }

    public void handle(EntityPlayer player, byte[] chunkData, int dim, int xPos, int zPos, boolean reqinit, short yPos, short yMSBPos) {
        WorldClient proxyworld = ProxyWorldManager.getProxyworld(dim);
        if (proxyworld == null) {
            return;
        }
        if (proxyworld.field_73011_w.field_76574_g != dim) {
            return;
        }
        Chunk chunk = proxyworld.func_72863_F().func_73154_d(xPos, zPos);
        if (reqinit && (chunk == null || chunk.func_76621_g())) {
            if (yPos == 0) {
                proxyworld.func_73025_a(xPos, zPos, false);
                return;
            }
            proxyworld.func_73025_a(xPos, zPos, true);
        }
        proxyworld.func_73031_a(xPos << 4, 0, zPos << 4, (xPos << 4) + 15, 256, (zPos << 4) + 15);
        chunk = proxyworld.func_72964_e(xPos, zPos);
        if (reqinit && (chunk == null || chunk.func_76621_g())) {
            proxyworld.func_73025_a(xPos, zPos, true);
            chunk = proxyworld.func_72964_e(xPos, zPos);
        }
        if (chunk != null) {
            chunk.func_76607_a(chunkData, (int)yPos, (int)yMSBPos, reqinit);
            this.receivedChunk(proxyworld, xPos, zPos);
            if (!reqinit || !(proxyworld.field_73011_w instanceof WorldProviderSurface)) {
                chunk.func_76613_n();
            }
        }
    }

    public void receivedChunk(WorldClient worldObj, int cx, int cz) {
        worldObj.func_147458_c(cx << 4, 0, cz << 4, (cx << 4) + 15, 256, (cz << 4) + 15);
        Chunk c = worldObj.func_72964_e(cx, cz);
        if (c == null || c.func_76621_g()) {
            return;
        }
        for (WorldView activeview : ProxyWorldManager.getWorldViews(worldObj.field_73011_w.field_76574_g)) {
            activeview.onChunkReceived(cx, cz);
        }
        int x = cx << 4;
        int z = cz << 4;
        for (int y = 0; y < worldObj.func_72940_L(); y += 16) {
            if (c.func_76606_c(y, y)) continue;
            for (int x2 = 0; x2 < 16; ++x2) {
                for (int z2 = 0; z2 < 16; ++z2) {
                    for (int y2 = 0; y2 < 16; ++y2) {
                        int lx = x + x2;
                        int ly = y + y2;
                        int lz = z + z2;
                        if (!worldObj.func_147439_a(lx, ly, lz).hasTileEntity(worldObj.func_72805_g(lx, ly, lz))) continue;
                        LookingGlassPacketManager.bus.sendToServer(PacketRequestTE.createPacket(lx, ly, lz, worldObj.field_73011_w.field_76574_g));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] inflateChunkData(ByteBuf in, int compressedsize, int uncompressedsize) {
        if (inflatearray == null || inflatearray.length < compressedsize) {
            inflatearray = new byte[compressedsize];
        }
        in.readBytes(inflatearray, 0, compressedsize);
        byte[] chunkData = new byte[uncompressedsize];
        Inflater inflater = new Inflater();
        inflater.setInput(inflatearray, 0, compressedsize);
        try {
            inflater.inflate(chunkData);
        }
        catch (DataFormatException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            inflater.end();
        }
        return chunkData;
    }

    public static S21PacketChunkData.Extracted getMapChunkData(Chunk chunk, boolean includeinit, int subid) {
        NibbleArray nibblearray;
        int l;
        int j = 0;
        ExtendedBlockStorage[] aextendedblockstorage = chunk.func_76587_i();
        int k = 0;
        S21PacketChunkData.Extracted extracted = new S21PacketChunkData.Extracted();
        if (dataarray == null || dataarray.length < 196864) {
            dataarray = new byte[196864];
        }
        byte[] abyte = dataarray;
        if (includeinit) {
            chunk.field_76642_o = true;
        }
        for (l = 0; l < aextendedblockstorage.length; ++l) {
            if (aextendedblockstorage[l] == null || includeinit && aextendedblockstorage[l].func_76663_a() || (subid & 1 << l) == 0) continue;
            extracted.field_150280_b |= 1 << l;
            if (aextendedblockstorage[l].func_76660_i() == null) continue;
            extracted.field_150281_c |= 1 << l;
            ++k;
        }
        for (l = 0; l < aextendedblockstorage.length; ++l) {
            if (aextendedblockstorage[l] == null || includeinit && aextendedblockstorage[l].func_76663_a() || (subid & 1 << l) == 0) continue;
            byte[] abyte1 = aextendedblockstorage[l].func_76658_g();
            System.arraycopy(abyte1, 0, abyte, j, abyte1.length);
            j += abyte1.length;
        }
        for (l = 0; l < aextendedblockstorage.length; ++l) {
            if (aextendedblockstorage[l] == null || includeinit && aextendedblockstorage[l].func_76663_a() || (subid & 1 << l) == 0) continue;
            nibblearray = aextendedblockstorage[l].func_76669_j();
            System.arraycopy(nibblearray.field_76585_a, 0, abyte, j, nibblearray.field_76585_a.length);
            j += nibblearray.field_76585_a.length;
        }
        for (l = 0; l < aextendedblockstorage.length; ++l) {
            if (aextendedblockstorage[l] == null || includeinit && aextendedblockstorage[l].func_76663_a() || (subid & 1 << l) == 0) continue;
            nibblearray = aextendedblockstorage[l].func_76661_k();
            System.arraycopy(nibblearray.field_76585_a, 0, abyte, j, nibblearray.field_76585_a.length);
            j += nibblearray.field_76585_a.length;
        }
        if (!chunk.field_76637_e.field_73011_w.field_76576_e) {
            for (l = 0; l < aextendedblockstorage.length; ++l) {
                if (aextendedblockstorage[l] == null || includeinit && aextendedblockstorage[l].func_76663_a() || (subid & 1 << l) == 0) continue;
                nibblearray = aextendedblockstorage[l].func_76671_l();
                System.arraycopy(nibblearray.field_76585_a, 0, abyte, j, nibblearray.field_76585_a.length);
                j += nibblearray.field_76585_a.length;
            }
        }
        if (k > 0) {
            for (l = 0; l < aextendedblockstorage.length; ++l) {
                if (aextendedblockstorage[l] == null || includeinit && aextendedblockstorage[l].func_76663_a() || aextendedblockstorage[l].func_76660_i() == null || (subid & 1 << l) == 0) continue;
                nibblearray = aextendedblockstorage[l].func_76660_i();
                System.arraycopy(nibblearray.field_76585_a, 0, abyte, j, nibblearray.field_76585_a.length);
                j += nibblearray.field_76585_a.length;
            }
        }
        if (includeinit) {
            byte[] abyte2 = chunk.func_76605_m();
            System.arraycopy(abyte2, 0, abyte, j, abyte2.length);
            j += abyte2.length;
        }
        extracted.field_150282_a = new byte[j];
        System.arraycopy(abyte, 0, extracted.field_150282_a, 0, j);
        return extracted;
    }

    static {
        deflateGate = new Semaphore(1);
    }
}

