/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.network;

import com.xcompwiz.lookingglass.network.PacketHolder;
import com.xcompwiz.lookingglass.proxyworld.ModConfigs;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class ServerPacketDispatcher
extends Thread {
    private static ServerPacketDispatcher instance;
    private List<PacketHolder> packets = new LinkedList<PacketHolder>();
    private boolean isRunning = true;

    private ServerPacketDispatcher() {
    }

    public static ServerPacketDispatcher getInstance() {
        if (instance == null) {
            instance = new ServerPacketDispatcher();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance != null) {
            instance.halt();
        }
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(EntityPlayer player, FMLProxyPacket packet) {
        ServerPacketDispatcher serverPacketDispatcher = this;
        synchronized (serverPacketDispatcher) {
            this.packets.add(new PacketHolder(player, packet));
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPacketsOf(EntityPlayer player) {
        ServerPacketDispatcher serverPacketDispatcher = this;
        synchronized (serverPacketDispatcher) {
            for (int j = 0; j < this.packets.size(); ++j) {
                if (!this.packets.get(j).belongsToPlayer(player)) continue;
                this.packets.remove(--j);
            }
        }
    }

    public void tick() {
        PacketHolder p;
        int byteLimit = ModConfigs.dataRate;
        for (int bytes = 0; bytes < byteLimit && !this.packets.isEmpty(); bytes += p.sendPacket()) {
            p = this.packets.get(0);
            this.packets.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        ServerPacketDispatcher serverPacketDispatcher = this;
        synchronized (serverPacketDispatcher) {
            this.isRunning = false;
            this.packets.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isRunning) {
            if (this.packets.size() > 0) {
                try {
                    ServerPacketDispatcher serverPacketDispatcher = this;
                    synchronized (serverPacketDispatcher) {
                        this.tick();
                        this.wait(20L);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            try {
                ServerPacketDispatcher e = this;
                synchronized (e) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

