/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.PropertyModifierIntLinearAdditive;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class OreScannerModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_ORE_SCANNER = "Ore Scanner";
    public static final String ORE_SCANNER_ENERGY_CONSUMPTION = "Energy Per Block";
    public static final String ORE_SCANNER_RADIUS_X = "X Radius";
    public static final String ORE_SCANNER_RADIUS_Y = "Y Radius";
    public static final String ORE_SCANNER_RADIUS_Z = "Z Radius";
    private static String[] oreNames = new String[]{"oreCopper", "oreTin", "oreSilver", "oreLead", "oreNickel", "orePlatinum", "oreZinc", "oreApatite", "oreUranium"};
    private static ArrayList<ArrayList<ItemStack>> ores = new ArrayList();
    private static HashMap<List, String> oreMap = new HashMap();
    private static HashMap<String, Integer> valueMap = new HashMap();

    public OreScannerModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(ORE_SCANNER_ENERGY_CONSUMPTION, 50.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_X, 1.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_Y, 1.0);
        this.addBaseProperty(ORE_SCANNER_RADIUS_Z, 1.0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_X, ORE_SCANNER_RADIUS_X, 3.0, "m", 1, 0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_Y, ORE_SCANNER_RADIUS_Y, 3.0, "m", 1, 0);
        this.addIntTradeoffProperty(ORE_SCANNER_RADIUS_Z, ORE_SCANNER_RADIUS_Z, 3.0, "m", 1, 0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.computerChip, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 2));
        for (int i = 0; i < oreNames.length; ++i) {
            ores.add(i, OreDictionary.getOres((String)oreNames[i]));
        }
        OreScannerModule.fillMap();
    }

    public PowerModuleBase addIntTradeoffProperty(String tradeoffName, String propertyName, double multiplier, String unit, int roundTo, int offset) {
        units.put(propertyName, unit);
        return this.addPropertyModifier(propertyName, new PropertyModifierIntLinearAdditive(tradeoffName, multiplier, roundTo, offset));
    }

    public void searchForValuables(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int xRadius = (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_X);
        int yRadius = (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Y);
        int zRadius = (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Z);
        int totalValue = 0;
        int totalEnergy = 0;
        int highestValue = 0;
        ForgeDirection fdSide = ForgeDirection.getOrientation((int)side).getOpposite();
        int cX = x + fdSide.offsetX * xRadius;
        int cY = y + fdSide.offsetY * yRadius;
        int cZ = z + fdSide.offsetZ * zRadius;
        for (int sX = cX - xRadius; sX <= cX + xRadius; ++sX) {
            for (int sY = cY - yRadius; sY <= cY + yRadius; ++sY) {
                for (int sZ = cZ - zRadius; sZ <= cZ + zRadius; ++sZ) {
                    int value = OreScannerModule.getValue(world.func_147439_a(sX, sY, sZ), world.func_72805_g(sX, sY, sZ));
                    totalValue += value;
                    ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_ENERGY_CONSUMPTION));
                    totalEnergy = (int)((double)totalEnergy + ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_ENERGY_CONSUMPTION));
                    if (value <= highestValue) continue;
                    highestValue = value;
                }
            }
        }
        if (ElectricItemUtils.getPlayerEnergy(player) > (double)totalEnergy) {
            ElectricItemUtils.drainPlayerEnergy(player, totalEnergy);
            if (MuseItemUtils.isServerSide()) {
                if (Config.useAdvancedOreScannerMessage()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("[Ore Scanner] Total ore value: " + totalValue + " --- Most valuable: " + highestValue + "\nSearch radius: " + (2 * (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_X) + 1) + "x" + (2 * (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Y) + 1) + "x" + (2 * (int)ModuleManager.computeModularProperty(itemStack, ORE_SCANNER_RADIUS_Z) + 1) + " --- Energy used: " + MuseStringUtils.formatNumberFromUnits(totalEnergy, "J")));
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("[Ore Scanner] Total ore value: " + totalValue + " --- Most valuable: " + highestValue));
                }
            }
        }
    }

    public static int getValue(Block blockID, int meta) {
        if (oreMap.containsKey(Arrays.asList(blockID, meta)) && valueMap.containsKey(oreMap.get(Arrays.asList(blockID, meta)))) {
            return valueMap.get(oreMap.get(Arrays.asList(blockID, meta)));
        }
        return 0;
    }

    public static void fillMap() {
        for (int a = 0; a < ores.size(); ++a) {
            for (int b = 0; b < ores.get(a).size(); ++b) {
                oreMap.put(Arrays.asList(ores.get(a).get(b), ores.get(a).get(b).func_77960_j()), oreNames[a]);
            }
        }
        oreMap.put(Arrays.asList(Blocks.field_150365_q, 0), "oreCoal");
        oreMap.put(Arrays.asList(Blocks.field_150366_p, 0), "oreIron");
        oreMap.put(Arrays.asList(Blocks.field_150352_o, 0), "oreGold");
        oreMap.put(Arrays.asList(Blocks.field_150450_ax, 0), "oreRedstone");
        oreMap.put(Arrays.asList(Blocks.field_150482_ag, 0), "oreDiamond");
        oreMap.put(Arrays.asList(Blocks.field_150412_bA, 0), "oreEmerald");
        oreMap.put(Arrays.asList(Blocks.field_150369_x, 0), "oreLapis");
        oreMap.put(Arrays.asList(Blocks.field_150449_bY, 0), "oreNetherQuartz");
        valueMap.put("oreCoal", 1);
        valueMap.put("oreIron", 4);
        valueMap.put("oreGold", 6);
        valueMap.put("oreRedstone", 3);
        valueMap.put("oreDiamond", 16);
        valueMap.put("oreEmerald", 18);
        valueMap.put("oreLapis", 12);
        valueMap.put("oreNetherQuartz", 8);
        valueMap.put("oreCopper", 4);
        valueMap.put("oreTin", 5);
        valueMap.put("oreSilver", 5);
        valueMap.put("oreLead", 6);
        valueMap.put("oreNickel", 14);
        valueMap.put("orePlatinum", 8);
        valueMap.put("oreZinc", 1);
        valueMap.put("oreApatite", 2);
        valueMap.put("oreUranium", 14);
        valueMap.put("oreXychorium", 2);
        valueMap.put("oreNaturalAluminum", 3);
        valueMap.put("oreCertusQuartz", 5);
    }

    @Override
    public String getTextureFile() {
        return "orescanner";
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_ORE_SCANNER;
    }

    @Override
    public String getUnlocalizedName() {
        return "oreScanner";
    }

    @Override
    public String getDescription() {
        return "A way to see how valuable the land around you is.";
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack item) {
    }

    @Override
    public void onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        this.searchForValuables(itemStack, player, world, x, y, z, side);
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

