/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.powersuits.common.ModCompatibility;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.tool.ChiselGetter1;
import net.machinemuse.powersuits.powermodule.tool.ChiselGetter2;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ChiselModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_CHISEL = "Chisel";
    public static final String CHISEL_HARVEST_SPEED = "CHISEL Harvest Speed";
    public static final String CHISEL_ENERGY_CONSUMPTION = "CHISEL Energy Consumption";
    private Item ITEM_CHISEL = null;

    public ChiselModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(GameRegistry.findItem((String)"minecraft", (String)"obsidian"), 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(CHISEL_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(CHISEL_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", CHISEL_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", CHISEL_HARVEST_SPEED, 22.0);
        try {
            this.ITEM_CHISEL = ChiselGetter1.getChisel();
        }
        catch (NoClassDefFoundError e) {
            try {
                this.ITEM_CHISEL = ChiselGetter2.getChisel();
            }
            catch (NoClassDefFoundError f) {
                MuseLogger.logException((String)"Couldn't get Chisel reference item", (Throwable)f);
            }
        }
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_CHISEL;
    }

    @Override
    public String getUnlocalizedName() {
        return "chisel";
    }

    @Override
    public String getDescription() {
        return "This won't let you chisel blocks, but it will at least let you harvest them.";
    }

    @Override
    public String getTextureFile() {
        return "toolpinch";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return ModCompatibility.isChiselLoaded() && this.ITEM_CHISEL != null && ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)new ItemStack(this.ITEM_CHISEL)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, CHISEL_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.canHarvestBlock(stack, block, meta, player)) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, CHISEL_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), CHISEL_HARVEST_SPEED));
    }
}

