/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.machine;

import nc.crafting.NCRecipeHelper;
import nc.tile.machine.TileMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileMachineFluidIn
extends TileMachineBase
implements IFluidHandler {
    public int fluid;
    public FluidTank tank;
    public int fluidAmount;
    public Fluid fluidType;

    public TileMachineFluidIn(String localName, int energyMax, int fluidMax, int inSize, int outSize, boolean usesUpgrades, boolean usesEnergy, double pt, double er, Fluid flType, int flAmount, int smod, int tmod, NCRecipeHelper ncrecipes) {
        super(localName, energyMax, inSize, outSize, usesUpgrades, usesEnergy, pt, er, smod, tmod, ncrecipes);
        this.tank = new FluidTank(fluidMax);
        this.fluidAmount = flAmount;
        this.fluidType = flType;
    }

    @Override
    public void func_145845_h() {
        this.upgradeSpeed();
        this.upgradeEnergy();
        this.getProcessTime = this.hasUpgrades ? Math.ceil(this.ProcessTime() / this.speedUpgrade) : this.ProcessTime();
        this.getEnergyRequired = this.hasUpgrades ? Math.ceil(this.speedUpgrade * (this.EnergyRequired() / this.energyUpgrade)) : this.EnergyRequired();
        if (!this.field_145850_b.field_72995_K) {
            this.canCook();
            if (this.canCook()) {
                ++this.cookTime;
                this.energyStorage.extractEnergy((int)Math.ceil(this.getEnergyRequired / this.getProcessTime), false);
                if ((double)this.cookTime >= this.getProcessTime) {
                    this.cookTime = 0;
                    this.cookItem();
                    this.tank.drain(this.fluidAmount, true);
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    @Override
    public boolean canCook() {
        ItemStack[] output;
        for (int i = 0; i < this.inputSize; ++i) {
            if (this.slots[i] != null) continue;
            this.flag = false;
            return false;
        }
        if (this.tank.getFluidAmount() < this.fluidAmount) {
            this.flag = false;
            return false;
        }
        if ((double)this.cookTime >= this.getProcessTime) {
            this.flag = true;
            return true;
        }
        if (this.getEnergyRequired > (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() - (int)Math.ceil(this.getEnergyRequired / this.getProcessTime)) {
            this.flag = false;
            return false;
        }
        if (this.getEnergyRequired < (double)this.energyStorage.getMaxEnergyStored() && this.cookTime <= 0 && this.getEnergyRequired > (double)this.energyStorage.getEnergyStored()) {
            this.flag = false;
            return false;
        }
        if (this.hasEnergy) {
            if (this.energyStorage.getEnergyStored() < 1 * (int)Math.ceil(this.getEnergyRequired / this.getProcessTime)) {
                this.flag = false;
                return false;
            }
            if (this.energyStorage.getEnergyStored() == 0) {
                this.flag = false;
                return false;
            }
        }
        if ((output = this.getOutput(this.inputs())) == null || output.length != this.outputSize) {
            return false;
        }
        for (int j = 0; j < this.outputSize; ++j) {
            if (output[j] == null) {
                this.flag = false;
                return false;
            }
            if (this.slots[j + this.inputSize] == null) continue;
            if (!this.slots[j + this.inputSize].func_77969_a(output[j])) {
                this.flag = false;
                return false;
            }
            if (this.slots[j + this.inputSize].field_77994_a + output[j].field_77994_a <= this.slots[j + this.inputSize].func_77976_d()) continue;
            this.flag = false;
            return false;
        }
        this.flag = true;
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.tank.writeToNBT(fluidTag);
        nbt.func_74782_a("tank", (NBTBase)fluidTag);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        this.energy = nbtTag.func_74762_e("Energy");
        nbtTag.func_74768_a("fluid", this.tank.getFluidAmount());
        this.fluid = nbtTag.func_74762_e("fluid");
        this.writeFluid(nbtTag);
        this.writeSides(nbtTag);
        this.writeEnergy(nbtTag);
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readSides(packet.func_148857_g());
        this.readEnergy(packet.func_148857_g());
        this.readFluid(packet.func_148857_g());
        this.func_145839_a(packet.func_148857_g());
    }

    public void readFluid(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
    }

    public void writeFluid(NBTTagCompound nbt) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        this.tank.writeToNBT(fluidTag);
        nbt.func_74782_a("tank", (NBTBase)fluidTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == this.fluidType || fluid == FluidRegistry.getFluid((int)this.fluidType.getID());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

