/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.server.core.plugin.LLibraryPlugin;

public enum MappingHandler {
    INSTANCE;

    private Map<String, String> map;

    public void parseMappings(InputStream stream) throws IOException {
        String line;
        this.map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            String[] split = line.split("=");
            this.map.put(split[0], split[1]);
        }
        reader.close();
    }

    public String getClassMapping(String cls) {
        return cls.replace(".", "/");
    }

    public String getMethodMapping(Object obj, String method, String desc) {
        if (LLibraryPlugin.inDevelopment) {
            return method;
        }
        String cls = "";
        if (obj instanceof String) {
            cls = this.getClassMapping((String)obj);
        } else if (obj instanceof Class) {
            cls = ((Class)obj).getName();
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getKey().contains("(")) continue;
            String[] entryParts = entry.getKey().split("\\(");
            int methodIndex = entryParts[0].lastIndexOf("/");
            String entryClass = entryParts[0].substring(0, methodIndex);
            String entryMethod = entryParts[0].substring(methodIndex + 1);
            String entryDesc = "(" + entryParts[1];
            if (!cls.equals(entryClass) || !method.equals(entryMethod) || !desc.equals(entryDesc)) continue;
            return entry.getValue();
        }
        return method;
    }

    public String getFieldMapping(Object obj, String field) {
        if (LLibraryPlugin.inDevelopment) {
            return field;
        }
        String cls = "";
        if (obj instanceof String) {
            cls = this.getClassMapping((String)obj);
        } else if (obj instanceof Class) {
            cls = ((Class)obj).getName();
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (entry.getKey().contains("(")) continue;
            int fieldIndex = entry.getKey().lastIndexOf("/");
            String entryClass = entry.getKey().substring(0, fieldIndex);
            String entryField = entry.getKey().substring(fieldIndex + 1);
            if (!cls.equals(entryClass) || !field.equals(entryField)) continue;
            return entry.getValue();
        }
        return field;
    }
}

