/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.items.ItemGraphiteElectrode;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ArcFurnaceDriver
extends DriverTileEntity {
    public ManagedEnvironment createEnvironment(World w, int x, int y, int z) {
        int pos;
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityArcFurnace && (pos = ((TileEntityArcFurnace)te).pos) == 25) {
            TileEntityArcFurnace arc = (TileEntityArcFurnace)te;
            return new ArcFurnaceEnvironment(w, arc.field_145851_c - arc.offset[0], arc.field_145848_d - arc.offset[1], arc.field_145849_e - arc.offset[2], TileEntityArcFurnace.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityArcFurnace.class;
    }

    public class ArcFurnaceEnvironment
    extends ManagedEnvironmentIE<TileEntityArcFurnace> {
        public String preferredName() {
            return "ie_arc_furnace";
        }

        public int priority() {
            return 1000;
        }

        public ArcFurnaceEnvironment(World w, int x, int y, int z, Class<? extends TileEntityIEBase> teClass) {
            super(w, x, y, z, teClass);
        }

        public void onConnect(Node node) {
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.getTileEntity();
            if (master != null) {
                master.computerControlled = true;
                master.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityArcFurnace te = (TileEntityArcFurnace)this.getTileEntity();
            if (te != null) {
                te.computerControlled = false;
            }
        }

        @Callback(doc="function():int -- gets the maximum amount of energy stored")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():int -- gets the amount of energy stored")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function(on:boolean) -- turns the excavator on or off")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityArcFurnace)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():boolean -- checks whether the arc furnace is currently active")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).active};
        }

        @Callback(doc="function(stack:int):table -- returns the specified input stack as described in the manual")
        public Object[] getInputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 12) {
                throw new IllegalArgumentException("Input slots are 1-12");
            }
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.getTileEntity();
            Map<String, Object> stack = Utils.saveStack(master.func_70301_a(slot - 1));
            stack.put("progress", master.process[slot - 1]);
            stack.put("maxProgress", master.processMax[slot - 1]);
            return new Object[]{stack};
        }

        @Callback(doc="function(stack:int):table -- returns the specified output stack")
        public Object[] getOutputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 6) {
                throw new IllegalArgumentException("Output slots are 1-6");
            }
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).func_70301_a(slot + 15)};
        }

        @Callback(doc="function(stack:int):table -- returns the specified additive stack")
        public Object[] getAdditiveStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 4) {
                throw new IllegalArgumentException("Additive slots are 1-4");
            }
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).func_70301_a(slot + 11)};
        }

        @Callback(doc="function():table -- returns the slag stack")
        public Object[] getSlagStack(Context context, Arguments args) {
            return new Object[]{((TileEntityArcFurnace)this.getTileEntity()).func_70301_a(22)};
        }

        @Callback(doc="function():boolean -- checks whether the arc furnace has all 3 electrodes")
        public Object[] hasElectrodes(Context context, Arguments args) {
            TileEntityArcFurnace master = (TileEntityArcFurnace)this.getTileEntity();
            return new Object[]{master.electrodes[0] && master.electrodes[1] && master.electrodes[2]};
        }

        @Callback(doc="function(electrode:int):table -- returns the specified electrode as an item stack")
        public Object[] getElectrode(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            if (slot < 1 || slot > 3) {
                throw new IllegalArgumentException("Electrode slots are 1-3");
            }
            ItemStack stack = ((TileEntityArcFurnace)this.getTileEntity()).func_70301_a(slot + 22);
            Map<String, Object> map = Utils.saveStack(stack);
            if (stack != null && stack.func_77973_b() instanceof ItemGraphiteElectrode) {
                map.put("damage", ItemNBTHelper.getInt(stack, "graphDmg"));
            }
            return new Object[]{map};
        }
    }
}

