/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.reactor.ISteamReactor;
import ic2.api.reactor.ISteamReactorComponent;
import ic2.core.fluids.IC2Fluid;
import ic2.core.item.reactor.ItemReactorHeatStorage;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ItemReactorVentSteam
extends ItemReactorHeatStorage
implements ISteamReactorComponent {
    public int selfVent;
    public int reactorVent;

    public ItemReactorVentSteam(int index, int heatStorage, int selfvent, int reactorvent) {
        super(index, heatStorage);
        this.selfVent = selfvent;
        this.reactorVent = reactorvent;
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        if (heatrun) {
            int heat;
            if (this.reactorVent > 0) {
                int reactorDrain;
                int rheat = reactorDrain = reactor.getHeat();
                if (reactorDrain > this.reactorVent) {
                    reactorDrain = this.reactorVent;
                }
                rheat -= reactorDrain;
                if ((reactorDrain = this.alterHeat(reactor, yourStack, x, y, reactorDrain)) > 0) {
                    return;
                }
                reactor.setHeat(rheat);
            }
            if ((heat = this.getHeatOfStack(yourStack)) < 100) {
                if (reactor.getWorld().func_72820_D() % 40L == 0L) {
                    this.alterHeat(reactor, yourStack, x, y, -1);
                }
                return;
            }
            double water = this.getWater(yourStack);
            if (water <= 0.0) {
                if (reactor.getWorld().func_72820_D() % 40L == 0L) {
                    this.alterHeat(reactor, yourStack, x, y, -1);
                }
                return;
            }
            double heatStorage = this.getHeatStorage(yourStack);
            double lvl = (double)this.selfVent * this.getHeatLevel(yourStack);
            double consume = Math.min(water, lvl /= 40.0);
            if (consume <= 0.0) {
                return;
            }
            int steam = (int)(160.0 * consume);
            FluidTank tank = reactor.getSteamTank();
            if (steam <= 0 || tank.getCapacity() - tank.getFluidAmount() < steam) {
                return;
            }
            tank.fill(new FluidStack(IC2Fluid.fluids.get("steam"), steam), true);
            reactor.addOutput((float)steam / 1.6f / 2.0f);
            int copy = -((int)(heatStorage += consume * 40.0));
            copy -= this.alterHeat(reactor, yourStack, x, y, copy);
            this.setWater(yourStack, water -= consume);
            this.setHeatStorage(yourStack, heatStorage += (double)copy);
        } else {
            this.refill(reactor, yourStack);
        }
    }

    public double getHeatLevel(ItemStack yourStack) {
        return (double)this.getHeatOfStack(yourStack) / ((double)this.heatStorage - 100.0);
    }

    private void refill(ISteamReactor reactor, ItemStack yourStack) {
        double water = this.getWater(yourStack);
        if (water > (double)this.selfVent - 1.0) {
            return;
        }
        int needed = (int)((double)this.selfVent - water);
        FluidTank tank = reactor.getWaterTank();
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        int min = Math.min(tank.getFluidAmount(), needed);
        FluidStack drained = tank.drain(min, true);
        if (drained != null) {
            this.setWater(yourStack, water += (double)drained.amount);
        }
    }

    private int getHeatOfStack(ItemStack stack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(stack);
        return nbtData.func_74762_e("heat");
    }

    private double getWater(ItemStack par1) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        return nbt.func_74769_h("WaterBuffer");
    }

    private void setWater(ItemStack par1, double par2) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        nbt.func_74780_a("WaterBuffer", par2);
    }

    private double getHeatStorage(ItemStack par1) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(par1);
        return nbtData.func_74769_h("HeatStorage");
    }

    private void setHeatStorage(ItemStack par1, double amount) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(par1);
        nbtData.func_74780_a("HeatStorage", amount);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1, EntityPlayer par2, List par3, boolean par4) {
        if (!GuiScreen.func_146272_n()) {
            par3.add(StatCollector.func_74837_a((String)"itemInfo.pressShiftInfo.name", (Object[])new Object[]{EnumChatFormatting.AQUA, EnumChatFormatting.GRAY}));
            return;
        }
        int waterPer = (int)(this.getWater(par1) / (double)this.selfVent * 100.0);
        double effizens = this.getHeatOfStack(par1) < 100 ? 0.0 : this.getHeatLevel(par1) * 100.0;
        double steamProduction = (double)this.selfVent * effizens;
        steamProduction /= 100.0;
        steamProduction /= 40.0;
        par3.add(StatCollector.func_74837_a((String)"itemInfo.steamVentWater.name", (Object[])new Object[]{waterPer + "%"}));
        par3.add(StatCollector.func_74837_a((String)"itemInfo.steamVentHeat.name", (Object[])new Object[]{(int)effizens + "%"}));
        par3.add(StatCollector.func_74837_a((String)"itemInfo.steamVentSteam.name", (Object[])new Object[]{(int)(steamProduction *= 160.0) + "~ mB"}));
    }
}

