/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.energy.EnergyNet;
import ic2.api.item.IMachineUpgradeItem;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.api.tile.IMachine;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.ContainerElectricMachine;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileEntityElectricMachine
extends TileEntityElecMachine
implements IHasGui,
INetworkTileEntityEventListener,
ISidedInventory,
IMachine {
    public short progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float serverChargeLevel;
    public float serverProgress;
    public float soundLevel = 1.0f;
    public AudioSource audioSource;
    public boolean redstoneInverted;
    public boolean redstoneSensitive;
    public boolean defaultSensitive;
    public List<ItemStack> results = new ArrayList<ItemStack>();
    private static int EventStart = 0;
    private static int EventInterrupt = 1;
    private static int EventStop = 2;

    public TileEntityElectricMachine(int slots, int e, int length, int maxinput) {
        super(slots + 4, 1, e * length + maxinput - 1, maxinput);
        this.energyConsume = e;
        this.defaultEnergyConsume = e;
        this.operationLength = length;
        this.defaultOperationLength = length;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = e * length;
        this.defaultSensitive = false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.results.clear();
        NBTTagList list = nbttagcompound.func_150295_c("Results", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            this.results.add(ItemStack.func_77949_a((NBTTagCompound)nbt));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.results) {
            NBTTagCompound nbt = new NBTTagCompound();
            item.func_77955_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        nbttagcompound.func_74782_a("Results", (NBTBase)list);
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)this.maxEnergy;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public float getProgress() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public void setProgress(float progress) {
        assert (!IC2.platform.isSimulating());
        this.serverProgress = progress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    @Override
    public boolean isProcessing() {
        return this.getActive();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = this.addToInventory();
        RecipeOutput output = this.getOutput();
        boolean canWork = this.canWork();
        if (this.energy <= this.energyConsume * this.operationLength && output != null && canWork && this.provideEnergy()) {
            needsInvUpdate = true;
        }
        if (canWork && output != null && this.energy >= this.energyConsume) {
            this.setActive(true);
            if (this.progress == 0) {
                IC2.network.get().initiateTileEntityEvent(this, 0, true);
            }
            this.progress = (short)(this.progress + 1);
            this.energy -= this.energyConsume;
            if (this.progress >= this.operationLength) {
                this.operate(this.copy(output));
                needsInvUpdate = true;
                this.progress = 0;
                IC2.network.get().initiateTileEntityEvent(this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                IC2.network.get().initiateTileEntityEvent(this, 1, true);
            }
            if (output == null) {
                this.progress = 0;
            }
            this.setActive(false);
        }
        for (int i = 0; i < 4; ++i) {
            IMachineUpgradeItem upgrade;
            ItemStack item = this.inventory[i + this.inventory.length - 4];
            if (item == null || !(item.func_77973_b() instanceof IMachineUpgradeItem) || !(upgrade = (IMachineUpgradeItem)item.func_77973_b()).onTick(item, this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    private RecipeOutput getOutput() {
        if (this.inventory[0] == null && !this.canWorkWithoutItems()) {
            return null;
        }
        if (this.results.size() > 0) {
            return null;
        }
        ItemStack item = ItemStack.func_77944_b((ItemStack)this.inventory[0]);
        RecipeOutput out = this.getResultFor(item, false);
        if (out == null) {
            return null;
        }
        if (this.inventory[2] == null) {
            return out;
        }
        for (ItemStack output : out.items) {
            if (!this.inventory[2].func_77969_a(output) || !ItemStack.func_77970_a((ItemStack)this.inventory[2], (ItemStack)output)) continue;
            if (this.inventory[2].field_77994_a + output.field_77994_a > this.inventory[2].func_77976_d()) break;
            return out;
        }
        return null;
    }

    public boolean canWorkWithoutItems() {
        return false;
    }

    private RecipeOutput copy(RecipeOutput par1) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : par1.items) {
            items.add(item.func_77946_l());
        }
        return new RecipeOutput(par1.metadata, items);
    }

    public void setOverclockRates() {
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = this.defaultSensitive;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = this.inventory[i + this.inventory.length - 4];
            if (item == null || !(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraProcessTime += upgrade.getExtraProcessTime(item, this) * item.field_77994_a;
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(item, this), item.field_77994_a);
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.field_77994_a;
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.field_77994_a);
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.field_77994_a;
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.field_77994_a);
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, this), item.field_77994_a));
            extraTier += upgrade.getExtraTier(item, this) * item.field_77994_a;
            if (!upgrade.useRedstoneinverter(item, this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.energyConsume = TileEntityElectricMachine.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.operationLength = TileEntityElectricMachine.applyModifier(this.defaultOperationLength, extraProcessTime, processTimeMultiplier);
        this.maxEnergy = TileEntityElectricMachine.applyModifier(this.defaultEnergyStorage, extraEnergyStorage, energyStorageMultiplier);
        this.tier = this.baseTier + extraTier;
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        this.soundLevel = soundModfier;
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        IC2.network.get().updateTileEntityField(this, "redstoneInverted");
        IC2.network.get().updateTileEntityField(this, "redstoneSensitive");
        IC2.network.get().updateTileEntityField(this, "soundLevel");
    }

    @Override
    public boolean provideEnergy() {
        if (this.inventory[this.fuelslot] != null && this.inventory[this.fuelslot].func_77973_b() == Items.field_151137_ax) {
            this.energy += this.defaultEnergyConsume * this.defaultOperationLength;
            ItemStack itemStack = this.inventory[this.fuelslot];
            --itemStack.field_77994_a;
            if (this.inventory[this.fuelslot].field_77994_a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return super.provideEnergy();
    }

    public boolean addToInventory() {
        if (this.results.isEmpty()) {
            return false;
        }
        int added = 0;
        for (int i = 0; i < this.results.size(); ++i) {
            int itemLeft;
            ItemStack item = this.results.get(i);
            if (item != null && item.field_77994_a <= 0) {
                this.results.remove(i--);
                continue;
            }
            if (this.inventory[2] == null) {
                this.inventory[2] = ItemStack.func_77944_b((ItemStack)item);
                this.results.remove(i--);
                ++added;
                continue;
            }
            int left = this.inventory[2].func_77976_d() - this.inventory[2].field_77994_a;
            if (left <= 0) break;
            if (left >= item.field_77994_a) {
                this.inventory[2].field_77994_a += item.field_77994_a;
                ++added;
                this.results.remove(i--);
                continue;
            }
            item.field_77994_a = itemLeft = item.field_77994_a - left;
            this.inventory[2].field_77994_a = this.inventory[2].func_77976_d();
            ++added;
            break;
        }
        return added > 0;
    }

    public void operate(RecipeOutput output) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        this.operateOnce(output, result);
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = this.inventory[i + this.inventory.length - 4];
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
            item.onProcessEnd(itemStack, this, result);
        }
        if (result.size() > 0) {
            this.results.addAll(result);
            this.addToInventory();
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    public void operateOnce(RecipeOutput result, List<ItemStack> items) {
        this.getResultFor(this.inventory[0], true);
        items.addAll(result.items);
    }

    public abstract RecipeOutput getResultFor(ItemStack var1, boolean var2);

    @Override
    public abstract String func_145825_b();

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricMachine(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource != null && this.audioSource.isRemoved()) {
            this.audioSource = null;
        }
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getStartSoundFile(), true, false, IC2.audioManager.defaultVolume * this.soundLevel);
            this.audioSource.setLoop(true);
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce(this, PositionSpec.Center, this.getInterruptSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("soundLevel") && this.audioSource != null) {
            this.audioSource.setVolume(IC2.audioManager.defaultVolume * this.soundLevel);
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{2, 0};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (i == 2) {
            return false;
        }
        return this.isValidInput(itemstack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (i == 0) {
            return false;
        }
        return super.func_102008_b(i, itemstack, j);
    }

    static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.energy = (int)((double)this.energy - amount);
        }
        return true;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
        if (this.redstoneSensitive != active) {
            this.redstoneSensitive = active;
        }
    }

    public boolean canWork() {
        if (!this.redstoneSensitive) {
            return true;
        }
        return this.isRedstonePowered();
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstoneInverted) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        return this.inventory[0] == null || this.inventory[0].func_77969_a(par1) && ItemStack.func_77970_a((ItemStack)this.inventory[0], (ItemStack)par1);
    }

    @Override
    public List<IMachine.UpgradeType> getSupportedTypes() {
        ArrayList<IMachine.UpgradeType> list = new ArrayList<IMachine.UpgradeType>();
        list.addAll(Arrays.asList(IMachine.UpgradeType.values()));
        return list;
    }
}

