/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.info.IC2Classic;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerWindGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.util.StackUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TileEntityWindGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public double subproduction = 0.0;
    public double substorage = 0.0;
    public int ticker = randomizer.nextInt(this.tickRate());
    public int obscuratedBlockCount;

    public TileEntityWindGenerator() {
        super(1, 4, 4);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        double prod = this.subproduction / 3.0;
        int re = (int)(prod * (double)i);
        if (re < 0) {
            return 0;
        }
        if (re > i) {
            return i;
        }
        return re;
    }

    public int getOverheatScaled(int i) {
        double prod = (this.subproduction - 5.0) / 5.0;
        if (this.subproduction <= 5.0) {
            return 0;
        }
        if (this.subproduction >= 10.0) {
            return i;
        }
        return (int)(prod * (double)i);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateObscuratedBlockCount();
    }

    @Override
    public boolean gainEnergy() {
        ++this.ticker;
        if (this.ticker % this.tickRate() == 0) {
            if (this.ticker % (8 * this.tickRate()) == 0) {
                this.updateObscuratedBlockCount();
            }
            this.subproduction = ((IC2Classic.enabledCustoWindNetwork() ? (float)IC2Classic.getWindNetwork().getWindStrenght(this.field_145850_b) : (float)IC2.windStrength) * (float)this.field_145848_d - 64.0f - (float)this.obscuratedBlockCount) / 750.0f;
            if (this.subproduction <= 0.0) {
                return false;
            }
            if (this.field_145850_b.func_72911_I()) {
                this.subproduction *= 1.5;
            } else if (this.field_145850_b.func_72896_J()) {
                this.subproduction *= 1.2;
            }
            if (this.subproduction > 5.0 && (double)this.field_145850_b.field_73012_v.nextInt(5000) <= this.subproduction - 5.0) {
                this.subproduction = 0.0;
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, Block.func_149634_a((Item)Ic2Items.generator.func_77973_b()), Ic2Items.generator.func_77960_j(), 3);
                for (int i = this.field_145850_b.field_73012_v.nextInt(5); i > 0; --i) {
                    StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(Items.field_151042_j));
                }
                return false;
            }
            this.subproduction *= (double)IC2.energyGeneratorWind;
            this.subproduction /= 100.0;
        }
        this.substorage += this.subproduction;
        this.production = (short)this.substorage;
        if (this.storage + this.production >= this.maxStorage) {
            this.substorage = 0.0;
            return false;
        }
        this.storage = (short)(this.storage + (short)this.production);
        this.substorage -= (double)this.production;
        return true;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    public void updateObscuratedBlockCount() {
        this.obscuratedBlockCount = -1;
        for (int x = -4; x < 5; ++x) {
            for (int y = -2; y < 5; ++y) {
                for (int z = -4; z < 5; ++z) {
                    if (this.field_145850_b.func_147437_c(x + this.field_145851_c, y + this.field_145848_d, z + this.field_145849_e)) continue;
                    ++this.obscuratedBlockCount;
                }
            }
        }
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public String func_145825_b() {
        return "Wind Mill";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiWindGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WindGenLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWindGenerator(entityPlayer, this);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    @Override
    public int getMaxEnergyAmount() {
        return 4;
    }
}

