/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropSeedFood
extends CropCardBase {
    private String name;
    private int spriteIndex;
    private String color;
    private ItemStack gain;

    public CropSeedFood(String name, int spriteIndex, String color, ItemStack gain) {
        this.name = name;
        this.spriteIndex = spriteIndex;
        this.color = color;
        this.gain = gain;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{this.color, "Food", this.name};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        return Ic2Icons.getTexture("bc")[crop.getSize() < 3 ? 47 + crop.getSize() : this.spriteIndex];
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 3 && crop.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return this.gain.func_77946_l();
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 1;
    }

    @Override
    public int maxSize() {
        return 3;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

