/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerIC2;
import ic2.core.GuiIC2ErrorScreen;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.IItemTickListener;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.Platform;
import ic2.core.audio.GuiChoseAudioManager;
import ic2.core.audio.PositionSpec;
import ic2.core.block.EntityDynamite;
import ic2.core.block.EntityIC2Explosive;
import ic2.core.block.RenderBlockCable;
import ic2.core.block.RenderBlockCrop;
import ic2.core.block.RenderBlockFence;
import ic2.core.block.RenderExplosiveBlock;
import ic2.core.block.RenderFlyingItem;
import ic2.core.block.machine.RenderBlockMiningPipe;
import ic2.core.block.personal.RenderBlockPersonal;
import ic2.core.block.personal.TileEntityPersonalChest;
import ic2.core.block.personal.TileEntityPersonalChestRenderer;
import ic2.core.block.wiring.RenderBlockLuminator;
import ic2.core.item.tool.EntityMiningLaser;
import ic2.core.item.tool.ItemElectricToolChainsaw;
import ic2.core.item.tool.ItemNanoSaber;
import ic2.core.item.tool.RenderCrossed;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenOptionsSounds;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PlatformClient
extends Platform {
    private static Minecraft mc;
    public static boolean open;
    private boolean debug;
    private static Achievement a;
    private int playerCounter;
    private Map renders;

    @Override
    public void init() {
        super.init();
        this.debug = false;
        this.playerCounter = -1;
        this.renders = new HashMap();
        mc = FMLClientHandler.instance().getClient();
        a = new Achievement("ic2Achievementpage", new String(new byte[]{105, 99, 50, 105, 110, 102, 111}), 0, 0, Item.func_150898_a((Block)Blocks.field_150335_W), (Achievement)null);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockCable());
        this.renders.put("cable", RenderBlockCable.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockCrop());
        this.renders.put("crop", RenderBlockCrop.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockFence());
        this.renders.put("fence", RenderBlockFence.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockLuminator());
        this.renders.put("luminator", RenderBlockLuminator.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockMiningPipe());
        this.renders.put("miningPipe", RenderBlockMiningPipe.renderId);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBlockPersonal());
        this.renders.put("personal", RenderBlockPersonal.renderId);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPersonalChest.class, (TileEntitySpecialRenderer)new TileEntityPersonalChestRenderer());
        RenderingRegistry.registerEntityRenderingHandler(EntityIC2Explosive.class, (Render)new RenderExplosiveBlock());
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (Render)new RenderFlyingItem(62, Ic2Icons.getTexture("i0")));
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningLaser.class, (Render)new RenderCrossed(new ResourceLocation("ic2", "textures/guiSprites/laser.png")));
    }

    @Override
    public void postInit() {
    }

    @Override
    public void displayError(String error) {
        FMLLog.severe((String)("IndustrialCraft 2 Error\n\n" + error).replace("\n", System.getProperty("line.separator")), (Object[])new Object[0]);
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_71443_c, (int)minecraft.field_71440_d);
        ScaledResolution scaledResolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        minecraft.func_71364_i();
        GuiIC2ErrorScreen errorScreen = new GuiIC2ErrorScreen(error);
        errorScreen.func_146280_a(minecraft, scaledResolution.func_78326_a(), scaledResolution.func_78328_b());
        errorScreen.func_73863_a(0, 0, 0.0f);
        GL11.glFinish();
        Display.update();
        try {
            Thread.sleep(30000L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Display.destroy();
        FMLCommonHandler.instance().exitJava(0, false);
    }

    @Override
    public EntityPlayer getPlayerInstance() {
        return FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public boolean launchGuiClient(EntityPlayer entityPlayer, IHasGui inventory) {
        GuiScreen guiScreen;
        String clientPackage = "ic2.core";
        Package pkg = PlatformClient.class.getPackage();
        if (pkg != null) {
            clientPackage = pkg.getName();
        }
        ContainerIC2 container = inventory.getGuiContainer(entityPlayer);
        Class<?> containerClass = ((Object)((Object)container)).getClass();
        try {
            guiScreen = (GuiScreen)Class.forName(clientPackage + "." + inventory.getGuiClassName(entityPlayer)).getConstructor(containerClass).newInstance(containerClass.cast((Object)container));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FMLClientHandler.instance().displayGuiScreen(entityPlayer, guiScreen);
        return true;
    }

    @Override
    public void profilerStartSection(String section) {
    }

    @Override
    public void profilerEndSection() {
    }

    @Override
    public void profilerEndStartSection(String section) {
    }

    @Override
    public void addLocalization(String name, String desc) {
        super.addLocalization(name, desc);
    }

    @Override
    public File getMinecraftDir() {
        return FMLClientHandler.instance().getClient().field_71412_D;
    }

    @Override
    public void playSoundSp(String sound, float f, float g) {
        FMLClientHandler.instance().getClient().field_71441_e.func_72956_a((Entity)this.getPlayerInstance(), sound, f, g);
    }

    @Override
    public IIcon getBlockTexture(Block block, IBlockAccess world, int x, int y, int z, int side) {
        return block.func_149673_e(world, x, y, z, side);
    }

    @Override
    public World getWorld(int dimID) {
        if (this.isSimulating()) {
            return super.getWorld(dimID);
        }
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        return world.field_73011_w.field_76574_g == dimID ? world : null;
    }

    @Override
    public World getClientWorld(int dimID) {
        if (this.isSimulating()) {
            return super.getWorld(dimID);
        }
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        return world.field_73011_w.field_76574_g == dimID ? world : null;
    }

    @Override
    public int addArmor(String name) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)name);
    }

    @Override
    public int getRenderId(String name) {
        return (Integer)this.renders.get(name);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        IC2.keyboard.sendKeyUpdate();
        IC2.audioManager.onTick();
        EntityPlayer player = this.getPlayerInstance();
        if (player != null) {
            for (int i = 0; i < 4; ++i) {
                if (player.field_71071_by.field_70460_b[i] == null || !(player.field_71071_by.field_70460_b[i].func_77973_b() instanceof IItemTickListener)) continue;
                ((IItemTickListener)player.field_71071_by.field_70460_b[i].func_77973_b()).onTick(player, player.field_71071_by.field_70460_b[i]);
            }
            if (ItemElectricToolChainsaw.audioSource != null && (player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() != Ic2Items.chainsaw.func_77973_b())) {
                ItemElectricToolChainsaw.audioSource.stop();
                ItemElectricToolChainsaw.audioSource.remove();
                ItemElectricToolChainsaw.audioSource = null;
                ItemElectricToolChainsaw.wasEquipped = false;
                IC2.audioManager.playOnce(player, PositionSpec.Hand, "Tools/Chainsaw/ChainsawStop.ogg", true, IC2.audioManager.defaultVolume);
            }
            if (ItemNanoSaber.sound != null) {
                boolean found = false;
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack cu = player.field_71071_by.func_70301_a(i);
                    if (cu != null && cu.func_77973_b() == Ic2Items.enabledNanoSaber.func_77973_b()) {
                        found = true;
                        break;
                    }
                    if (i != player.field_71071_by.field_70461_c || player.field_71071_by.func_70448_g() == null || player.field_71071_by.func_70448_g().func_77973_b() != Ic2Items.enabledNanoSaber.func_77973_b() && player.field_71071_by.func_70448_g().func_77973_b() != Ic2Items.nanoSaber.func_77973_b()) continue;
                    found = true;
                }
                if (!found) {
                    ItemNanoSaber.sound.stop();
                    ItemNanoSaber.sound.remove();
                    ItemNanoSaber.sound = null;
                }
            }
        }
        if (this.debug) {
            PlatformClient.mc.field_71458_u.func_146255_b(a);
        }
    }

    @SubscribeEvent
    public void onGuiOpened(GuiOpenEvent evt) {
        GuiScreen screen = evt.gui;
        if (screen != null) {
            if (screen instanceof GuiScreenOptionsSounds && !open) {
                evt.gui = new GuiChoseAudioManager();
                open = true;
            } else if (open && screen instanceof GuiMainMenu) {
                open = false;
            }
        } else {
            open = false;
        }
    }

    static {
        open = false;
    }
}

