/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import sonar.calculator.mod.common.tileentity.machines.TileEntityStorageChamber;
import sonar.core.network.PacketCoords;
import sonar.core.network.PacketTileEntityHandler;

public class PacketStorageChamber
extends PacketCoords {
    public int id;
    public int value;

    public PacketStorageChamber() {
    }

    public PacketStorageChamber(int x, int y, int z, int id, int value) {
        super(x, y, z);
        this.id = id;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.id = buf.readInt();
        this.value = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
        buf.writeInt(this.value);
    }

    public static class Handler
    extends PacketTileEntityHandler<PacketStorageChamber> {
        public IMessage processMessage(PacketStorageChamber message, TileEntity target) {
            if (target != null && target instanceof TileEntityStorageChamber) {
                TileEntityStorageChamber chamber = (TileEntityStorageChamber)target;
                chamber.stored[message.id] = message.value;
            }
            return null;
        }
    }
}

