/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.nei.handlers;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.client.gui.machines.GuiHealthProcessor;
import sonar.calculator.mod.common.recipes.machines.HealthProcessorRecipes;
import sonar.core.helpers.FontHelper;

public class HealthProcessorRecipeHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(73, 27, 16, 8), "healthvalue", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiHealthProcessor.class;
    }

    public String getRecipeName() {
        return FontHelper.translate((String)"tile.HealthProcessor.name");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("healthvalue") && ((Object)((Object)this)).getClass() == HealthProcessorRecipeHandler.class) {
            Map recipes = HealthProcessorRecipes.instance().getRecipes();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new ChancePair(recipe.getKey(), (Integer)recipe.getValue()));
            }
            this.transferRects.clear();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        int healthValue = HealthProcessorRecipes.instance().getOutput(ingredient);
        if (healthValue != 0) {
            this.arecipes.add(new ChancePair(ingredient, healthValue));
        }
    }

    public String getGuiTexture() {
        return "Calculator:textures/gui/guicalculatorplug.png";
    }

    public void drawExtras(int recipe) {
        ChancePair pair = (ChancePair)((Object)this.arecipes.get(recipe));
        int value = pair.value;
        FontHelper.textCentre((String)("Health Points = " + value), (int)176, (int)8, (int)0);
    }

    public String getOverlayIdentifier() {
        return "circuitextraction";
    }

    public class ChancePair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        public int value;

        public ChancePair(Object result, int chance) {
            super((TemplateRecipeHandler)HealthProcessorRecipeHandler.this);
            this.input = new PositionedStack(result, 75, 23);
            this.value = chance;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(HealthProcessorRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

