/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IStability;
import sonar.core.common.tileentity.TileEntitySidedInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.utils.ISyncTile;

public class TileEntityStorageChamber
extends TileEntitySidedInventory
implements ISyncTile,
ISidedInventory {
    public static int maxSize = 5000;
    public int[] stored = new int[14];
    public ItemStack savedStack;
    public int renderTicks;

    public void func_145845_h() {
        super.func_145845_h();
        this.renderTicks = this.renderTicks != 1300 ? ++this.renderTicks : 0;
    }

    public TileEntityStorageChamber() {
        this.slots = new ItemStack[14];
        this.input = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        this.output = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    }

    public int func_70302_i_() {
        return this.stored.length * 2;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean isInputSlot(int slot) {
        return slot < this.stored.length;
    }

    public boolean isOutputSlot(int slot) {
        return slot >= this.stored.length;
    }

    public ItemStack getInputStack(int slot) {
        if (this.getSavedStack() == null || this.stored[slot] == 0) {
            return null;
        }
        int stackSize = 0;
        int current = (int)Math.floor(this.stored[slot] / this.savedStack.func_77976_d());
        stackSize = current == maxSize ? this.savedStack.func_77976_d() : this.stored[slot] - current * this.savedStack.func_77976_d();
        if (stackSize == 0) {
            return null;
        }
        ItemStack outputStack = this.savedStack.func_77946_l();
        outputStack.func_77964_b(slot);
        outputStack.field_77994_a = stackSize;
        if (stackSize == this.savedStack.func_77976_d()) {
            return null;
        }
        return outputStack;
    }

    public ItemStack func_70301_a(int var1) {
        int slot = var1 - this.stored.length;
        if (this.isInputSlot(var1)) {
            return this.getInputStack(var1);
        }
        if (this.isOutputSlot(var1)) {
            return this.getSlotStack(slot, 1);
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int var2) {
        if (this.isOutputSlot(slot)) {
            int derc = Math.min(var2, this.stored[slot - this.stored.length]);
            ItemStack output = this.getSlotStack(slot - this.stored.length, derc);
            int n = slot - this.stored.length;
            this.stored[n] = this.stored[n] - derc;
            if (this.stored[slot - this.stored.length] == 0) {
                this.slots[slot - this.stored.length] = null;
                this.resetSavedStack(slot - this.stored.length);
            }
            return output;
        }
        if (this.slots[slot] != null) {
            if (this.slots[slot].field_77994_a <= var2) {
                ItemStack itemstack = this.slots[slot];
                this.slots[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[slot].func_77979_a(var2);
            if (this.slots[slot].field_77994_a == 0) {
                this.slots[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.isInputSlot(i)) {
            if (itemstack == null) {
                return;
            }
            int n = itemstack.func_77960_j();
            this.stored[n] = this.stored[n] + 1;
            if (this.getSavedStack() == null) {
                this.setSavedStack(itemstack);
            }
        } else if (this.isOutputSlot(i)) {
            this.decreaseStored(i - this.stored.length, 1);
        }
    }

    public void setDisplayContents(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack != null) {
            if (this.stored[stack.func_77960_j()] == maxSize) {
                return false;
            }
            if (this.getSavedStack() != null) {
                if (TileEntityStorageChamber.getCircuitType(this.getSavedStack()) == TileEntityStorageChamber.getCircuitType(stack)) {
                    return true;
                }
            } else if (TileEntityStorageChamber.getCircuitType(stack) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.isInputSlot(slot) && this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.isOutputSlot(slot) && !this.isInputSlot(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (stack != null && this.isInputSlot(slot)) {
            if (stack.func_77960_j() != slot) {
                return false;
            }
            if (this.getSavedStack() != null) {
                if (TileEntityStorageChamber.getCircuitType(this.getSavedStack()) == TileEntityStorageChamber.getCircuitType(stack)) {
                    return true;
                }
            } else if (TileEntityStorageChamber.getCircuitType(stack) != null) {
                return true;
            }
        }
        return false;
    }

    public ItemStack getFullStack(int slot) {
        if (this.stored[slot] != 0 && this.getSavedStack() != null) {
            ItemStack fullStack = new ItemStack(this.getSavedStack().func_77973_b(), this.stored[slot], slot);
            fullStack.func_77982_d(this.getSavedStack().func_77978_p());
            return fullStack;
        }
        return null;
    }

    public ItemStack getSlotStack(int slot, int size) {
        if (this.stored[slot] != 0 && this.getSavedStack() != null) {
            ItemStack slotStack = new ItemStack(this.getSavedStack().func_77973_b(), size, slot);
            slotStack.func_77982_d(this.getSavedStack().func_77978_p());
            return slotStack;
        }
        return null;
    }

    public void resetSavedStack(int removed) {
        boolean found = false;
        for (int i = 0; i < this.stored.length; ++i) {
            if (i == removed || this.stored[i] == 0) continue;
            found = true;
            return;
        }
        if (!found) {
            this.setSavedStack(null);
        }
    }

    public ItemStack getSavedStack() {
        return this.savedStack;
    }

    public int[] getStored() {
        return this.stored;
    }

    public void setStored(int slot, int set) {
        this.stored[slot] = set;
    }

    public void increaseStored(int slot, int increase) {
        if (!this.field_145850_b.field_72995_K) {
            int n = slot;
            this.stored[n] = this.stored[n] + increase;
        }
    }

    public void decreaseStored(int slot, int decrease) {
        if (this.stored[slot] == 1) {
            this.resetSavedStack(slot);
        }
        int n = slot;
        this.stored[n] = this.stored[n] - decrease;
    }

    public void setSavedStack(ItemStack stack) {
        if (stack != null) {
            stack.field_77994_a = 1;
        }
        this.savedStack = stack;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static CircuitType getCircuitType(ItemStack stack) {
        if (stack != null) {
            if (stack.func_77973_b() == Calculator.circuitBoard) {
                if (stack.func_77973_b() instanceof IStability) {
                    IStability stability = (IStability)stack.func_77973_b();
                    if (stability.getStability(stack)) {
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74768_a("Stable", 1);
                        tag.func_74768_a("Item1", 0);
                        tag.func_74768_a("Item2", 0);
                        tag.func_74768_a("Item3", 0);
                        tag.func_74768_a("Item4", 0);
                        tag.func_74768_a("Item5", 0);
                        tag.func_74768_a("Item6", 0);
                        tag.func_74768_a("Energy", 0);
                        ItemStack stable = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                        stable.func_77982_d(tag);
                        if (ItemStack.func_77970_a((ItemStack)stable, (ItemStack)stack)) {
                            return CircuitType.Stable;
                        }
                    } else {
                        if (!stack.func_77942_o()) {
                            return CircuitType.Analysed;
                        }
                        if (stack.func_77942_o()) {
                            NBTTagCompound tag = new NBTTagCompound();
                            tag.func_74768_a("Stable", 0);
                            tag.func_74768_a("Item1", 0);
                            tag.func_74768_a("Item2", 0);
                            tag.func_74768_a("Item3", 0);
                            tag.func_74768_a("Item4", 0);
                            tag.func_74768_a("Item5", 0);
                            tag.func_74768_a("Item6", 0);
                            tag.func_74768_a("Energy", 0);
                            ItemStack analysed = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                            analysed.func_77982_d(tag);
                            if (ItemStack.func_77970_a((ItemStack)analysed, (ItemStack)stack)) {
                                return CircuitType.Analysed;
                            }
                        }
                    }
                }
            } else {
                if (stack.func_77973_b() == Calculator.circuitDamaged) {
                    return CircuitType.Damaged;
                }
                if (stack.func_77973_b() == Calculator.circuitDirty) {
                    return CircuitType.Dirty;
                }
            }
        }
        return null;
    }

    public static CircuitType getCircuitType(int type) {
        if (type == 2) {
            return CircuitType.Stable;
        }
        if (type == 3) {
            return CircuitType.Damaged;
        }
        if (type == 5) {
            return CircuitType.Dirty;
        }
        return CircuitType.Analysed;
    }

    public static int getCircuitValue(CircuitType type) {
        if (type == CircuitType.Stable) {
            return 2;
        }
        if (type == CircuitType.Damaged) {
            return 3;
        }
        if (type == CircuitType.Dirty) {
            return 4;
        }
        return 1;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.DROP) {
            this.stored = nbt.func_74759_k("Stored");
            if (this.stored == null) {
                this.stored = new int[14];
            }
            this.savedStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("saved"));
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74783_a("Stored", this.stored);
            NBTTagCompound stack = new NBTTagCompound();
            if (this.savedStack != null) {
                this.savedStack.func_77955_b(stack);
            }
            nbt.func_74782_a("saved", (NBTBase)stack);
        } else if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74783_a("Stored", this.stored);
            if (this.getSavedStack() != null) {
                NBTTagCompound stack = new NBTTagCompound();
                this.getSavedStack().func_77955_b(stack);
                nbt.func_74782_a("saved", (NBTBase)stack);
                nbt.func_74768_a("type", TileEntityStorageChamber.getCircuitValue(TileEntityStorageChamber.getCircuitType(this.getSavedStack())));
            }
        }
    }

    private static enum CircuitType {
        Analysed,
        Stable,
        Damaged,
        Dirty;

    }
}

