/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.items.IResearchStore;
import sonar.calculator.mod.api.items.IStability;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.calculator.mod.common.tileentity.misc.TileEntityCalculator;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.utils.ISyncTile;

public class TileEntityResearchChamber
extends TileEntityInventory
implements ISyncTile {
    public int ticks;
    public int researchSpeed = 100;
    public int lastResearch;
    public Map<Integer, Integer> unblocked = new THashMap();
    public Random rand = new Random();
    public int maxRecipes;
    public int storedRecipes;

    public TileEntityResearchChamber() {
        this.slots = new ItemStack[2];
    }

    public void func_145845_h() {
        super.func_145845_h();
    }

    public void beginResearch() {
        if (this.slots[0] == null) {
            this.ticks = 0;
            this.lastResearch = 0;
            return;
        }
        if (RecipeRegistry.CalculatorRecipes.instance().validInput(this.slots[0]) || RecipeRegistry.CalculatorRecipes.instance().validOutput(this.slots[0]) || this.slots[0].func_77973_b() == Calculator.circuitBoard && this.slots[0].func_77973_b() instanceof IStability && ((IStability)this.slots[0].func_77973_b()).getStability(this.slots[0])) {
            if (this.ticks == 0) {
                this.ticks = 1;
            }
            if (this.ticks > 0) {
                if (this.ticks != this.researchSpeed) {
                    ++this.ticks;
                } else {
                    if (!this.field_145850_b.field_72995_K) {
                        this.addResearch(this.slots[0]);
                        this.syncResearch();
                    }
                    this.ticks = -1;
                }
            }
        }
    }

    public void syncResearch() {
        if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IResearchStore) {
            Map<Integer, Integer> storedResearch = ((IResearchStore)this.slots[1].func_77973_b()).getResearch(this.slots[1]);
            Map<Integer, Integer> syncResearch = this.unblocked;
            for (Map.Entry<Integer, Integer> recipes : storedResearch.entrySet()) {
                if (recipes.getValue() <= syncResearch.get(recipes.getKey())) continue;
                syncResearch.put(recipes.getKey(), recipes.getValue());
            }
            ((IResearchStore)this.slots[1].func_77973_b()).setResearch(this.slots[1], syncResearch, this.storedRecipes, this.maxRecipes);
            this.unblocked = syncResearch;
            this.storedRecipes = this.unblocked.size();
        }
        this.sendResearch();
    }

    public void addResearch(ItemStack stack) {
        RecipeRegistry.CalculatorRecipes.instance().unblockStack(this.unblocked, stack);
    }

    public void sendResearch() {
        for (int X = -3; X <= 3; ++X) {
            for (int Y = -3; Y <= 3; ++Y) {
                for (int Z = -3; Z <= 3; ++Z) {
                    TileEntity target = this.field_145850_b.func_147438_o(this.field_145851_c + X, this.field_145848_d + Y, this.field_145849_e + Z);
                    if (target == null || !(target instanceof TileEntityCalculator.Dynamic)) continue;
                    TileEntityCalculator.Dynamic dynamic = (TileEntityCalculator.Dynamic)target;
                }
            }
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type != NBTHelper.SyncType.SYNC) {
            this.unblocked = RecipeRegistry.CalculatorRecipes.instance().readFromNBT(nbt, "unblocked");
        }
        this.lastResearch = nbt.func_74762_e("Research");
        this.maxRecipes = nbt.func_74762_e("Max");
        this.storedRecipes = nbt.func_74762_e("Stored");
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type != NBTHelper.SyncType.SYNC) {
            RecipeRegistry.CalculatorRecipes.instance().writeToNBT(nbt, this.unblocked, "unblocked");
        }
        nbt.func_74768_a("Max", this.maxRecipes);
        nbt.func_74768_a("Stored", this.storedRecipes);
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        super.func_70299_a(i, itemstack);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h, 1, 0);
    }
}

