/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.tile.IEnergySink;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.TileEntityFlux;
import sonar.calculator.mod.common.tileentity.generators.TileEntityCrankHandle;
import sonar.core.common.tileentity.TileEntitySender;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityCrankedGenerator
extends TileEntitySender {
    protected TileEntity[] handlers = new TileEntity[6];
    public boolean cranked;
    public int ticks;
    public int ticksforpower = 2;

    public TileEntityCrankedGenerator() {
        this.storage = new SyncEnergyStorage(1000, 200);
        this.maxTransfer = 32;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.cranked()) {
            TileEntityCrankHandle crank = (TileEntityCrankHandle)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (crank.angle > 0) {
                if (this.ticks == 0) {
                    this.storage.modifyEnergyStored(2);
                }
                ++this.ticks;
                if (this.ticks == this.ticksforpower) {
                    this.ticks = 0;
                }
            }
        }
        int maxTransfer = Math.min(this.maxTransfer, this.storage.getEnergyStored());
        this.storage.extractEnergy(maxTransfer - this.pushEnergy(maxTransfer, false), false);
    }

    public boolean cranked() {
        Block crank = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        return crank != null && crank == Calculator.crank;
    }

    public int pushEnergy(int recieve, boolean simulate) {
        for (int i = 0; i < 6; ++i) {
            if (this.handlers[i] == null) continue;
            if (this.handlers[i] instanceof IEnergyReceiver) {
                recieve -= ((IEnergyReceiver)this.handlers[i]).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], recieve, simulate);
                continue;
            }
            if (!(this.handlers[i] instanceof IEnergySink)) continue;
            recieve = simulate ? (int)((double)recieve - ((IEnergySink)this.handlers[i]).getDemandedEnergy() * 4.0) : (int)((double)recieve - ((double)recieve - ((IEnergySink)this.handlers[i]).injectEnergy(ForgeDirection.VALID_DIRECTIONS[i ^ 1], (double)(recieve / 4), 128.0) * 4.0));
        }
        return recieve;
    }

    public void updateAdjacentHandlers() {
        for (int i = 0; i < 6; ++i) {
            TileEntity te = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.getOrientation((int)i));
            if (te instanceof TileEntityFlux) continue;
            this.handlers[i] = SonarHelper.isEnergyHandlerFromSide((TileEntity)te, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i ^ 1]) ? te : null;
        }
    }

    public void onLoaded() {
        super.onLoaded();
        this.updateAdjacentHandlers();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.cranked = nbt.func_74767_n("cranked");
            this.ticks = nbt.func_74762_e("ticks");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74757_a("cranked", this.cranked());
            nbt.func_74768_a("ticks", this.ticks);
        }
    }

    public List<String> getWailaInfo(List<String> tooltip) {
        tooltip.add(FontHelper.translate((String)"crank.cranked") + ": " + (this.cranked ? FontHelper.translate((String)"locator.true") : FontHelper.translate((String)"locator.false")));
        return tooltip;
    }
}

