/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.machines.IProcessMachine;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.calculator.mod.common.tileentity.machines.TileEntityTransmitter;
import sonar.calculator.mod.common.tileentity.machines.TileEntityWeatherStation;
import sonar.core.common.tileentity.TileEntityInventorySender;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityConductorMast
extends TileEntityInventorySender
implements ISidedInventory,
IProcessMachine {
    public int cookTime;
    public int lightingTicks;
    public int lightTicks;
    public int furnaceSpeed = 50;
    public int lightningSpeed;
    public int strikes;
    public int random;
    public int lastStations;
    public final int weatherStationRF = CalculatorConfig.getInteger("Weather Station");
    public final int strikeRF = CalculatorConfig.getInteger("Conductor Mast");
    public Random rand = new Random();

    public TileEntityConductorMast() {
        this.storage = new SyncEnergyStorage(5000000, 64000);
        this.slots = new ItemStack[2];
        this.maxTransfer = 5000000;
    }

    public ItemStack recipeOutput(ItemStack stack) {
        return RecipeRegistry.ConductorMastItemRecipes.instance().getCraftingResult(new ItemStack[]{stack});
    }

    public int recipeEnergy(ItemStack stack) {
        return RecipeRegistry.ConductorMastPowerRecipes.instance().getPowercost(stack);
    }

    public void onLoaded() {
        TileEntityConductorMast.setWeatherStationAngles(true, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.cookTime > 0) {
            ++this.cookTime;
        }
        if (this.isServer()) {
            if (this.canCook()) {
                if (this.cookTime == 0) {
                    ++this.cookTime;
                }
                if (this.cookTime == this.furnaceSpeed) {
                    this.cookTime = 0;
                    this.cookItem();
                }
            } else {
                this.cookTime = 0;
            }
            if (this.storage.getMaxEnergyStored() != this.storage.getEnergyStored() && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored() && this.lightningSpeed == 0) {
                this.random = (int)(Math.random() * 9.0);
                this.lightningSpeed = this.rand.nextInt(300) + this.getNextTime();
            }
            if (this.lightningSpeed > 0) {
                if (this.lightingTicks >= this.lightningSpeed) {
                    this.lightingTicks = 0;
                    this.lightningSpeed = 0;
                    this.strikes = this.getStrikes();
                    if (this.field_145850_b.field_72995_K) {
                        for (int currentstrikes = this.strikes > 5 ? 5 : this.strikes; currentstrikes != 0; --currentstrikes) {
                            this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 4), (double)this.field_145849_e));
                        }
                    }
                    this.lastStations = this.getStations();
                    ++this.lightTicks;
                } else {
                    ++this.lightingTicks;
                }
            }
        }
        if (this.lightTicks > 0) {
            int add = (this.strikeRF / 200 + this.lastStations * (this.weatherStationRF / 200)) * this.strikes * 4;
            if (this.lightTicks < 200) {
                if (this.storage.getEnergyStored() + add <= this.storage.getMaxEnergyStored()) {
                    ++this.lightTicks;
                    this.storage.receiveEnergy(add, false);
                } else {
                    ++this.lightTicks;
                    this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
                }
            } else if (this.storage.getEnergyStored() + add <= this.storage.getMaxEnergyStored()) {
                this.lightTicks = 0;
                this.storage.receiveEnergy(add, false);
            } else {
                ++this.lightTicks;
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
        }
        this.addEnergy();
        this.func_70296_d();
    }

    private void addEnergy() {
        TileEntity entity = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN);
        if (SonarHelper.isEnergyHandlerFromSide((TileEntity)entity, (ForgeDirection)ForgeDirection.DOWN.getOpposite())) {
            this.storage.extractEnergy(SonarHelper.pushEnergy((TileEntity)entity, (ForgeDirection)ForgeDirection.UP, (int)this.storage.extractEnergy(this.maxTransfer, true), (boolean)false), false);
        }
    }

    private void lightningStrike(World world, int x, int y, int z) {
        if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
        }
    }

    public boolean canCook() {
        if (this.storage.getEnergyStored() == 0) {
            return false;
        }
        if (this.slots[0] == null) {
            return false;
        }
        if (this.cookTime >= this.furnaceSpeed) {
            return true;
        }
        ItemStack itemstack = this.recipeOutput(this.slots[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.slots[1] != null) {
            if (!this.slots[1].func_77969_a(itemstack)) {
                return false;
            }
            if (this.slots[1].field_77994_a + itemstack.field_77994_a > this.slots[1].func_77976_d()) {
                return false;
            }
        }
        int itemEnergy = this.recipeEnergy(this.slots[0]);
        return this.cookTime != 0 || this.storage.getEnergyStored() >= itemEnergy;
    }

    private void cookItem() {
        ItemStack itemstack = this.recipeOutput(this.slots[0]);
        int energy = this.recipeEnergy(this.slots[0]);
        this.storage.modifyEnergyStored(-energy);
        if (this.slots[1] == null) {
            this.slots[1] = itemstack.func_77946_l();
        } else if (this.slots[1].func_77969_a(itemstack)) {
            ++this.slots[1].field_77994_a;
        }
        --this.slots[0].field_77994_a;
        if (this.slots[0].field_77994_a <= 0) {
            this.slots[0] = null;
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.cookTime = nbt.func_74762_e("CookTime");
            this.lightingTicks = nbt.func_74762_e("Ticks");
            this.lightTicks = nbt.func_74762_e("lightTicks");
            this.lightningSpeed = nbt.func_74762_e("lightSpeed");
            this.random = nbt.func_74762_e("rand");
            if (type == NBTHelper.SyncType.SAVE) {
                this.lastStations = nbt.func_74762_e("lastStations");
                this.strikes = nbt.func_74762_e("strikes");
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("CookTime", this.cookTime);
            nbt.func_74768_a("Ticks", this.lightingTicks);
            nbt.func_74768_a("lightTicks", this.lightTicks);
            nbt.func_74768_a("lightSpeed", this.lightningSpeed);
            nbt.func_74768_a("rand", this.random);
            if (type == NBTHelper.SyncType.SAVE) {
                nbt.func_74768_a("lastStations", this.lastStations);
                nbt.func_74768_a("strikes", this.strikes);
            }
        }
    }

    public boolean canConnectEnergy(ForgeDirection direction) {
        return direction == ForgeDirection.DOWN;
    }

    public static void setWeatherStationAngles(boolean packet, World world, int xCoord, int yCoord, int zCoord) {
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                TileEntity target = world.func_147438_o(xCoord + x, yCoord, zCoord + z);
                if (target == null || !(target instanceof TileEntityWeatherStation)) continue;
                TileEntityWeatherStation station = (TileEntityWeatherStation)target;
                station.setAngle();
                world.func_147471_g(xCoord + x, yCoord, zCoord + z);
            }
        }
    }

    public int getStations() {
        int stations = 0;
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                if (this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) == null || !(this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) instanceof TileEntityWeatherStation)) continue;
                TileEntityWeatherStation station = (TileEntityWeatherStation)this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
                if (station.x != this.field_145851_c || station.z != this.field_145849_e) continue;
                ++stations;
            }
        }
        return stations;
    }

    public int getStrikes() {
        int trans = this.getTransmitters();
        if (trans != 0) {
            if (trans > 9) {
                return trans / 4;
            }
            return 1;
        }
        return 1;
    }

    public int getNextTime() {
        int trans = this.getTransmitters();
        if (trans != 0) {
            if (trans > 9) {
                return 250;
            }
            return 1500 - 135 * trans;
        }
        return 1500;
    }

    public int getTransmitters() {
        int transmitter = 0;
        for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                TileEntity target = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
                if (target == null || !(target instanceof TileEntityTransmitter)) continue;
                TileEntityTransmitter station = (TileEntityTransmitter)target;
                ++transmitter;
            }
        }
        return transmitter;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 0) {
            return stack != null && this.recipeOutput(stack) != null;
        }
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public int getCurrentProcessTime() {
        return this.cookTime;
    }

    @Override
    public int getProcessTime() {
        return this.furnaceSpeed;
    }

    @Override
    public double getEnergyUsage() {
        if (this.slots[0] != null) {
            return this.recipeEnergy(this.slots[0]);
        }
        return 0.0;
    }

    @Override
    public int getBaseProcessTime() {
        return this.furnaceSpeed;
    }
}

