/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.items.ILocatorModule;
import sonar.calculator.mod.api.machines.ICalculatorLocator;
import sonar.calculator.mod.common.block.generators.CalculatorLocator;
import sonar.calculator.mod.common.tileentity.generators.TileEntityCalculatorPlug;
import sonar.core.SonarCore;
import sonar.core.common.tileentity.TileEntityInventorySender;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;

public class TileEntityCalculatorLocator
extends TileEntityInventorySender
implements IByteBufTile,
ICalculatorLocator {
    public SyncTagType.BOOLEAN active = new SyncTagType.BOOLEAN(0);
    public SyncTagType.INT size = new SyncTagType.INT(1);
    public SyncTagType.INT stability = new SyncTagType.INT("stability");
    public SyncTagType.STRING owner = (SyncTagType.STRING)new SyncTagType.STRING("owner").setDefault((Object)"None");
    private int sizeTicks;
    private int luckTicks;

    public TileEntityCalculatorLocator() {
        this.storage = new SyncEnergyStorage(25000000, 128000);
        this.slots = new ItemStack[2];
        this.maxTransfer = 100000;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean invert = false;
            if (this.canGenerate()) {
                this.beginGeneration();
                if (!((Boolean)this.active.getObject()).booleanValue()) {
                    invert = true;
                }
            } else if (((Boolean)this.active.getObject()).booleanValue()) {
                invert = true;
            }
            if (invert) {
                this.active.invert();
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)0);
            }
            if (this.sizeTicks < 25) {
                ++this.sizeTicks;
            } else {
                this.sizeTicks = 0;
                this.createStructure();
                this.getStability();
            }
        }
        this.charge(0);
        this.addEnergy();
        this.func_70296_d();
    }

    public int currentOutput() {
        int size = (Integer)this.size.getObject();
        if (size != 0 && (2 * size + 1) * (2 * size + 1) - 1 != 0) {
            int stable = (Integer)this.stability.getObject() * 100 / ((2 * size + 1) * (2 * size + 1));
            return (5 + (int)(1000.0 * Math.sqrt((double)size * 1.8) - 100.0 * Math.sqrt(100 - stable)) / (int)(11.0 - Math.sqrt(stable)) * size) * 2;
        }
        return 0;
    }

    public void getStability() {
        int currentStable = 0;
        if ((Integer)this.size.getObject() == 0) {
            this.stability.setObject((Object)0);
        }
        for (int Z = -((Integer)this.size.getObject()).intValue(); Z <= (Integer)this.size.getObject(); ++Z) {
            for (int X = -((Integer)this.size.getObject()).intValue(); X <= (Integer)this.size.getObject(); ++X) {
                TileEntity target = this.field_145850_b.func_147438_o(this.field_145851_c + X, this.field_145848_d, this.field_145849_e + Z);
                if (target == null || !(target instanceof TileEntityCalculatorPlug)) continue;
                TileEntityCalculatorPlug plug = (TileEntityCalculatorPlug)target;
                currentStable += plug.getS();
            }
        }
        this.stability.setObject((Object)currentStable);
    }

    public boolean canGenerate() {
        if (this.storage.getEnergyStored() >= this.storage.getMaxEnergyStored() || (Integer)this.size.getObject() == 0) {
            return false;
        }
        if (this.isLocated()) {
            if ((Integer)this.stability.getObject() >= 7) {
                return true;
            }
            EntityPlayer player = this.field_145850_b.func_72924_a(this.getOwner());
            if (player != null) {
                return true;
            }
        }
        return false;
    }

    public void beginGeneration() {
        this.storage.modifyEnergyStored(this.currentOutput());
        if (!this.field_145850_b.field_72995_K) {
            if (this.luckTicks >= 0 && this.luckTicks != 50) {
                ++this.luckTicks;
            } else if (this.luckTicks == 50) {
                this.luckTicks = 0;
                this.effectStart();
            }
            if (CalculatorConfig.timeEffect && (Integer)this.stability.getObject() * 4 < 20) {
                this.timeStart();
            }
        }
    }

    private void timeStart() {
        this.field_145850_b.func_72877_b(this.field_145850_b.func_72820_D() + 100L);
    }

    private void addEnergy() {
        TileEntity entity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (SonarHelper.isEnergyHandlerFromSide((TileEntity)entity, (ForgeDirection)ForgeDirection.DOWN)) {
            this.storage.extractEnergy(SonarHelper.pushEnergy((TileEntity)entity, (ForgeDirection)ForgeDirection.UP, (int)this.storage.extractEnergy(this.maxTransfer, true), (boolean)false), false);
        }
    }

    public void addItem(EntityPlayer player, Item item) {
        player.field_71071_by.func_70441_a(new ItemStack(item));
    }

    public void addPotion(EntityPlayer player, int potionID) {
        player.func_70690_d(new PotionEffect(potionID, 1000, 1));
    }

    private void effectStart() {
        EntityPlayer player = this.field_145850_b.func_72924_a(this.getOwner());
        if (player != null) {
            double x = player.field_70165_t;
            double y = player.field_70163_u;
            double z = player.field_70161_v;
            int stability = (Integer)this.stability.getObject();
            int luck = 1 + (int)(Math.random() * (double)(20 * (stability + 1) - 1 + 20 * (stability + 1)));
            if (stability == 0) {
                this.field_145850_b.func_72876_a((Entity)player, x, y, z, 4.0f, true);
                player.func_70606_j(player.func_110143_aJ() - 4.0f);
            } else {
                if (stability < 2) {
                    switch (luck) {
                        case 1: {
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 4.0f, true);
                            player.func_70606_j(player.func_110143_aJ() - 4.0f);
                        }
                    }
                }
                if (stability < 4) {
                    switch (luck) {
                        case 2: {
                            player.func_70015_d(400);
                            break;
                        }
                        case 3: {
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 8.0f, true);
                            break;
                        }
                        case 4: {
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 6.0f, true);
                            break;
                        }
                        case 5: {
                            this.addPotion(player, Potion.field_76431_k.field_76415_H);
                            break;
                        }
                        case 6: {
                            this.addPotion(player, Potion.field_76440_q.field_76415_H);
                        }
                    }
                }
                if (stability < 6) {
                    switch (luck) {
                        case 7: {
                            this.addItem(player, Calculator.grenade);
                            break;
                        }
                        case 8: {
                            this.addItem(player, Calculator.itemScientificCalculator);
                            break;
                        }
                        case 9: {
                            this.addItem(player, Calculator.itemCalculator);
                            break;
                        }
                        case 10: {
                            this.addPotion(player, Potion.field_76430_j.field_76415_H);
                            break;
                        }
                        case 11: {
                            this.addPotion(player, Potion.field_76427_o.field_76415_H);
                            break;
                        }
                        case 12: {
                            this.addPotion(player, Potion.field_76419_f.field_76415_H);
                            break;
                        }
                        case 13: {
                            this.addPotion(player, Potion.field_76420_g.field_76415_H);
                        }
                    }
                }
                if (stability < 7) {
                    switch (luck) {
                        case 14: {
                            this.addPotion(player, Potion.field_82731_v.field_76415_H);
                            break;
                        }
                        case 15: {
                            this.addItem(player, Items.field_151117_aB);
                            break;
                        }
                        case 16: {
                            int luck2;
                            if (luck != 16 || (luck2 = 1 + (int)(Math.random() * 4.0 + 5.0)) != 16) break;
                            this.field_145850_b.func_72876_a((Entity)player, x, y, z, 80.0f, true);
                            player.func_70606_j(player.func_110143_aJ() - 40.0f);
                        }
                    }
                }
            }
        }
    }

    protected boolean isLocated() {
        String name;
        ItemStack stack = this.func_70301_a(1);
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ILocatorModule && (name = ((ILocatorModule)stack.func_77973_b()).getPlayer(stack)) != null && !name.equals("None");
    }

    public void createOwner() {
        String name;
        ItemStack stack = this.func_70301_a(1);
        if (stack == null) {
            this.owner.setObject((Object)"None");
            return;
        }
        if (stack.func_77973_b() instanceof ILocatorModule && (name = ((ILocatorModule)stack.func_77973_b()).getPlayer(stack)) != null) {
            this.owner.setObject((Object)name);
        }
    }

    public void createStructure() {
        int size = CalculatorLocator.multiBlockStructure(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (size != (Integer)this.size.getObject()) {
            this.size.setObject((Object)size);
            SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)1);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.luckTicks = nbt.func_74762_e("ticks");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("ticks", this.luckTicks);
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.add((ISyncPart)this.active);
        parts.add((ISyncPart)this.size);
        parts.add((ISyncPart)this.stability);
        parts.add((ISyncPart)this.owner);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    public boolean maxRender() {
        return true;
    }

    public int beamHeight() {
        boolean f = false;
        for (int i = 1; i <= 256; ++i) {
            if (!this.field_145850_b.isSideSolid(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ForgeDirection.UP)) continue;
            return i;
        }
        return 256;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        currenttip.add(FontHelper.translate((String)"locator.active") + ": " + ((Boolean)this.active.getObject() == false ? FontHelper.translate((String)"locator.false") : FontHelper.translate((String)"locator.true")));
        currenttip.add(FontHelper.translate((String)"locator.owner") + ": " + (!((String)this.owner.getObject()).equals("None") ? (String)this.owner.getObject() : FontHelper.translate((String)"locator.none")));
        return currenttip;
    }

    public void onLoaded() {
        super.onLoaded();
        this.createOwner();
        this.createStructure();
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.active.writeToBuf(buf);
        }
        if (id == 1) {
            this.size.writeToBuf(buf);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.active.readFromBuf(buf);
        }
        if (id == 1) {
            this.size.readFromBuf(buf);
        }
    }

    @Override
    public String getOwner() {
        return (String)this.owner.getObject();
    }

    @Override
    public int getSize() {
        return (Integer)this.size.getObject();
    }

    @Override
    public boolean isActive() {
        return (Boolean)this.active.getObject();
    }

    @Override
    public double getStabilityPercent() {
        return (Integer)this.stability.getObject() * 100 / ((2 * (Integer)this.size.getObject() + 1) * (2 * (Integer)this.size.getObject() + 1) - 1);
    }
}

