/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import java.util.Random;
import net.minecraft.item.ItemStack;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.item.misc.ItemCircuit;
import sonar.calculator.mod.common.tileentity.TileEntityProcess;
import sonar.core.helpers.RecipeHelper;
import sonar.core.network.sync.SyncEnergyStorage;

public abstract class TileEntityAbstractProcess
extends TileEntityProcess {
    public final int inputSize;
    public final int outputSize;
    public final int baseProcess;
    public final int baseEnergy;
    public Random rand = new Random();

    public TileEntityAbstractProcess(int inputSize, int outputSize, int baseProcess, int baseEnergy) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.baseProcess = baseProcess;
        this.baseEnergy = baseEnergy;
        int[] inputs = new int[inputSize];
        int[] outputs = new int[outputSize];
        for (int i = 0; i < inputSize; ++i) {
            inputs[i] = i;
        }
        for (int o = inputSize; o < inputSize + outputSize; ++o) {
            outputs[o - inputSize] = o + 1;
        }
        this.input = inputs;
        this.output = outputs;
        this.storage = new SyncEnergyStorage(CalculatorConfig.getInteger("Standard Machine"), 32000);
        this.slots = new ItemStack[1 + inputSize + outputSize];
    }

    public int inputSize() {
        return this.inputSize;
    }

    public int outputSize() {
        return this.outputSize;
    }

    @Override
    public int getBaseProcessTime() {
        return this.baseProcess;
    }

    @Override
    public int getBaseEnergyUsage() {
        return this.baseEnergy;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.discharge(this.inputSize());
    }

    public RecipeHelper recipeHelper() {
        return null;
    }

    public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
        return this.recipeHelper().getOutput(stacks);
    }

    @Override
    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        if ((Integer)this.cookTime.getObject() == 0 && this.storage.getEnergyStored() < this.requiredEnergy()) {
            return false;
        }
        ItemStack[] output = this.getOutput(true, this.inputStacks());
        if (output == null || output.length != this.outputSize()) {
            return false;
        }
        for (int o = 0; o < this.outputSize(); ++o) {
            if (output[o] == null) {
                return false;
            }
            if (this.slots[o + this.inputSize() + 1] == null) continue;
            if (!this.slots[o + this.inputSize() + 1].func_77969_a(output[o])) {
                return false;
            }
            if (this.slots[o + this.inputSize() + 1].field_77994_a + output[o].field_77994_a <= this.slots[o + this.inputSize() + 1].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public int getMaxInputSize() {
        int size = 1;
        for (int i = 0; i < this.inputSize(); ++i) {
            size = this.slots[i] != null ? Math.max(size, this.slots[i].field_77994_a) : 0;
        }
        return size;
    }

    public int getMaxOutputSize() {
        int size = 1;
        ItemStack[] output = this.getOutput(true, this.inputStacks());
        for (int o = 0; o < this.outputSize(); ++o) {
            size = this.slots[o + this.inputSize() + 1] != null && output[o] != null ? Math.max((this.func_70297_j_() - this.slots[o + this.inputSize() + 1].field_77994_a) / output[o].field_77994_a, size) : 0;
        }
        return size;
    }

    @Override
    public void finishProcess() {
        ItemStack[] output = this.getOutput(false, this.inputStacks());
        for (int o = 0; o < this.outputSize(); ++o) {
            if (output[o] == null) continue;
            if (this.slots[o + this.inputSize() + 1] == null) {
                ItemStack outputStack = output[o].func_77946_l();
                if (output[o].func_77973_b() == Calculator.circuitBoard) {
                    ItemCircuit.setData(outputStack);
                }
                this.slots[o + this.inputSize() + 1] = outputStack;
                continue;
            }
            if (!this.slots[o + this.inputSize() + 1].func_77969_a(output[o])) continue;
            this.slots[o + this.inputSize() + 1].field_77994_a += output[o].field_77994_a;
        }
        for (int i = 0; i < this.inputSize(); ++i) {
            this.slots[i].field_77994_a = this.recipeHelper() != null ? (this.slots[i].field_77994_a -= this.recipeHelper().getInputSize(i, output)) : --this.slots[i].field_77994_a;
            if (this.slots[i].field_77994_a > 0) continue;
            this.slots[i] = null;
        }
    }

    public ItemStack[] inputStacks() {
        ItemStack[] input = new ItemStack[this.inputSize()];
        for (int i = 0; i < this.inputSize(); ++i) {
            input[i] = this.slots[i];
        }
        return input;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < this.inputSize()) {
            if (this.recipeHelper() != null) {
                if (this.recipeHelper().validInput(stack)) {
                    return true;
                }
            } else {
                ItemStack[] inputs = this.inputStacks();
                inputs[slot] = stack;
                if (this.getOutput(true, inputs) != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack) && this.canStack(this.slots[slot], stack);
    }
}

