/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.misc;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import sonar.calculator.mod.api.items.IStability;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;

public class ItemCircuit
extends SonarItem
implements IStability {
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (stack.func_77942_o()) {
            int stable = stack.func_77978_p().func_74762_e("Stable");
            if (stable == 1) {
                list.add(FontHelper.translate((String)"circuit.stable"));
            } else {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Stable", 0);
                tag.func_74768_a("Item1", 0);
                tag.func_74768_a("Item2", 0);
                tag.func_74768_a("Item3", 0);
                tag.func_74768_a("Item4", 0);
                tag.func_74768_a("Item5", 0);
                tag.func_74768_a("Item6", 0);
                tag.func_74768_a("Energy", 0);
                ItemStack analysed = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
                analysed.func_77982_d(tag);
                if (ItemStack.func_77970_a((ItemStack)analysed, (ItemStack)stack)) {
                    list.add(FontHelper.translate((String)"circuit.analysed"));
                }
            }
        }
    }

    public static void setData(ItemStack stack) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (stack != null && nbtData == null) {
            int energy = 1 + (int)(Math.random() * 200.0);
            int item1 = 1 + (int)(Math.random() * 50.0);
            int item2 = 1 + (int)(Math.random() * 100.0);
            int item3 = 1 + (int)(Math.random() * 1000.0);
            int item4 = 1 + (int)(Math.random() * 2000.0);
            int item5 = 1 + (int)(Math.random() * 10000.0);
            int item6 = 1 + (int)(Math.random() * 20000.0);
            int stable = 1 + (int)(Math.random() * 6.0);
            nbtData = new NBTTagCompound();
            nbtData.func_74768_a("Energy", energy);
            nbtData.func_74768_a("Item1", item1);
            nbtData.func_74768_a("Item2", item2);
            nbtData.func_74768_a("Item3", item3);
            nbtData.func_74768_a("Item4", item4);
            nbtData.func_74768_a("Item5", item5);
            nbtData.func_74768_a("Item6", item6);
            nbtData.func_74768_a("Stable", stable);
            stack.func_77982_d(nbtData);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par, boolean bool) {
        if (stack.func_77978_p() == null && !stack.func_77942_o()) {
            ItemCircuit.setData(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (CircuitType type : CircuitType.values()) {
            type.registerIcon(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int p_77617_1_) {
        CircuitType type = CircuitType.getTypeFromDamage(p_77617_1_);
        return type.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (CircuitType type : CircuitType.values()) {
            list.add(new ItemStack((Item)this, 1, type.getItemDamage()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        CircuitType type = CircuitType.getTypeFromStack(stack);
        return this.func_77658_a() + "." + type.name();
    }

    @Override
    public boolean getStability(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("Stable") == 1;
        }
        ItemCircuit.setData(stack);
        return stack.func_77978_p().func_74762_e("Stable") == 1;
    }

    @Override
    public void onFalse(ItemStack stack) {
        stack.func_77978_p().func_74768_a("Stable", 0);
    }

    public static enum CircuitType {
        C1(0, "1"),
        C2(1, "2"),
        C3(2, "3"),
        C4(3, "4"),
        C5(4, "5"),
        C6(5, "6"),
        C7(6, "7"),
        C8(7, "8"),
        C9(8, "9"),
        C10(9, "10"),
        C11(10, "11"),
        C12(11, "12"),
        C13(12, "13"),
        C14(13, "14");

        private static final Map circuits;
        private final int number;
        private final String name;
        @SideOnly(value=Side.CLIENT)
        private IIcon icon;

        private CircuitType(int number, String name) {
            this.number = number;
            this.name = name;
        }

        public int getItemDamage() {
            return this.number;
        }

        public String getUnlocalizedNamePart() {
            return this.name;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerIcon(IIconRegister register) {
            this.icon = register.func_94245_a("Calculator:circuits/circuit" + this.name);
        }

        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            return this.icon;
        }

        public static CircuitType getTypeFromDamage(int par) {
            CircuitType type = (CircuitType)((Object)circuits.get(par));
            return type == null ? C1 : type;
        }

        public static CircuitType getTypeFromStack(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemCircuit ? CircuitType.getTypeFromDamage(stack.func_77960_j()) : C1;
        }

        static {
            circuits = Maps.newHashMap();
            for (CircuitType var3 : CircuitType.values()) {
                circuits.put(var3.getItemDamage(), var3);
            }
        }
    }
}

