/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.core.common.item.InventoryContainerItem;
import sonar.core.energy.SonarElectricManager;
import sonar.core.helpers.FontHelper;
import sonar.core.integration.SonarLoader;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2", striprefs=true), @Optional.Interface(iface="ic2.api.item.IElectricItem", modid="IC2", striprefs=true)})
public class SonarCalculator
extends InventoryContainerItem
implements IEnergyContainerItem,
ISpecialElectricItem {
    protected int capacity = CalculatorConfig.getInteger("Calculator");
    protected int maxReceive = 200;
    protected int maxExtract = 200;
    protected int maxTransfer = 200;

    public SonarCalculator() {
        this.func_77637_a(Calculator.Calculator);
        this.func_77625_d(1);
    }

    public ItemStack onCalculatorRightClick(ItemStack itemstack, World world, EntityPlayer player, int ID) {
        if (!world.field_72995_K) {
            if (player.field_71075_bZ.field_75098_d) {
                player.openGui((Object)Calculator.instance, ID, world, 0, -1000, 0);
                return itemstack;
            }
            if (this.getEnergyStored(itemstack) > 1) {
                player.openGui((Object)Calculator.instance, ID, world, 0, -1000, 0);
                return itemstack;
            }
            if (this.getEnergyStored(itemstack) < 1) {
                FontHelper.sendMessage((String)FontHelper.translate((String)"energy.notEnough"), (World)world, (EntityPlayer)player);
                return itemstack;
            }
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!CalculatorConfig.isEnabled(stack)) {
            list.add(FontHelper.translate((String)"calc.ban"));
        }
        super.func_77624_a(stack, player, list, par4);
        list.add(FontHelper.translate((String)"energy.stored") + ": " + this.getEnergyStored(stack) + " RF");
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (!container.func_77942_o()) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    @Optional.Method(modid="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return null;
    }

    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return this.capacity / 4;
    }

    @Optional.Method(modid="IC2")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return this.maxTransfer / 4;
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        if (SonarLoader.ic2Loaded()) {
            return new SonarElectricManager();
        }
        return null;
    }
}

