/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.misc;

import cofh.api.block.IDismantleable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.misc.TileEntityGasLantern;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.BlockInteraction;

public class GasLantern
extends SonarMachineBlock
implements IDismantleable {
    private static boolean keepInventory;
    private Random rand = new Random();
    public final boolean isActive;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    public GasLantern(boolean active) {
        super(SonarMaterials.machine);
        this.isActive = active;
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        if (player != null && !world.field_72995_K) {
            player.openGui((Object)Calculator.instance, 34, world, x, y, z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.isActive) {
            float x1 = (float)x + random.nextFloat();
            float y1 = (float)y + 0.5f;
            float z1 = (float)z + random.nextFloat();
            world.func_72869_a("smoke", (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icon = register.func_94245_a("Calculator:reinforcedstone");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.icon;
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldblock, int oldMetadata) {
        TileEntity entity;
        if (!keepInventory && (entity = world.func_147438_o(x, y, z)) != null && entity instanceof TileEntityGasLantern) {
            TileEntityGasLantern tileentity = (TileEntityGasLantern)world.func_147438_o(x, y, z);
            for (int i = 0; i < tileentity.func_70302_i_(); ++i) {
                ItemStack itemstack = tileentity.func_70301_a(i);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = this.rand.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem item = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        item.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)item);
                }
            }
            world.func_147453_f(x, y, z, oldblock);
        }
        world.func_147475_p(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityplayer, ItemStack itemstack) {
        Block north = world.func_147439_a(x + ForgeDirection.NORTH.offsetX, y, z + ForgeDirection.NORTH.offsetZ);
        Block south = world.func_147439_a(x + ForgeDirection.SOUTH.offsetX, y, z + ForgeDirection.SOUTH.offsetZ);
        Block east = world.func_147439_a(x + ForgeDirection.EAST.offsetX, y, z + ForgeDirection.EAST.offsetZ);
        Block west = world.func_147439_a(x + ForgeDirection.WEST.offsetX, y, z + ForgeDirection.WEST.offsetZ);
        Block down = world.func_147439_a(x, y - 1, z);
        if (down != null && down.func_149688_o().func_76220_a() && down != Calculator.gas_lantern_on && down != Calculator.gas_lantern_off && down != Calculator.basic_lantern) {
            world.func_72921_c(x, y, z, 0, 2);
        } else if (north != null && north.func_149688_o().func_76220_a() && north != Calculator.gas_lantern_on && north != Calculator.gas_lantern_off && north != Calculator.basic_lantern && world.isSideSolid(x + ForgeDirection.NORTH.offsetX, y, z + ForgeDirection.NORTH.offsetZ, ForgeDirection.NORTH)) {
            world.func_72921_c(x, y, z, 3, 2);
        } else if (south != null && south.func_149688_o().func_76220_a() && south != Calculator.gas_lantern_on && south != Calculator.gas_lantern_off && south != Calculator.basic_lantern && world.isSideSolid(x + ForgeDirection.SOUTH.offsetX, y, z + ForgeDirection.SOUTH.offsetZ, ForgeDirection.SOUTH)) {
            world.func_72921_c(x, y, z, 2, 2);
        } else if (east != null && east.func_149688_o().func_76220_a() && east != Calculator.gas_lantern_on && east != Calculator.gas_lantern_off && east != Calculator.basic_lantern && world.isSideSolid(x + ForgeDirection.EAST.offsetX, y, z + ForgeDirection.EAST.offsetZ, ForgeDirection.EAST)) {
            world.func_72921_c(x, y, z, 4, 2);
        } else if (west != null && west.func_149688_o().func_76220_a() && west != Calculator.gas_lantern_on && west != Calculator.gas_lantern_off && west != Calculator.basic_lantern && world.isSideSolid(x + ForgeDirection.WEST.offsetX, y, z + ForgeDirection.WEST.offsetZ, ForgeDirection.WEST)) {
            world.func_72921_c(x, y, z, 5, 2);
        } else {
            world.func_72921_c(x, y, z, 0, 2);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_149689_a(world, x, y, z, null, null);
    }

    public static void updateLatternBlockState(boolean bool, World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        keepInventory = true;
        if (bool) {
            world.func_147449_b(x, y, z, Calculator.gas_lantern_on);
        } else {
            world.func_147449_b(x, y, z, Calculator.gas_lantern_off);
        }
        keepInventory = false;
        world.func_72921_c(x, y, z, l, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)).getOpposite();
        this.func_149676_a(0.3f + (float)dir.offsetX * 0.32f, 0.0f + this.getY(metadata), 0.3f + (float)dir.offsetZ * 0.32f, 0.7f + (float)dir.offsetX * 0.32f, 0.7f + this.getY(metadata), 0.7f + (float)dir.offsetZ * 0.32f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        int metadata = world.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)).getOpposite();
        this.func_149676_a(0.3f + (float)dir.offsetX * 0.32f, 0.0f + this.getY(metadata), 0.3f + (float)dir.offsetZ * 0.32f, 0.7f + (float)dir.offsetX * 0.32f, 0.7f + this.getY(metadata), 0.7f + (float)dir.offsetZ * 0.32f);
        super.func_149743_a(world, x, y, z, axis, list, entity);
    }

    public float getY(int meta) {
        if (meta == 0) {
            return 0.0f;
        }
        return 0.1f;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityGasLantern();
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)Calculator.gas_lantern_off);
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnDrops) {
        SonarHelper.dropTile((EntityPlayer)player, (Block)world.func_147439_a(x, y, z), (World)world, (int)x, (int)y, (int)z);
        return null;
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }
}

