/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.blocks.IConnectedBlock;
import sonar.calculator.mod.common.block.ConnectedBlock;
import sonar.calculator.mod.common.tileentity.machines.TileEntityFlawlessGreenhouse;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.core.utils.FailedCoords;

public class FlawlessGreenhouse
extends SonarMachineBlock
implements IConnectedBlock {
    public int[] connections = new int[]{0, 5, 6};
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;

    public FlawlessGreenhouse() {
        super(SonarMaterials.machine);
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFlawlessGreenhouse) {
            TileEntityFlawlessGreenhouse house = (TileEntityFlawlessGreenhouse)world.func_147438_o(x, y, z);
            if (interact.type == BlockInteractionType.SHIFT_RIGHT) {
                if (!house.isBeingBuilt() && house.isIncomplete()) {
                    FailedCoords coords = house.isComplete();
                    if (!coords.getBoolean()) {
                        FontHelper.sendMessage((String)("X: " + coords.getX() + " Y: " + coords.getY() + " Z: " + coords.getZ() + " - " + FontHelper.translate((String)"greenhouse.equal") + " " + coords.getBlock()), (World)world, (EntityPlayer)player);
                    }
                } else if (house.isCompleted()) {
                    FontHelper.sendMessage((String)FontHelper.translate((String)"greenhouse.complete"), (World)world, (EntityPlayer)player);
                }
            } else if (player != null && !world.field_72995_K) {
                player.openGui((Object)Calculator.instance, 14, world, x, y, z);
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityFlawlessGreenhouse();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("Calculator:greenhouse_side");
        this.iconFront = iconRegister.func_94245_a("Calculator:flawless_greenhouse_front");
        this.iconTop = iconRegister.func_94245_a("Calculator:greenhouse_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess w, int x, int y, int z, int s) {
        Block block = w.func_147439_a(x, y + 1, z);
        if (block != null && block instanceof ConnectedBlock) {
            ConnectedBlock connect = (ConnectedBlock)block;
            return connect.getSpecialIcon(w, x, y, z, s);
        }
        return this.func_149691_a(s, w.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == metadata ? this.iconFront : (side == 0 ? this.iconTop : (side == 1 ? this.iconTop : (metadata == 0 && side == 3 ? this.iconFront : this.field_149761_L)));
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }

    @Override
    public int[] getConnections() {
        return this.connections;
    }
}

