/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.utils.helpers.CalculatorTreeBuilder;
import sonar.core.utils.ISpecialTooltip;

public class CalculatorSaplings
extends BlockFlower
implements ISpecialTooltip {
    int type;

    public CalculatorSaplings(int type) {
        super(0);
        this.type = type;
        this.field_149762_H = field_149779_h;
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public boolean func_149854_a(Block block) {
        return this.type == 3 ? block == Calculator.end_diamond_block : super.func_149854_a(block);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.type == 3 ? this.func_149854_a(world.func_147439_a(x, y - 1, z)) : super.func_149718_j(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconReg) {
        if (this.type == 0) {
            this.field_149761_L = iconReg.func_94245_a("Calculator:wood/sapling_amethyst");
        }
        if (this.type == 1) {
            this.field_149761_L = iconReg.func_94245_a("Calculator:wood/sapling_tanzanite");
        }
        if (this.type == 2) {
            this.field_149761_L = iconReg.func_94245_a("Calculator:wood/sapling_pear");
        }
        if (this.type == 3) {
            this.field_149761_L = iconReg.func_94245_a("Calculator:wood/sapling_diamond");
        }
    }

    public boolean isSameSapling(World world, int x, int y, int z, int meta) {
        return world.func_147439_a(x, y, z) == this && (world.func_72805_g(x, y, z) & 3) == meta;
    }

    public int setUnlocalizedName(int type) {
        return type & 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List listSaplings) {
        listSaplings.add(new ItemStack(item, 1, 0));
    }

    public void markOrGrowMarked(World world, int x, int y, int z, Random rand) {
        int l = world.func_72805_g(x, y, z);
        if ((l & 8) == 0) {
            world.func_72921_c(x, y, z, l | 8, 4);
        } else {
            this.growTree(world, x, y, z, rand);
        }
    }

    public void growTree(World world, int x, int y, int z, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (int)x, (int)y, (int)z)) {
            return;
        }
        int l = world.func_72805_g(x, y, z) & 7;
        CalculatorTreeBuilder object = null;
        int i1 = 0;
        int j1 = 0;
        switch (this.type) {
            case 0: {
                object = new CalculatorTreeBuilder(true, Calculator.AmethystSapling, Calculator.amethystLeaf, Calculator.amethystLog);
                break;
            }
            case 1: {
                object = new CalculatorTreeBuilder(true, Calculator.tanzaniteSapling, Calculator.tanzaniteLeaf, Calculator.tanzaniteLog);
                break;
            }
            case 2: {
                object = new CalculatorTreeBuilder(true, Calculator.PearSapling, Calculator.pearLeaf, Calculator.pearLog);
                break;
            }
            case 3: {
                object = new CalculatorTreeBuilder(true, Calculator.diamondSapling, Calculator.diamondLeaf, Calculator.diamondLog);
            }
        }
        world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 4);
        if (!((WorldGenerator)object).func_76484_a(world, rand, x + i1, y, z + j1)) {
            world.func_147465_d(x, y, z, (Block)this, l, 4);
        } else {
            world.func_147449_b(x, y - 1, z, (Block)Blocks.field_150349_c);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            super.func_149674_a(world, x, y, z, rand);
            if (world.func_147439_a(x, y, z) == this && world.func_72957_l(x, y + 1, z) >= 9 && rand.nextInt(7) == 0) {
                this.markOrGrowMarked(world, x, y, z, rand);
            }
        }
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
    }

    public void standardInfo(ItemStack stack, EntityPlayer player, List list) {
        if (this.type == 3) {
            list.add("Must be planted on an End Diamond Block");
        }
    }
}

