/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;

public class CalculatorLeaves
extends BlockLeavesBase
implements IShearable {
    int leafType;
    int[] adjacentTreeBlocks;
    @SideOnly(value=Side.CLIENT)
    private IIcon opaqueLeaves;
    @SideOnly(value=Side.CLIENT)
    private IIcon transparentLeaves;
    @SideOnly(value=Side.CLIENT)
    private IIcon emptyOpaqueLeaves;
    @SideOnly(value=Side.CLIENT)
    private IIcon emptyTransparentLeaves;

    public CalculatorLeaves(int type) {
        super(Material.field_151584_j, true);
        this.leafType = type;
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(Block.field_149779_h);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int blocks = 0;
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            Block block = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (block.isAir((IBlockAccess)world, x, y, z)) continue;
            ++blocks;
        }
        if (blocks != 6) {
            int meta;
            int randInt = 0;
            randInt = this.leafType == 3 ? rand.nextInt(20) : (this.leafType < 2 ? rand.nextInt(8) : rand.nextInt(10));
            if (randInt == 2 && (meta = world.func_72805_g(x, y, z)) != 5) {
                world.func_72921_c(x, y, z, meta + 2, 2);
            }
        }
    }

    public int func_149738_a(World world) {
        return 10;
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72951_B(x, y + 1, z) && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && random.nextInt(15) == 1) {
            double d0 = (float)x + random.nextFloat();
            double d1 = (double)y - 0.05;
            double d2 = (float)z + random.nextFloat();
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
        super.func_149734_b(world, x, y, z, random);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 150;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta > 2) {
            if (!Minecraft.func_71375_t()) {
                return this.opaqueLeaves;
            }
            return this.transparentLeaves;
        }
        if (!Minecraft.func_71375_t()) {
            return this.emptyOpaqueLeaves;
        }
        return this.emptyTransparentLeaves;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        switch (this.leafType) {
            case 0: {
                this.opaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_amethyst_opaque");
                this.transparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_amethyst");
                this.emptyOpaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_amethyst_empty_opaque");
                this.emptyTransparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_amethyst_empty");
                break;
            }
            case 1: {
                this.opaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_tanzanite_opaque");
                this.transparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_tanzanite");
                this.emptyOpaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_tanzanite_empty_opaque");
                this.emptyTransparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_tanzanite_empty");
                break;
            }
            case 2: {
                this.opaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_pear_opaque");
                this.transparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_pear");
                this.emptyOpaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_opaque");
                this.emptyTransparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves");
                break;
            }
            case 3: {
                this.opaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_diamond_opaque");
                this.transparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_diamond");
                this.emptyOpaqueLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_dia_opaque");
                this.emptyTransparentLeaves = iconRegister.func_94245_a("Calculator:wood/leaves_dia");
            }
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int meta = this.func_149692_a(world.func_72805_g(x, y, z));
        switch (this.leafType) {
            case 0: {
                ret.add(new ItemStack(Calculator.amethystLeaf, 1, 0));
                break;
            }
            case 1: {
                ret.add(new ItemStack(Calculator.tanzaniteLeaf, 1, 0));
                break;
            }
            case 2: {
                ret.add(new ItemStack(Calculator.pearLeaf, 1, 0));
                break;
            }
            case 3: {
                ret.add(new ItemStack(Calculator.diamondLeaf, 1, 0));
            }
        }
        return ret;
    }
}

