/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.container.ContainerDeepStorageUnit;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class TileEntityDeepStorageUnit
extends TileEntityFactoryInventory
implements IDeepStorageUnit {
    private boolean _ignoreChanges = true;
    private boolean _passingItem = false;
    private int _storedQuantity;
    private ItemStack _storedItem = null;

    public TileEntityDeepStorageUnit() {
        super(Machine.DeepStorageUnit);
        this.setManageSolids(true);
    }

    @Override
    public void cofh_validate() {
        super.cofh_validate();
        this._ignoreChanges = false;
        this.onFactoryInventoryChanged();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this._ignoreChanges = true;
    }

    @Override
    public boolean shouldDropSlotWhenBroken(int n) {
        return n < 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiDeepStorageUnit((ContainerFactoryInventory)this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerDeepStorageUnit getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerDeepStorageUnit(this, inventoryPlayer);
    }

    public int getQuantity() {
        return this._storedQuantity;
    }

    public int getQuantityAdjusted() {
        int n = this._storedQuantity;
        for (int i = 2; i < this.func_70302_i_(); ++i) {
            if (this._inventory[i] == null || !UtilInventory.stacksEqual(this._storedItem, this._inventory[i])) continue;
            n += this._inventory[i].field_77994_a;
        }
        return n;
    }

    public void setQuantity(int n) {
        this._storedQuantity = n;
    }

    public void clearSlots() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this._inventory[i] = null;
        }
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
    }

    @Override
    public void setIsActive(boolean bl) {
        super.setIsActive(bl);
        this.onFactoryInventoryChanged();
    }

    @Override
    protected void onFactoryInventoryChanged() {
        super.onFactoryInventoryChanged();
        if (this._ignoreChanges | this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isActive() && this._inventory[2] == null & this._storedItem != null & this._storedQuantity == 0) {
            this._storedItem = null;
        }
        this.checkInput(0);
        this.checkInput(1);
        if (this._inventory[2] == null & this._storedItem != null & this._storedQuantity > 0) {
            this._inventory[2] = this._storedItem.func_77946_l();
            this._inventory[2].field_77994_a = Math.min(this._storedQuantity, Math.min(this._storedItem.func_77976_d(), this.func_70297_j_()));
            this._storedQuantity -= this._inventory[2].field_77994_a;
        } else if (this._inventory[2] != null & this._storedQuantity > 0 && this._inventory[2].field_77994_a < this._inventory[2].func_77976_d() && UtilInventory.stacksEqual(this._storedItem, this._inventory[2])) {
            int n = Math.min(this._inventory[2].func_77976_d() - this._inventory[2].field_77994_a, this._storedQuantity);
            this._inventory[2].field_77994_a += n;
            this._storedQuantity -= n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkInput(int n) {
        if (this._inventory[n] == null) return;
        if (this._storedItem == null) {
            this._storedItem = this._inventory[n].func_77946_l();
            this._storedItem.field_77994_a = 1;
            this._storedQuantity = this._inventory[n].field_77994_a;
            this._inventory[n] = null;
        } else {
            if (!UtilInventory.stacksEqual(this._inventory[n], this._storedItem)) {
                this._passingItem = true;
                this._inventory[n] = UtilInventory.dropStack(this, this._inventory[n], this.getDropDirection());
                this._passingItem = false;
                return;
            }
            if (this.getMaxStoredCount() - this._storedItem.func_77976_d() - this._inventory[n].field_77994_a < this._storedQuantity) {
                int n2 = this.getMaxStoredCount() - this._storedItem.func_77976_d() - this._storedQuantity;
                this._inventory[n].field_77994_a -= n2;
                this._storedQuantity += n2;
            } else {
                this._storedQuantity += this._inventory[n].field_77994_a;
                this._inventory[n] = null;
            }
        }
        if (this._inventory[n] == null) return;
        this._passingItem = true;
        this._inventory[n] = UtilInventory.dropStack(this, this._inventory[n], this.getDropDirection());
        this._passingItem = false;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return entityPlayer.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return this.func_70302_i_();
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a < 0) {
            itemStack = null;
        }
        this._inventory[n] = itemStack;
        this.func_70296_d();
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (this._passingItem) {
            return false;
        }
        if (n >= 2) {
            return false;
        }
        ItemStack itemStack2 = this._storedItem;
        if (itemStack2 == null) {
            itemStack2 = this._inventory[2];
        }
        return itemStack2 == null || UtilInventory.stacksEqual(itemStack2, itemStack) && this.getMaxStoredCount() - itemStack2.func_77976_d() > this._storedQuantity;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return this.func_102007_a(n, itemStack, -1);
    }

    @Override
    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return true;
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        int n = 0;
        ItemStack itemStack = this._inventory[2];
        if (itemStack != null) {
            n = itemStack.field_77994_a;
            this._inventory[2] = null;
        }
        super.writeItemNBT(nBTTagCompound);
        this._inventory[2] = itemStack;
        if (this._storedItem != null) {
            nBTTagCompound.func_74782_a("storedStack", (NBTBase)this._storedItem.func_77955_b(new NBTTagCompound()));
            nBTTagCompound.func_74768_a("storedQuantity", this._storedQuantity + n);
            nBTTagCompound.func_74757_a("locked", this.isActive());
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        ItemStack itemStack = this._inventory[2];
        this._inventory[2] = null;
        super.func_145841_b(nBTTagCompound);
        this._inventory[2] = itemStack;
        this.writeItemNBT(nBTTagCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        this._ignoreChanges = true;
        super.func_145839_a(nBTTagCompound);
        this._storedQuantity = nBTTagCompound.func_74762_e("storedQuantity");
        this._storedItem = null;
        if (nBTTagCompound.func_74764_b("storedStack")) {
            this._storedItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nBTTagCompound.func_74781_a("storedStack")));
            if (this._storedItem != null) {
                this._storedItem.field_77994_a = 1;
                this.setIsActive(nBTTagCompound.func_74767_n("locked"));
            }
        }
        if (this._storedItem == null) {
            this._storedQuantity = 0;
        }
        this._ignoreChanges = false;
    }

    public ItemStack getStoredItemRaw() {
        if (this._storedItem != null) {
            return this._storedItem.func_77946_l();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setStoredItemRaw(ItemStack itemStack) {
        if (this.field_145850_b.field_72995_K) {
            this._storedItem = itemStack;
        }
    }

    @Override
    public ItemStack getStoredItemType() {
        int n = this.getQuantityAdjusted();
        if ((this.isActive() || n != 0) & this._storedItem != null) {
            ItemStack itemStack = this._storedItem.func_77946_l();
            itemStack.field_77994_a = n;
            return itemStack;
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int n) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!UtilInventory.stacksEqual(this._inventory[i], this._storedItem)) continue;
            if (n == 0) {
                this._inventory[i] = null;
                continue;
            }
            if (n >= this._inventory[i].field_77994_a) {
                n -= this._inventory[i].field_77994_a;
                continue;
            }
            if (n >= this._inventory[i].field_77994_a) continue;
            this._inventory[i].field_77994_a = n;
            n = 0;
        }
        this._storedQuantity = n;
        this.func_70296_d();
    }

    @Override
    public void setStoredItemType(ItemStack itemStack, int n) {
        if (this._storedItem != null && this.isActive() && !UtilInventory.stacksEqual(itemStack, this._storedItem)) {
            return;
        }
        this.clearSlots();
        this._storedQuantity = n;
        this._storedItem = null;
        if (itemStack == null) {
            return;
        }
        this._storedItem = itemStack.func_77946_l();
        this._storedItem.field_77994_a = 1;
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        return Integer.MAX_VALUE;
    }
}

