/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.setup.recipe;

import cofh.lib.util.helpers.ItemHelper;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.block.ItemBlockRedNetLogic;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.setup.recipe.handler.ShapelessMachineTinker;

public class Vanilla {
    private static boolean _registeredMachines;
    private static boolean _registeredMachineUpgrades;
    private static boolean _registeredMachineTinkers;
    private static boolean _registeredConveyors;
    private static boolean _registeredDecorative;
    private static boolean _registeredSyringes;
    private static boolean _registeredArmor;
    private static boolean _registeredPlastics;
    private static boolean _registeredMiscItems;
    private static boolean _registeredSafariNets;
    private static boolean _registeredSmelting;
    private static boolean _registeredVanillaImprovements;
    private static boolean _registeredRails;
    private static boolean _registeredGuns;
    private static boolean _registeredRedNet;
    private static boolean _registeredRedNetManual;
    private static boolean _registeredOreDict;
    protected static String[] DYES;

    public final void registerRecipes() {
        this.gatherItems();
        this.registerConveyors();
        this.registerMachines();
        this.registerMachineUpgrades();
        this.registerMachineTinkers();
        this.registerPlastics();
        this.registerArmor();
        this.registerDecorative();
        this.registerMiscItems();
        this.registerSmelting();
        this.registerVanillaImprovements();
        this.registerSafariNets();
        this.registerRails();
        if (MFRConfig.enableSyringes.getBoolean(true)) {
            this.registerSyringes();
        }
        if (MFRConfig.enableGuns.getBoolean(true)) {
            this.registerGuns();
        }
        this.registerRedNet();
        this.registerRedNetManual();
    }

    public static void registerOredict() {
        if (_registeredOreDict) {
            return;
        }
        _registeredOreDict = true;
        OreDictionary.registerOre((String)"itemRubber", (Item)MFRThings.rubberBarItem);
        OreDictionary.registerOre((String)"itemRawRubber", (Item)MFRThings.rawRubberItem);
        OreDictionary.registerOre((String)"woodRubber", (Block)MFRThings.rubberWoodBlock);
        OreDictionary.registerOre((String)"leavesRubber", (Block)MFRThings.rubberLeavesBlock);
        OreDictionary.registerOre((String)"treeSapling", (Block)MFRThings.rubberSaplingBlock);
        OreDictionary.registerOre((String)"blockPlastic", (Block)MFRThings.factoryPlasticBlock);
        OreDictionary.registerOre((String)"sheetPlastic", (Item)MFRThings.plasticSheetItem);
        OreDictionary.registerOre((String)"itemPlastic", (Item)MFRThings.plasticSheetItem);
        OreDictionary.registerOre((String)"dustPlastic", (Item)MFRThings.rawPlasticItem);
        OreDictionary.registerOre((String)"itemPlastic", (Item)MFRThings.rawPlasticItem);
        OreDictionary.registerOre((String)"ingotMeat", (Item)MFRThings.meatIngotCookedItem);
        OreDictionary.registerOre((String)"ingotMeatRaw", (Item)MFRThings.meatIngotRawItem);
        OreDictionary.registerOre((String)"nuggetMeat", (Item)MFRThings.meatNuggetCookedItem);
        OreDictionary.registerOre((String)"nuggetMeatRaw", (Item)MFRThings.meatNuggetRawItem);
        OreDictionary.registerOre((String)"blockMeat", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)13));
        OreDictionary.registerOre((String)"blockMeatRaw", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)12));
        OreDictionary.registerOre((String)"itemCharcoalSugar", (Item)MFRThings.sugarCharcoalItem);
        OreDictionary.registerOre((String)"blockCharcoalSugar", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)15));
        OreDictionary.registerOre((String)"cableRedNet", (ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)1, (int)0));
        OreDictionary.registerOre((String)"cableRedNet", (ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)1, (int)1));
        OreDictionary.registerOre((String)"cableRedNetEnergy", (ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)1, (int)2));
        OreDictionary.registerOre((String)"cableRedNetEnergy", (ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)1, (int)3));
        OreDictionary.registerOre((String)"slimeballPink", (ItemStack)ItemHelper.stack((Item)MFRThings.pinkSlimeItem, (int)1, (int)0));
        OreDictionary.registerOre((String)"slimeball", (ItemStack)ItemHelper.stack((Item)MFRThings.pinkSlimeItem, (int)1, (int)0));
        OreDictionary.registerOre((String)"blockSlimePink", (ItemStack)ItemHelper.stack((Block)MFRThings.pinkSlimeBlock));
        OreDictionary.registerOre((String)"blockSlime", (ItemStack)ItemHelper.stack((Block)MFRThings.pinkSlimeBlock));
        OreDictionary.registerOre((String)"fertilizerOrganic", (Item)MFRThings.fertilizerItem);
        OreDictionary.registerOre((String)"fertilizer", (Item)MFRThings.fertilizerItem);
        OreDictionary.registerOre((String)"dyeBrown", (Item)MFRThings.fertilizerItem);
        OreDictionary.registerOre((String)"wireExplosive", (Block)MFRThings.detCordBlock);
        OreDictionary.registerOre((String)"listAllmilk", (Item)MFRThings.milkBottleItem);
        OreDictionary.registerOre((String)"listAllmeatraw", (Item)MFRThings.meatIngotRawItem);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)MFRThings.meatIngotCookedItem);
        String string = "paneGlass";
        String string2 = "blockGlass";
        ItemStack itemStack = ItemHelper.stack2((Block)MFRThings.factoryGlassBlock, (int)1);
        ItemStack itemStack2 = ItemHelper.stack2((Block)MFRThings.factoryGlassPaneBlock, (int)1);
        OreDictionary.registerOre((String)string2, (ItemStack)itemStack.func_77946_l());
        OreDictionary.registerOre((String)string, (ItemStack)itemStack2.func_77946_l());
        for (int i = 0; i < 16; ++i) {
            ItemStack itemStack3 = ItemHelper.stack((Item)MFRThings.ceramicDyeItem, (int)1, (int)i);
            itemStack = ItemHelper.stack((Block)MFRThings.factoryGlassBlock, (int)1, (int)i);
            itemStack2 = ItemHelper.stack((Block)MFRThings.factoryGlassPaneBlock, (int)1, (int)i);
            String string3 = DYES[15 - i];
            String string4 = "dyeCeramic" + string3;
            OreDictionary.registerOre((String)(string2 + string3), (ItemStack)itemStack.func_77946_l());
            OreDictionary.registerOre((String)(string + string3), (ItemStack)itemStack2.func_77946_l());
            OreDictionary.registerOre((String)string4, (ItemStack)itemStack3.func_77946_l());
        }
        OreDictionary.registerOre((String)"stone", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)0));
        OreDictionary.registerOre((String)"stone", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)1));
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)2));
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)3));
        OreDictionary.registerOre((String)"listAllmilk", (Item)Items.field_151117_aB);
        OreDictionary.registerOre((String)"listAllwater", (Item)Items.field_151131_as);
        OreDictionary.registerOre((String)"listAllwater", (ItemStack)ItemHelper.stack((Item)Items.field_151068_bn, (int)1, (int)0));
    }

    public void registerOredictEntries() {
    }

    protected void gatherItems() {
    }

    protected void registerMachines() {
        if (_registeredMachines) {
            return;
        }
        _registeredMachines = true;
        this.registerMachine(Machine.Planter, "GGG", "CPC", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), Items.field_151162_bE, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Fisher, "GGG", "RRR", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Items.field_151112_aM, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Harvester, "GGG", "XSX", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('X'), Items.field_151006_E, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Rancher, "GGG", "SBS", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('P'), MFRThings.plasticPipeBlock, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Fertilizer, "GGG", "LBL", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('B'), Items.field_151069_bo, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Vet, "GGG", "SSS", "EME", Character.valueOf('G'), "sheetPlastic", Character.valueOf('E'), Items.field_151070_bp, Character.valueOf('S'), MFRThings.syringeEmptyItem, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.ItemCollector, 8, new Object[]{"GGG", " C ", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('M'), MFRThings.machineBaseItem});
        this.registerMachine(Machine.BlockBreaker, "GGG", "PHS", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Items.field_151005_D, Character.valueOf('H'), MFRThings.factoryHammerItem, Character.valueOf('S'), Items.field_151011_C, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.WeatherCollector, "GGG", "BBB", "UMU", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('U'), Items.field_151133_ar, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.SludgeBoiler, "GGG", "FFF", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Sewer, 4, new Object[]{"GGG", "BUB", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151118_aC, Character.valueOf('U'), Items.field_151133_ar, Character.valueOf('M'), MFRThings.machineBaseItem});
        this.registerMachine(Machine.Composter, "GGG", "PFP", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Breeder, "GGG", "CAC", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), "dyePurple", Character.valueOf('C'), Items.field_151150_bK, Character.valueOf('A'), Items.field_151153_ao, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Grinder, "GGG", "BSP", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('S'), Items.field_151010_B, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.AutoEnchanter, "GGG", "BBB", "DMD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Chronotyper, "GGG", "EEE", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('E'), Items.field_151166_bC, Character.valueOf('P'), "dyePurple", Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Ejector, 8, new Object[]{"GGG", " D ", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150409_cd, Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), MFRThings.machineBaseItem});
        this.registerMachine(Machine.ItemRouter, 8, new Object[]{"GGG", "RCR", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('M'), MFRThings.machineBaseItem});
        this.registerMachine(Machine.LiquidRouter, 8, new Object[]{"GGG", "RBR", "PMP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('P'), MFRThings.plasticPipeBlock, Character.valueOf('M'), MFRThings.machineBaseItem});
        int n = MFRConfig.craftSingleDSU.getBoolean(false) ? 1 : 4;
        this.registerMachine(Machine.DeepStorageUnit, n, new Object[]{"GGG", "PPP", "EME", Character.valueOf('G'), "sheetPlastic", Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('M'), MFRThings.machineBaseItem});
        if (MFRConfig.enableCheapDSU.getBoolean(false)) {
            this.registerMachine(Machine.DeepStorageUnit, "GGG", "CCC", "CMC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('M'), MFRThings.machineBaseItem);
        }
        this.registerMachine(Machine.LiquiCrafter, "GGG", "BWB", "FMF", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('W'), Blocks.field_150462_ai, Character.valueOf('F'), Items.field_151160_bD, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.LavaFabricator, "GGG", "OBO", "CMC", Character.valueOf('G'), "sheetPlastic", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('B'), Items.field_151072_bj, Character.valueOf('C'), Items.field_151064_bs, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.SteamBoiler, "GGG", "OTO", "NBN", Character.valueOf('G'), "sheetPlastic", Character.valueOf('T'), Items.field_151066_bu, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('N'), Blocks.field_150387_bl, Character.valueOf('B'), Machine.SludgeBoiler);
        this.registerMachine(Machine.AutoJukebox, "GGG", " J ", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('J'), Blocks.field_150421_aI, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Unifier, "GGG", "CBC", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.AutoSpawner, "GGG", "NCS", "EME", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), Items.field_151064_bs, Character.valueOf('N'), Items.field_151075_bm, Character.valueOf('S'), Items.field_151102_aT, Character.valueOf('E'), "gemEmerald", Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.BioReactor, "GGG", "UEU", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('U'), Items.field_151102_aT, Character.valueOf('E'), Items.field_151071_bq, Character.valueOf('S'), "slimeball", Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.BioFuelGenerator, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('R'), Items.field_151072_bj, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.AutoDisenchanter, "GGG", "RDR", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('R'), Blocks.field_150385_bj, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.Slaughterhouse, "GGG", "SSS", "XMX", Character.valueOf('G'), "sheetPlastic", Character.valueOf('S'), Items.field_151010_B, Character.valueOf('X'), Items.field_151006_E, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.MeatPacker, "GGG", "BFB", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150336_V, Character.valueOf('F'), Items.field_151033_d, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.EnchantmentRouter, "GGG", "RBR", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.LaserDrill, "GGG", "LLL", "DMD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('L'), Blocks.field_150426_aN, Character.valueOf('D'), "gemDiamond", Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.LaserDrillPrecharger, "GGG", "LSL", "DMD", Character.valueOf('G'), "sheetPlastic", Character.valueOf('L'), Blocks.field_150426_aN, Character.valueOf('D'), "gemDiamond", Character.valueOf('S'), ItemHelper.stack((Item)MFRThings.pinkSlimeItem, (int)1, (int)1), Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.AutoAnvil, "GGG", "AAA", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('A'), Blocks.field_150467_bQ, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.BlockSmasher, "GGG", "HHH", "BMB", Character.valueOf('G'), "sheetPlastic", Character.valueOf('H'), MFRThings.factoryHammerItem, Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.RedNote, "GGG", "CNC", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), "cableRedNet", Character.valueOf('N'), Blocks.field_150323_B, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.AutoBrewer, "GGG", "CBC", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('C'), MFRThings.plasticPipeBlock, Character.valueOf('B'), Items.field_151067_bt, Character.valueOf('R'), Items.field_151132_bS, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.FruitPicker, "GGG", "SXS", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('S'), Items.field_151097_aZ, Character.valueOf('X'), Items.field_151006_E, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.BlockPlacer, "GGG", "DDD", " M ", Character.valueOf('G'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150367_z, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.MobCounter, "GGG", "RCR", "SMS", Character.valueOf('G'), "sheetPlastic", Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('S'), MFRThings.spyglassItem, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.SteamTurbine, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('R'), Items.field_151130_bT, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.ChunkLoader, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), Items.field_151156_bN, Character.valueOf('P'), Machine.DeepStorageUnit, Character.valueOf('R'), "blockRedstone", Character.valueOf('M'), MFRThings.machineBaseItem);
        if (MFRConfig.enableCheapCL.getBoolean(false)) {
            this.registerMachine(Machine.ChunkLoader, "GGG", "PFP", "RMR", Character.valueOf('G'), "sheetPlastic", Character.valueOf('F'), "blockGold", Character.valueOf('P'), Items.field_151061_bv, Character.valueOf('R'), "blockRedstone", Character.valueOf('M'), MFRThings.machineBaseItem);
        }
        this.registerMachine(Machine.Fountain, "GBG", "GBG", "UMU", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('U'), Items.field_151133_ar, Character.valueOf('M'), MFRThings.machineBaseItem);
        this.registerMachine(Machine.MobRouter, "GGG", "BRB", "PCP", Character.valueOf('G'), "sheetPlastic", Character.valueOf('B'), Blocks.field_150411_aY, Character.valueOf('R'), Machine.ItemRouter, Character.valueOf('P'), "dyeOrange", Character.valueOf('C'), Machine.Chronotyper);
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.plasticTank, (int)1), (Object[])new Object[]{"PPP", "P P", "PMP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('M'), MFRThings.machineBaseItem}));
    }

    protected void registerMachine(Machine machine, Object ... objectArray) {
        this.registerMachine(machine, 1, objectArray);
    }

    protected void registerMachine(Machine machine, int n, Object ... objectArray) {
        if (machine.getIsRecipeEnabled()) {
            ItemStack itemStack = machine.getItemStack();
            itemStack.field_77994_a = n;
            int n2 = objectArray.length;
            while (n2-- > 0) {
                if (!(objectArray[n2] instanceof Machine)) continue;
                objectArray[n2] = ((Machine)objectArray[n2]).getItemStack();
            }
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)itemStack, (Object[])objectArray));
        }
    }

    protected void registerMachineUpgrades() {
        int n;
        if (_registeredMachineUpgrades) {
            return;
        }
        _registeredMachineUpgrades = true;
        String[] stringArray = new String[]{"gemLapis", "ingotTin", "ingotIron", "ingotCopper", "ingotBronze", "ingotSilver", "ingotGold", "gemQuartz", "gemDiamond", "ingotPlatinum", "gemEmerald", "cobblestone"};
        Object[] objectArray = new Object[]{"nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold", "nuggetGold"};
        String string = "dustPlastic";
        if (MFRConfig.enableExpensiveUpgrades.getBoolean(false)) {
            string = "gemDiamond";
            objectArray[0] = ItemHelper.stack((Item)MFRThings.upgradeItem, (int)1, (int)Arrays.asList(stringArray).indexOf("cobblestone"));
            for (n = 1; n < 11; ++n) {
                objectArray[n] = ItemHelper.stack((Item)MFRThings.upgradeItem, (int)1, (int)(n - 1));
            }
        }
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.upgradeItem, (int)1, (int)n), (Object[])new Object[]{"III", "PCP", "RGR", Character.valueOf('I'), stringArray[n], Character.valueOf('P'), "dustPlastic", Character.valueOf('C'), string, Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), objectArray[n]}));
        }
        for (n = 0; n < 16; ++n) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.laserFocusItem, (int)1, (int)n), (Object[])new Object[]{"ENE", "NGN", "ENE", Character.valueOf('E'), "gemEmerald", Character.valueOf('N'), "nuggetGold", Character.valueOf('G'), ItemHelper.stack((Block)MFRThings.factoryGlassPaneBlock, (int)1, (int)n)}));
        }
    }

    protected void registerMachineTinkers() {
        if (_registeredMachineTinkers) {
            return;
        }
        _registeredMachineTinkers = true;
        ItemHelper.addRecipe((IRecipe)new ShapelessMachineTinker(Machine.ItemCollector, "Emits comparator signal", new ItemStack[]{ItemHelper.stack((Item)Items.field_151074_bl)}){

            @Override
            protected boolean isMachineTinkerable(ItemStack itemStack) {
                return !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("hasTinkerStuff");
            }

            @Override
            protected ItemStack getTinkeredMachine(ItemStack itemStack) {
                NBTTagCompound nBTTagCompound = (itemStack = itemStack.func_77946_l()).func_77978_p();
                if (nBTTagCompound == null) {
                    nBTTagCompound = new NBTTagCompound();
                    itemStack.func_77982_d(nBTTagCompound);
                }
                nBTTagCompound.func_74757_a("hasTinkerStuff", true);
                return itemStack;
            }
        });
    }

    protected void registerConveyors() {
        if (_registeredConveyors) {
            return;
        }
        _registeredConveyors = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.conveyorBlock, (int)16, (int)16), (Object[])new Object[]{"UUU", "RIR", Character.valueOf('U'), "itemRubber", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron"}));
        for (int i = 0; i < 16; ++i) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.conveyorBlock, (int)1, (int)i), (Object[])new Object[]{ItemHelper.stack2((Block)MFRThings.conveyorBlock, (int)1), "dyeCeramic" + DYES[15 - i]}));
        }
    }

    protected void registerDecorative() {
        if (_registeredDecorative) {
            return;
        }
        _registeredDecorative = true;
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryRoadBlock, (int)16), (String)"sheetPlastic", (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryRoadBlock, (int)4, (int)1), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryRoadBlock, (int)1, (int)0), (ItemStack)ItemHelper.stack((Block)Blocks.field_150379_bu));
        ItemHelper.addTwoWayConversionRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryRoadBlock, (int)1, (int)4), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryRoadBlock, (int)1, (int)1));
        String string = "paneGlass";
        String string2 = "blockGlass";
        for (int i = 0; i < 16; ++i) {
            ItemStack itemStack = ItemHelper.stack((Item)MFRThings.ceramicDyeItem, (int)1, (int)i);
            ItemStack itemStack2 = ItemHelper.stack((Block)MFRThings.factoryGlassBlock, (int)1, (int)i);
            ItemStack itemStack3 = ItemHelper.stack((Block)MFRThings.factoryGlassPaneBlock, (int)1, (int)i);
            String string3 = DYES[15 - i];
            String string4 = "dyeCeramic" + string3;
            String string5 = "dye" + string3;
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack, (int)4), (Object[])new Object[]{ItemHelper.stack((Item)Items.field_151119_aD), string5}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack, (int)8), (Object[])new Object[]{ItemHelper.stack((Item)Items.field_151119_aD), ItemHelper.stack((Item)Items.field_151119_aD), string5, string5}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack2, (int)1), (Object[])new Object[]{string4, string2}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack2, (int)3), (Object[])new Object[]{string4, string2, string2, string2}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack2, (int)6), (Object[])new Object[]{string4, string4, string2, string2, string2, string2, string2, string2}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack3, (int)1), (Object[])new Object[]{string4, string}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack3, (int)3), (Object[])new Object[]{string4, string, string, string}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack3, (int)8), (Object[])new Object[]{string4, string, string, string, string, string, string, string, string}));
            ItemHelper.addFenceRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack3, (int)16), (ItemStack)ItemHelper.cloneStack((ItemStack)itemStack2, (int)1));
        }
        ItemHelper.addTwoWayConversionRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)1), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)0));
        ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)3, (int)2), (Object[])new Object[]{"XXX", Character.valueOf('X'), ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)1)});
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)4, (int)3), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)0));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)4, (int)4), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)5));
        ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)8, (int)5), (Object[])new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)1)});
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)4, (int)6), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1, (int)3));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)0), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150432_aD), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)1), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150426_aN), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)2), (String)"blockLapis", (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)3), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150343_Z), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)4), (ItemStack)ItemHelper.stack((Block)Blocks.field_150333_U, (int)1, (int)0), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)5), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150433_aE), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)6), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150432_aD), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)7), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150426_aN), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)8), (String)"blockLapis", (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)9), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150343_Z), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)10), (ItemStack)ItemHelper.stack((Block)Blocks.field_150333_U, (int)1, (int)0), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        if (MFRConfig.enableSmoothSlabRecipe.getBoolean(true)) {
            ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)10), (Object[])new Object[]{"VV", "VV", Character.valueOf('V'), ItemHelper.stack((Block)Blocks.field_150334_T, (int)1, (int)8)});
        }
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)11), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150433_aE), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addRotatedGearRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (int)14), (ItemStack)ItemHelper.stack((Block)Blocks.field_150336_V, (int)1, (int)0), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)0), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)6));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)1), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)7));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)2), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)8));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)3), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)9));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)4), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)10));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (int)5), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)11));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150336_V, (int)2, (int)0), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)14));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)0), (String)"dyeBlack", (String)"stone");
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)1), (ItemStack)ItemHelper.stack2((Item)Items.field_151102_aT), (String)"stone");
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)2), (String)"dyeBlack", (String)"cobblestone");
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)3), (ItemStack)ItemHelper.stack2((Item)Items.field_151102_aT), (String)"cobblestone");
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)4), (String)"dyeBlack", (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)5), (ItemStack)ItemHelper.stack2((Item)Items.field_151102_aT), (ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (int)4), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)0));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (int)5), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)1));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)6), (String)"dyeBlack", (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)7), (ItemStack)ItemHelper.stack2((Item)Items.field_151102_aT), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150336_V));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (int)6), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)4));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (int)7), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)5));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)8), (String)"dyeBlack", (ItemStack)ItemHelper.stack2((Block)Blocks.field_150351_n));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (int)9), (ItemStack)ItemHelper.stack2((Item)Items.field_151102_aT), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150351_n));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (int)10), (String)"dyeBlack", (ItemStack)ItemHelper.stack((Block)Blocks.field_150333_U, (int)1, (int)0));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (int)11), (ItemStack)ItemHelper.stack2((Item)Items.field_151102_aT), (ItemStack)ItemHelper.stack((Block)Blocks.field_150333_U, (int)1, (int)0));
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)0), (Object[])new Object[]{ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)10)});
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)1), (Object[])new Object[]{ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)11)});
        ItemHelper.addStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.meatIngotRawItem), (String)"nuggetMeatRaw");
        ItemHelper.addStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.meatIngotCookedItem), (String)"nuggetMeat");
        ItemHelper.addStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)12), (String)"ingotMeatRaw");
        ItemHelper.addStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)13), (String)"ingotMeat");
        ItemHelper.addReverseStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.meatIngotRawItem), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)12));
        ItemHelper.addReverseStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.meatIngotCookedItem), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)13));
        ItemHelper.addReverseStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.meatNuggetRawItem), (String)"ingotMeatRaw");
        ItemHelper.addReverseStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.meatNuggetCookedItem), (String)"ingotMeat");
        ItemHelper.addTwoWayStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.pinkSlimeBlock), (ItemStack)ItemHelper.stack((Item)MFRThings.pinkSlimeItem));
    }

    protected void registerSyringes() {
        if (_registeredSyringes) {
            return;
        }
        _registeredSyringes = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.xpExtractorItem), (Object[])new Object[]{"PLP", "PLP", "RPR", Character.valueOf('R'), "itemRubber", Character.valueOf('L'), "blockGlass", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.syringeEmptyItem, (int)1), (Object[])new Object[]{"PRP", "P P", " I ", Character.valueOf('P'), "sheetPlastic", Character.valueOf('R'), "itemRubber", Character.valueOf('I'), "ingotIron"}));
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.syringeHealthItem), (Object[])new Object[]{MFRThings.syringeEmptyItem, Items.field_151034_e});
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.syringeGrowthItem), (Object[])new Object[]{MFRThings.syringeEmptyItem, Items.field_151150_bK});
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.syringeZombieItem, (int)1), (ItemStack)ItemHelper.stack((Item)MFRThings.syringeEmptyItem), (ItemStack)ItemHelper.stack2((Item)Items.field_151078_bh));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.syringeSlimeItem, (int)1), (Object[])new Object[]{" S ", "BLB", Character.valueOf('B'), "slimeball", Character.valueOf('L'), "gemLapis", Character.valueOf('S'), MFRThings.syringeEmptyItem}));
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.syringeCureItem), (Object[])new Object[]{MFRThings.syringeEmptyItem, Items.field_151153_ao});
    }

    protected void registerPlastics() {
        if (_registeredPlastics) {
            return;
        }
        _registeredPlastics = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.machineBaseItem, (int)3), (Object[])new Object[]{"PPP", "SSS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stone"}));
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticSheetItem, (int)4), (String)"dustPlastic");
        ItemHelper.addSmallStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryPlasticBlock, (int)1), (String)"sheetPlastic");
        ItemHelper.addSmallReverseStorageRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticSheetItem, (int)4), (String)"blockPlastic");
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.factoryHammerItem, (int)1), (Object[])new Object[]{"PPP", " S ", " S ", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stickWood"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.strawItem), (Object[])new Object[]{"PP", "P ", "P ", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rulerItem), (Object[])new Object[]{"P", "A", "P", Character.valueOf('P'), "sheetPlastic", Character.valueOf('A'), Items.field_151121_aF}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticCupItem, (int)16), (Object[])new Object[]{" P ", "P P", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticBagItem, (int)3), (Object[])new Object[]{"SPS", "P P", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), Items.field_151007_F}));
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticBagItem), (Object[])new Object[]{MFRThings.plasticBagItem});
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticBootsItem, (int)1), (Object[])new Object[]{"P P", "P P", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.plasticPipeBlock, (int)8), (Object[])new Object[]{"PPP", "   ", "PPP", Character.valueOf('P'), "sheetPlastic"}));
    }

    protected void registerArmor() {
        if (_registeredArmor) {
            return;
        }
        _registeredArmor = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticGlasses, (int)1), (Object[])new Object[]{"GPG", "P P", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "paneGlassBlack"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticHelmetItem, (int)1), (Object[])new Object[]{"PPP", "P P", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticChestplateItem, (int)1), (Object[])new Object[]{"P P", "PPP", "PPP", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.plasticLeggingsItem, (int)1), (Object[])new Object[]{"PPP", "P P", "P P", Character.valueOf('P'), "sheetPlastic"}));
    }

    protected void registerMiscItems() {
        if (_registeredMiscItems) {
            return;
        }
        _registeredMiscItems = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.fertilizerItem, (int)16), (Object[])new Object[]{"WBW", "STS", "WBW", Character.valueOf('W'), Items.field_151015_O, Character.valueOf('B'), ItemHelper.stack((Item)Items.field_151100_aR, (int)1, (int)15), Character.valueOf('S'), Items.field_151007_F, Character.valueOf('T'), "stickWood"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.spyglassItem), (Object[])new Object[]{"GLG", "PLP", " S ", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "blockGlass", Character.valueOf('P'), "sheetPlastic", Character.valueOf('S'), "stickWood"}));
        if (MFRConfig.enablePortaSpawner.getBoolean(true)) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.portaSpawnerItem), (Object[])new Object[]{"GLG", "DND", "GLG", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "blockGlass", Character.valueOf('D'), "gemDiamond", Character.valueOf('N'), Items.field_151156_bN}));
        }
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.detCordBlock, (int)12), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150335_W), (String)"itemRubber");
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.fishingRodItem, (int)1), (Object[])new Object[]{"DD ", "DFD", "TDD", Character.valueOf('D'), "wireExplosive", Character.valueOf('F'), Items.field_151112_aM, Character.valueOf('T'), Blocks.field_150429_aA}));
    }

    protected void registerSafariNets() {
        if (_registeredSafariNets) {
            return;
        }
        _registeredSafariNets = true;
        if (MFRConfig.enableExpensiveSafariNet.getBoolean(false)) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.safariNetItem, (int)1), (Object[])new Object[]{"SLS", "PBP", "SPS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('B'), MFRThings.portaSpawnerItem}));
        } else {
            ItemHelper.addGearRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.safariNetItem, (int)1), (ItemStack)ItemHelper.stack2((Item)Items.field_151079_bi), (ItemStack)ItemHelper.stack2((Item)Items.field_151073_bk));
        }
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.safariNetSingleItem, (int)3), (Object[])new Object[]{"SPS", " B ", "S S", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('P'), "sheetPlastic", Character.valueOf('B'), "slimeball"}));
        ItemHelper.addGearRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.safariNetJailerItem, (int)1), (ItemStack)ItemHelper.stack2((Block)Blocks.field_150411_aY), (ItemStack)ItemHelper.stack((Item)MFRThings.safariNetSingleItem));
        if (MFRConfig.enableFancySafariNet.getBoolean(true)) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.safariNetFancyJailerItem, (int)1), (Object[])new Object[]{"GGG", "GBG", "GGG", Character.valueOf('G'), Items.field_151074_bl, Character.valueOf('B'), MFRThings.safariNetJailerItem}));
        }
        if (MFRConfig.enableNetLauncher.getBoolean(true)) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.safariNetLauncherItem, (int)1), (Object[])new Object[]{"PGP", "LGL", "IRI", Character.valueOf('P'), "sheetPlastic", Character.valueOf('L'), Items.field_151114_aO, Character.valueOf('G'), Items.field_151016_H, Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}));
        }
    }

    protected void registerSmelting() {
        if (_registeredSmelting) {
            return;
        }
        _registeredSmelting = true;
        ItemHelper.addWeakSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rubberBarItem), (ItemStack)ItemHelper.stack((Item)MFRThings.rawRubberItem));
        for (ItemStack itemStack : OreDictionary.getOres((String)"itemRubber")) {
            ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rawPlasticItem), (ItemStack)itemStack, (float)0.3f);
        }
        for (ItemStack itemStack : OreDictionary.getOres((String)"blockPlastic")) {
            ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rawPlasticItem, (int)4), (ItemStack)itemStack);
        }
        for (ItemStack itemStack : OreDictionary.getOres((String)"sheetPlastic")) {
            ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rawPlasticItem), (ItemStack)itemStack);
        }
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rawPlasticItem, (int)2), (Item)MFRThings.plasticBagItem);
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rawPlasticItem, (int)4), (Item)MFRThings.strawItem);
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.rawPlasticItem, (int)2), (Item)MFRThings.rulerItem);
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.meatIngotCookedItem), (Item)MFRThings.meatIngotRawItem, (float)0.5f);
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.meatNuggetCookedItem), (Item)MFRThings.meatNuggetRawItem, (float)0.3f);
        ItemHelper.addWeakSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.sugarCharcoalItem), (Item)Items.field_151102_aT);
        ItemHelper.addWeakSmelting((ItemStack)ItemHelper.stack((Item)Items.field_151044_h, (int)3, (int)1), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)13));
        ItemHelper.addWeakSmelting((ItemStack)ItemHelper.stack((Item)Items.field_151044_h, (int)1, (int)1), (ItemStack)ItemHelper.stack((Block)MFRThings.rubberWoodBlock));
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Item)MFRThings.pinkSlimeItem, (int)1, (int)1), (Block)MFRThings.pinkSlimeBlock, (float)0.5f);
        ItemHelper.addWeakSmelting((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)0), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)2));
        ItemHelper.addWeakSmelting((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)1), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)3));
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)10), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)0));
        ItemHelper.addSmelting((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)11), (ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (int)1));
    }

    protected void registerVanillaImprovements() {
        if (_registeredVanillaImprovements) {
            return;
        }
        _registeredVanillaImprovements = true;
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150344_f, (int)3, (int)3), (Object[])new Object[]{ItemHelper.stack((Block)MFRThings.rubberWoodBlock)});
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150331_J, (int)1, (int)0), (Object[])new Object[]{ItemHelper.stack((Block)Blocks.field_150320_F, (int)1, (int)0), "listAllmilk"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150320_F), (Object[])new Object[]{"R", "P", Character.valueOf('R'), "itemRawRubber", Character.valueOf('P'), Blocks.field_150331_J}));
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.blankRecordItem, (int)1), (ItemStack)ItemHelper.stack2((Item)Items.field_151121_aF), (String)"dustPlastic");
        if (MFRConfig.enableMossyCobbleRecipe.getBoolean(true)) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150341_Y), (Object[])new Object[]{Blocks.field_150347_e, Blocks.field_150347_e, Blocks.field_150347_e, Blocks.field_150347_e, Blocks.field_150347_e, Blocks.field_150347_e, Blocks.field_150347_e, "listAllwater", Items.field_151015_O}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)1), (Object[])new Object[]{ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), ItemHelper.stack((Block)Blocks.field_150417_aV, (int)1, (int)0), "listAllwater", Items.field_151015_O}));
        }
        if (MFRConfig.enableSmoothSlabRecipe.getBoolean(true)) {
            ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150334_T, (int)3, (int)0), (Object[])new Object[]{"VVV", Character.valueOf('V'), ItemHelper.stack((Block)Blocks.field_150334_T, (int)1, (int)8)});
            ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150334_T, (int)1, (int)8), (Object[])new Object[]{"VV", Character.valueOf('V'), ItemHelper.stack((Block)Blocks.field_150333_U, (int)1, (int)0)});
            ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150334_T, (int)1, (int)9), (Object[])new Object[]{"VV", Character.valueOf('V'), ItemHelper.stack((Block)Blocks.field_150333_U, (int)1, (int)1)});
        }
        ItemHelper.addRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.vineScaffoldBlock, (int)8), (Object[])new Object[]{"VV", "VV", "VV", Character.valueOf('V'), Blocks.field_150395_bd});
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.milkBottleItem), (Object[])new Object[]{Items.field_151117_aB, Items.field_151069_bo});
        ItemHelper.addSurroundRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150346_d, (int)1, (int)2), (ItemStack)ItemHelper.stack((Block)Blocks.field_150346_d), (ItemStack)ItemHelper.stack((Block)Blocks.field_150362_t, (int)1, (int)1));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.fertileSoil), (Object[])new Object[]{ItemHelper.stack((Block)Blocks.field_150346_d, (int)1, (int)2), ItemHelper.stack((Item)MFRThings.fertilizerItem), "listAllmilk"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.chocolateMilkBucketItem), (Object[])new Object[]{"listAllmilk", Items.field_151133_ar, ItemHelper.stack((Item)Items.field_151100_aR, (int)1, (int)3)}));
        ItemHelper.addStorageRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (int)15), (ItemStack)ItemHelper.stack((Item)MFRThings.sugarCharcoalItem));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150478_aa, (int)3), (Object[])new Object[]{"R", "S", Character.valueOf('R'), "itemRawRubber", Character.valueOf('S'), "stickWood"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)Blocks.field_150478_aa, (int)2), (Object[])new Object[]{"C", "S", Character.valueOf('C'), "itemCharcoalSugar", Character.valueOf('S'), "stickWood"}));
        for (ItemStack itemStack : OreDictionary.getOres((String)"torchStone")) {
            if (itemStack == null) continue;
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack, (int)3), (Object[])new Object[]{"R", "S", Character.valueOf('R'), "itemRawRubber", Character.valueOf('S'), "stoneRod"}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)itemStack, (int)2), (Object[])new Object[]{"C", "S", Character.valueOf('C'), "itemCharcoalSugar", Character.valueOf('S'), "stoneRod"}));
            break;
        }
    }

    protected void registerRails() {
        if (_registeredRails) {
            return;
        }
        _registeredRails = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.railPickupCargoBlock, (int)2), (Object[])new Object[]{" C ", "SDS", "SSS", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150319_E}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.railDropoffCargoBlock, (int)2), (Object[])new Object[]{"SSS", "SDS", " C ", Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150319_E}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.railPickupPassengerBlock, (int)3), (Object[])new Object[]{" L ", "SDS", "SSS", Character.valueOf('L'), Blocks.field_150368_y, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150319_E}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.railDropoffPassengerBlock, (int)3), (Object[])new Object[]{"SSS", "SDS", " L ", Character.valueOf('L'), Blocks.field_150368_y, Character.valueOf('S'), "sheetPlastic", Character.valueOf('D'), Blocks.field_150319_E}));
    }

    protected void registerGuns() {
        if (_registeredGuns) {
            return;
        }
        _registeredGuns = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunItem), (Object[])new Object[]{"PGP", "PLP", "SIS", Character.valueOf('P'), "sheetPlastic", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), Items.field_151064_bs, Character.valueOf('L'), MFRThings.safariNetLauncherItem, Character.valueOf('G'), MFRThings.spyglassItem}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.potatoLauncherItem), (Object[])new Object[]{" L ", "PLP", "PTP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('L'), ItemHelper.stack((Block)MFRThings.plasticPipeBlock), Character.valueOf('T'), ItemHelper.stack((Block)MFRThings.plasticTank)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rocketLauncherItem), (Object[])new Object[]{"PCP", "PRP", "ILI", Character.valueOf('P'), "sheetPlastic", Character.valueOf('I'), Items.field_151143_au, Character.valueOf('L'), MFRThings.needlegunItem, Character.valueOf('R'), ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)1), Character.valueOf('C'), ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)2)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoEmptyItem, (int)4), (Object[])new Object[]{"P P", "PIP", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('I'), "ingotIron"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rocketItem, (int)2, (int)0), (Object[])new Object[]{"PCP", "PTP", "IMI", Character.valueOf('C'), ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)0), Character.valueOf('M'), MFRThings.needlegunAmmoEmptyItem, Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150335_W, Character.valueOf('I'), Items.field_151152_bP}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rocketItem, (int)2, (int)1), (Object[])new Object[]{"PPP", "PTP", "IMI", Character.valueOf('M'), MFRThings.needlegunAmmoEmptyItem, Character.valueOf('P'), "sheetPlastic", Character.valueOf('T'), Blocks.field_150335_W, Character.valueOf('I'), Items.field_151152_bP}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rocketItem, (int)2, (int)0), (Object[])new Object[]{ItemHelper.stack((Item)MFRThings.rocketItem, (int)1, (int)1), ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)0), ItemHelper.stack((Item)MFRThings.rocketItem, (int)1, (int)1)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoStandardItem), (Object[])new Object[]{"AAA", "AAA", "GMG", Character.valueOf('A'), Items.field_151032_g, Character.valueOf('M'), MFRThings.needlegunAmmoEmptyItem, Character.valueOf('G'), Items.field_151016_H}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoPierceItem), (Object[])new Object[]{"AAA", "AAA", "GMG", Character.valueOf('A'), Items.field_151145_ak, Character.valueOf('M'), MFRThings.needlegunAmmoEmptyItem, Character.valueOf('G'), Items.field_151016_H}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoAnvilItem), (Object[])new Object[]{"SAS", "STS", "SMS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('A'), ItemHelper.stack((Block)Blocks.field_150467_bQ, (int)1, (int)0), Character.valueOf('T'), Blocks.field_150335_W, Character.valueOf('M'), MFRThings.needlegunAmmoEmptyItem}));
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoFireItem), (Object[])new Object[]{MFRThings.needlegunAmmoPierceItem, Items.field_151033_d});
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoLavaItem), (Object[])new Object[]{MFRThings.needlegunAmmoStandardItem, MFRThings.plasticCupItem, Items.field_151129_at});
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoSludgeItem), (Object[])new Object[]{MFRThings.needlegunAmmoStandardItem, MFRThings.plasticCupItem, MFRThings.sludgeBucketItem});
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.needlegunAmmoSewageItem), (Object[])new Object[]{MFRThings.needlegunAmmoStandardItem, MFRThings.plasticCupItem, MFRThings.sewageBucketItem});
    }

    protected void registerRedNet() {
        if (_registeredRedNet) {
            return;
        }
        _registeredRedNet = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)8), (Object[])new Object[]{"PPP", "RRR", "PPP", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "sheetPlastic"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)5), (Object[])new Object[]{"dustRedstone", "dustRedstone", ItemHelper.stack((Block)MFRThings.plasticPipeBlock), ItemHelper.stack((Block)MFRThings.plasticPipeBlock), ItemHelper.stack((Block)MFRThings.plasticPipeBlock), ItemHelper.stack((Block)MFRThings.plasticPipeBlock), ItemHelper.stack((Block)MFRThings.plasticPipeBlock)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)1, (int)2), (Object[])new Object[]{"nuggetGold", "nuggetGold", "nuggetGold", "dustRedstone", "dustRedstone", ItemHelper.stack((Block)MFRThings.rednetCableBlock)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetCableBlock, (int)6, (int)2), (Object[])new Object[]{"ingotGold", "ingotGold", "blockRedstone", ItemHelper.stack((Block)MFRThings.rednetCableBlock), ItemHelper.stack((Block)MFRThings.rednetCableBlock), ItemHelper.stack((Block)MFRThings.rednetCableBlock), ItemHelper.stack((Block)MFRThings.rednetCableBlock), ItemHelper.stack((Block)MFRThings.rednetCableBlock), ItemHelper.stack((Block)MFRThings.rednetCableBlock)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.machineItem, (int)1, (int)1), (Object[])new Object[]{"PRP", "RGR", "PIP", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "blockGlass", Character.valueOf('I'), "ingotIron"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetLogicBlock), (Object[])new Object[]{"RDR", "LGL", "PHP", Character.valueOf('H'), ItemHelper.stack((Block)MFRThings.machineItem, (int)1, (int)1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('L'), "gemLapis", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)0), (Object[])new Object[]{"RPR", "PGP", "RPR", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)1), (Object[])new Object[]{"GPG", "PCP", "RGR", Character.valueOf('C'), ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)0), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)2), (Object[])new Object[]{"DPD", "RCR", "GDG", Character.valueOf('C'), ItemHelper.stack((Item)MFRThings.logicCardItem, (int)1, (int)1), Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('D'), "gemDiamond", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rednetMeterItem, (int)1, (int)0), (Object[])new Object[]{" G", "PR", "PP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rednetMeterItem, (int)1, (int)1), (Object[])new Object[]{"RGR", "IMI", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "ingotGold", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), ItemHelper.stack((Item)MFRThings.rednetMeterItem, (int)1, (int)0)}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rednetMemoryCardItem, (int)1, (int)0), (Object[])new Object[]{"GGG", "PRP", "PPP", Character.valueOf('P'), "sheetPlastic", Character.valueOf('G'), "nuggetGold", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.stack((Block)MFRThings.rednetPanelBlock, (int)1, (int)0), (Object[])new Object[]{"PCP", "PBP", "KPK", Character.valueOf('P'), "sheetPlastic", Character.valueOf('C'), MFRThings.rednetCableBlock, Character.valueOf('B'), Blocks.field_150342_X, Character.valueOf('K'), "dyeBlack"}));
        ItemHelper.addShapelessRecipe((ItemStack)ItemHelper.stack((Item)MFRThings.rednetMemoryCardItem, (int)1, (int)0), (Object[])new Object[]{ItemHelper.stack((Item)MFRThings.rednetMemoryCardItem, (int)1, (int)0)});
    }

    private final void registerRedNetManual() {
        if (_registeredRedNetManual) {
            return;
        }
        _registeredRedNetManual = true;
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemBlockRedNetLogic.manual, (Object[])new Object[]{MFRThings.plasticSheetItem, "dustRedstone", Items.field_151122_aG}));
    }

    static {
        DYES = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    }
}

