/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.net;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.LinkedHashSet;
import net.minecraft.util.ReportedException;
import powercrystals.minefactoryreloaded.core.IGrid;
import powercrystals.minefactoryreloaded.core.IGridController;
import powercrystals.minefactoryreloaded.core.INode;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneEnergyNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.RedstoneNetwork;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetEnergy;
import powercrystals.minefactoryreloaded.tile.transport.FluidNetwork;
import powercrystals.minefactoryreloaded.tile.transport.TileEntityPlasticPipe;

public class GridTickHandler<G extends IGrid, N extends INode>
implements IGridController {
    public static final GridTickHandler<RedstoneEnergyNetwork, TileEntityRedNetEnergy> energy = new GridTickHandler("Energy");
    public static final GridTickHandler<RedstoneNetwork, TileEntityRedNetCable> redstone = new GridTickHandler("Redstone");
    public static final GridTickHandler<FluidNetwork, TileEntityPlasticPipe> fluid = new GridTickHandler("Fluid");
    private LinkedHashSet<G> tickingGridsToRegenerate = new LinkedHashSet();
    private LinkedHashSet<G> tickingGridsToAdd = new LinkedHashSet();
    private LinkedHashSet<G> tickingGrids = new LinkedHashSet();
    private LinkedHashSet<G> tickingGridsToRemove = new LinkedHashSet();
    private LinkedHashSet<N> conduit = new LinkedHashSet();
    private LinkedHashSet<N> conduitToAdd = new LinkedHashSet();
    private LinkedHashSet<N> conduitToUpd = new LinkedHashSet();
    private final String label;

    public GridTickHandler(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.label = "GridTickHandler[" + string + "]";
    }

    public void addGrid(G g) {
        this.tickingGridsToAdd.add(g);
        this.tickingGridsToRemove.remove(g);
    }

    public void removeGrid(G g) {
        this.tickingGridsToRemove.add(g);
        this.tickingGridsToAdd.remove(g);
    }

    public void regenerateGrid(G g) {
        this.tickingGridsToRegenerate.add(g);
    }

    public boolean isGridTicking(G g) {
        return this.tickingGrids.contains(g);
    }

    public void addConduitForTick(N n) {
        this.conduitToAdd.add(n);
    }

    public void addConduitForUpdate(N n) {
        this.conduitToUpd.add(n);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent serverTickEvent) {
        if (serverTickEvent.phase == TickEvent.Phase.START) {
            this.tickStart();
        } else {
            this.tickEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickStart() {
        Object object3;
        if (!this.tickingGridsToRegenerate.isEmpty()) {
            object3 = this.tickingGridsToRegenerate;
            synchronized (object3) {
                for (Object object2 : this.tickingGridsToRegenerate) {
                    object2.markSweep();
                }
                this.tickingGridsToRegenerate.clear();
            }
        }
        if (!this.conduitToUpd.isEmpty()) {
            object3 = this.conduitToUpd;
            synchronized (object3) {
                this.conduit.addAll(this.conduitToUpd);
                this.conduitToUpd.clear();
            }
        }
        if (!this.conduit.isEmpty()) {
            object3 = null;
            try {
                for (Object object3 : this.conduit) {
                    if (object3.isNotValid()) continue;
                    object3.updateInternalTypes(this);
                }
                this.conduit.clear();
            }
            catch (Throwable throwable) {
                Object object2;
                object2 = new RuntimeException("Crashing on conduit " + object3, throwable);
                if (throwable instanceof ReportedException) {
                    throwable.addSuppressed((Throwable)object2);
                    Throwables.propagate((Throwable)throwable);
                }
                throw object2;
            }
        }
        if (!this.tickingGrids.isEmpty()) {
            for (Object object4 : this.tickingGrids) {
                object4.doGridPreUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickEnd() {
        Object object3;
        if (!this.tickingGridsToRemove.isEmpty()) {
            object3 = this.tickingGridsToRemove;
            synchronized (object3) {
                this.tickingGrids.removeAll(this.tickingGridsToRemove);
                this.tickingGridsToRemove.clear();
            }
        }
        if (!this.tickingGridsToAdd.isEmpty()) {
            object3 = this.tickingGridsToAdd;
            synchronized (object3) {
                this.tickingGrids.addAll(this.tickingGridsToAdd);
                this.tickingGridsToAdd.clear();
            }
        }
        if (!this.tickingGrids.isEmpty()) {
            for (Object object2 : this.tickingGrids) {
                object2.doGridUpdate();
            }
        }
        if (!this.conduitToAdd.isEmpty()) {
            object3 = this.conduitToAdd;
            synchronized (object3) {
                this.conduit.addAll(this.conduitToAdd);
                this.conduitToAdd.clear();
            }
        }
        if (!this.conduit.isEmpty()) {
            object3 = null;
            try {
                for (Object object3 : this.conduit) {
                    if (object3.isNotValid()) continue;
                    object3.firstTick(this);
                }
                this.conduit.clear();
            }
            catch (Throwable throwable) {
                RuntimeException runtimeException = new RuntimeException("Crashing on conduit " + object3, throwable);
                if (throwable instanceof ReportedException) {
                    throwable.addSuppressed(runtimeException);
                    Throwables.propagate((Throwable)throwable);
                }
                throw runtimeException;
            }
        }
    }

    public String toString() {
        return this.label + "@" + this.hashCode();
    }
}

