/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.thaumcraft;

import cofh.api.modhelpers.ThaumcraftHelper;
import cofh.asm.relauncher.Strippable;
import cofh.mod.ChildMod;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCocoa;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizableCropPlant;
import powercrystals.minefactoryreloaded.farmables.fruits.FactoryFruitStandard;
import powercrystals.minefactoryreloaded.farmables.fruits.FruitCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableCocoa;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableWood;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCocoa;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.FertilizableTCSapling;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.HarvestableThaumcraftLeaves;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.HarvestableThaumcraftPlant;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.PlantableThaumcraftTree;
import powercrystals.minefactoryreloaded.modhelpers.thaumcraft.SpawnablePech;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;

@ChildMod(parent="MineFactoryReloaded", mod={@Mod(modid="MineFactoryReloaded|CompatThaumcraft", name="MFR Compat: Thaumcraft", version="1.7.10R2.8.2B1", dependencies="after:MineFactoryReloaded;after:Thaumcraft", customProperties={@Mod.CustomProperty(k="cofhversion", v="true")})})
public class Thaumcraft {
    @Mod.EventHandler
    @Strippable(value={"mod:Thaumcraft"})
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        try {
            Block block = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCustomPlant");
            Block block2 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLog");
            Block block3 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLeaves");
            Block block4 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockTaintFibres");
            Class<?> clazz = Class.forName("thaumcraft.common.entities.golems.EntityGolemBase");
            Class<?> clazz2 = Class.forName("thaumcraft.common.entities.golems.EntityTravelingTrunk");
            Class<?> clazz3 = Class.forName("thaumcraft.common.entities.monster.EntityPech");
            MFRRegistry.registerAutoSpawnerBlacklistClass(clazz);
            MFRRegistry.registerAutoSpawnerBlacklistClass(clazz2);
            MFRRegistry.registerSpawnHandler(new SpawnablePech(clazz3));
            MFRRegistry.registerGrinderBlacklist(clazz);
            MFRRegistry.registerGrinderBlacklist(clazz2);
            if (MFRConfig.conveyorNeverCapturesTCGolems.getBoolean(false)) {
                MFRRegistry.registerConveyerBlacklist(clazz);
                MFRRegistry.registerConveyerBlacklist(clazz2);
            }
            MFRRegistry.registerHarvestable(new HarvestableWood(block2));
            MFRRegistry.registerHarvestable(new HarvestableStandard(block4, HarvestType.Normal));
            MFRRegistry.registerHarvestable(new HarvestableThaumcraftLeaves(block3, Item.func_150898_a((Block)block)));
            MFRRegistry.registerHarvestable(new HarvestableThaumcraftPlant(block));
            MFRRegistry.registerPlantable(new PlantableThaumcraftTree(block));
            MFRRegistry.registerFertilizable(new FertilizableTCSapling(block));
        }
        catch (Throwable throwable) {
            ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)this);
            LogManager.getLogger((String)modContainer.getModId()).log(Level.ERROR, "There was a problem loading " + modContainer.getName(), throwable);
        }
    }

    @Mod.EventHandler
    @Strippable(value={"mod:Thaumcraft@[4.2.1,)"})
    public void loadManabean(FMLInitializationEvent fMLInitializationEvent) {
        try {
            Block block = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockManaPod");
            final Block block2 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLog");
            Item item = GameRegistry.findItem((String)"Thaumcraft", (String)"ItemManaBean");
            MFRRegistry.registerHarvestable(new HarvestableStandard(block){

                @Override
                public boolean canBeHarvested(World world, Map<String, Boolean> map, int n, int n2, int n3) {
                    if (map.get("isHarvestingTree") == Boolean.TRUE) {
                        return true;
                    }
                    int n4 = world.func_72805_g(n, n2, n3);
                    return n4 >= 5;
                }
            });
            MFRRegistry.registerPlantable(new PlantableStandard(item, block){

                @Override
                public boolean canBePlantedHere(World world, int n, int n2, int n3, ItemStack itemStack) {
                    if (!world.func_147437_c(n, n2, n3)) {
                        return false;
                    }
                    return this.isNextToAcceptableLog(world, n, n2, n3);
                }

                protected boolean isNextToAcceptableLog(World world, int n, int n2, int n3) {
                    boolean bl = false;
                    BiomeGenBase biomeGenBase = world.func_72807_a(n, n3);
                    if (biomeGenBase != null) {
                        bl = BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
                    }
                    return bl && this.isGoodLog(world, n, n2 + 1, n3);
                }

                protected boolean isGoodLog(World world, int n, int n2, int n3) {
                    Block block = world.func_147439_a(n, n2, n3);
                    return block == block2 || block.equals(Blocks.field_150364_r);
                }

                @Override
                public void postPlant(World world, int n, int n2, int n3, ItemStack itemStack) {
                    TileEntity tileEntity;
                    NBTTagCompound nBTTagCompound;
                    NBTTagList nBTTagList = itemStack.field_77990_d.func_150295_c("Aspects", 10);
                    String string = "herba";
                    for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                        nBTTagCompound = nBTTagList.func_150305_b(i);
                        if (!nBTTagCompound.func_74764_b("key")) continue;
                        string = nBTTagCompound.func_74779_i("key");
                        break;
                    }
                    if ((tileEntity = world.func_147438_o(n, n2, n3)) != null) {
                        nBTTagCompound = new NBTTagCompound();
                        tileEntity.func_145841_b(nBTTagCompound);
                        nBTTagCompound.func_74778_a("aspect", string);
                        tileEntity.func_145839_a(nBTTagCompound);
                    }
                }
            });
            MFRRegistry.registerFruitLogBlock(block2);
            MFRRegistry.registerFruit(new FactoryFruitStandard(block){

                @Override
                public boolean canBePicked(World world, int n, int n2, int n3) {
                    int n4 = world.func_72805_g(n, n2, n3);
                    return n4 >= 7;
                }
            });
            MFRRegistry.registerFertilizable(new FertilizableCropPlant(block, FertilizerType.GrowMagicalCrop, 6){

                @Override
                public boolean fertilize(World world, Random random, int n, int n2, int n3, FertilizerType fertilizerType) {
                    int n4 = world.func_72805_g(n, n2, n3);
                    return world.func_72921_c(n, n2, n3, n4 += random.nextInt(3), 2);
                }
            });
        }
        catch (Throwable throwable) {
            ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)this);
            LogManager.getLogger((String)modContainer.getModId()).log(Level.ERROR, "There was a problem loading " + modContainer.getName(), throwable);
        }
    }

    @Mod.EventHandler
    @Strippable(value={"mod:Thaumcraft@[4,4.2.1)"})
    public void loadCocoa(FMLInitializationEvent fMLInitializationEvent) {
        try {
            Block block = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockManaPod");
            final Block block2 = GameRegistry.findBlock((String)"Thaumcraft", (String)"blockMagicalLog");
            Item item = GameRegistry.findItem((String)"Thaumcraft", (String)"ItemManaBean");
            MFRRegistry.registerHarvestable(new HarvestableCocoa(block));
            MFRRegistry.registerPlantable(new PlantableCocoa(item, block){

                @Override
                protected boolean isNextToAcceptableLog(World world, int n, int n2, int n3) {
                    boolean bl = false;
                    BiomeGenBase biomeGenBase = world.func_72807_a(n, n3);
                    if (biomeGenBase != null) {
                        bl = BiomeDictionary.isBiomeOfType((BiomeGenBase)biomeGenBase, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL);
                    }
                    return bl && this.isGoodLog(world, n + 1, n2, n3) || this.isGoodLog(world, n - 1, n2, n3) || this.isGoodLog(world, n, n2, n3 + 1) || this.isGoodLog(world, n, n2, n3 - 1);
                }

                @Override
                protected boolean isGoodLog(World world, int n, int n2, int n3) {
                    Block block = world.func_147439_a(n, n2, n3);
                    return block == block2 || block.equals(Blocks.field_150364_r);
                }
            });
            MFRRegistry.registerFruitLogBlock(block2);
            MFRRegistry.registerFruit(new FruitCocoa(block));
            MFRRegistry.registerFertilizable(new FertilizableCocoa(block, FertilizerType.GrowMagicalCrop));
        }
        catch (Throwable throwable) {
            ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)this);
            LogManager.getLogger((String)modContainer.getModId()).log(Level.ERROR, "There was a problem loading " + modContainer.getName(), throwable);
        }
    }

    @Mod.EventHandler
    @Strippable(value={"api:Thaumcraft|API"})
    public void load(FMLLoadCompleteEvent fMLLoadCompleteEvent) throws Throwable {
        try {
            Thaumcraft.doAspects();
        }
        catch (Throwable throwable) {
            ModContainer modContainer = FMLCommonHandler.instance().findContainerFor((Object)this);
            LogManager.getLogger((String)modContainer.getModId()).log(Level.ERROR, "There was a problem loading " + modContainer.getName(), throwable);
        }
    }

    private static void parseAspects2(Machine machine, String string) throws Throwable {
        ThaumcraftHelper.parseAspects((ItemStack)machine.getItemStack(), (String)string, (boolean)true);
    }

    private static void doAspects() throws Throwable {
        Thaumcraft.parseAspects2(Machine.AutoAnvil, "3 permutatio, 5 fabrico, 10 metallum, 5 machina");
        Thaumcraft.parseAspects2(Machine.AutoBrewer, "4 ignis, 2 fabrico, 2 aqua, 2 praecantatio, 5 machina");
        Thaumcraft.parseAspects2(Machine.AutoDisenchanter, "4 praecantatio, 4 permutatio, 5 machina");
        Thaumcraft.parseAspects2(Machine.AutoEnchanter, "8 praecantatio, 4 cognitio, 4 fabrico, 5 machina");
        Thaumcraft.parseAspects2(Machine.AutoJukebox, "4 sensus, 4 aer, 5 machina");
        Thaumcraft.parseAspects2(Machine.AutoSpawner, "4 bestia, 4 exanimis, 7 praecantatio, 4 alienis, 5 machina, 10 permutatio");
        Thaumcraft.parseAspects2(Machine.BioFuelGenerator, "15 potentia, 3 herba, 5 machina, 3 permutatio");
        Thaumcraft.parseAspects2(Machine.BioReactor, "4 herba, 2 potentia, 5 machina, 5 permutatio");
        Thaumcraft.parseAspects2(Machine.BlockBreaker, "15 perfodio, 5 machina, 5 metallum, 3 lucrum");
        Thaumcraft.parseAspects2(Machine.BlockPlacer, "1 motus, 1 ordo, 5 machina, 5 metallum, 3 lucrum");
        Thaumcraft.parseAspects2(Machine.BlockSmasher, "5 perditio, 5 machina, 3 permutatio, 3 praecantatio");
        Thaumcraft.parseAspects2(Machine.Breeder, "2 bestia, 2 fames, 5 machina");
        Thaumcraft.parseAspects2(Machine.Chronotyper, "3 tempus, 3 bestia, 5 machina, 3 sensus");
        Thaumcraft.parseAspects2(Machine.ChunkLoader, "100 potentia, 30 alienis, 20 praecantatio, 10 iter, 10 vacuos, 5 machina, 5 instrumentum");
        Thaumcraft.parseAspects2(Machine.Composter, "2 bestia, 2 aqua, 5 machina");
        Thaumcraft.parseAspects2(Machine.DeepStorageUnit, "4971027 vacuos, 5 machina, 15 alienis, 1 praecantatio");
        Thaumcraft.parseAspects2(Machine.Ejector, "4 motus, 5 machina");
        Thaumcraft.parseAspects2(Machine.EnchantmentRouter, "1 motus, 4 iter, 2 sensus, 5 machina, 1 praecantatio");
        Thaumcraft.parseAspects2(Machine.Fertilizer, "6 herba, 5 machina, 1 vitreus, 3 victus");
        Thaumcraft.parseAspects2(Machine.Fisher, "3 aqua, 5 machina, 4 metallum, 2 instrumentum");
        Thaumcraft.parseAspects2(Machine.Fountain, "10 aqua, 5 machina, 3 fabrico, 1 iter");
        Thaumcraft.parseAspects2(Machine.FruitPicker, "2 herba, 4 meto, 5 machina");
        Thaumcraft.parseAspects2(Machine.Grinder, "10 telum, 6 mortuus, 7 meto, 5 machina, 4 metallum, 2 lucrum");
        Thaumcraft.parseAspects2(Machine.ItemCollector, "4 vacuos, 5 machina, 2 arbor, 4 motus");
        Thaumcraft.parseAspects2(Machine.ItemRouter, "2 motus, 4 iter, 2 sensus,  5 machina");
        Thaumcraft.parseAspects2(Machine.LaserDrill, "30 perfodio, 15 lux, 5 machina, 4 victus");
        Thaumcraft.parseAspects2(Machine.LaserDrillPrecharger, "4 lux, 5 machina, 25 potentia, 2 victus");
        Thaumcraft.parseAspects2(Machine.LavaFabricator, "4 ignis, 4 terra, 4 fabrico, 5 machina");
        Thaumcraft.parseAspects2(Machine.LiquiCrafter, "5 aqua, 5 fabrico, 5 machina");
        Thaumcraft.parseAspects2(Machine.LiquidRouter, "1 motus, 4 iter, 2 sensus, 5 machina, 1 aqua");
        Thaumcraft.parseAspects2(Machine.MeatPacker, "2 ordo, 2 corpus, 2 fames, 5 machina");
        Thaumcraft.parseAspects2(Machine.MobCounter, "5 ordo, 5 machina, 5 cognitio");
        Thaumcraft.parseAspects2(Machine.MobRouter, "3 ordo, 3 bestia, 5 machina, 3 sensus");
        Thaumcraft.parseAspects2(Machine.Planter, "4 herba, 2 arbor, 4 messis, 5 machina");
        Thaumcraft.parseAspects2(Machine.Rancher, "6 meto, 5 machina, 4 metallum, 2 instrumentum");
        Thaumcraft.parseAspects2(Machine.RedNote, "4 aer, 4 sensus, 5 machina");
        Thaumcraft.parseAspects2(Machine.Sewer, "1 venenum, 3 aqua, 5 machina, 4 bestia");
        Thaumcraft.parseAspects2(Machine.Slaughterhouse, "12 telum, 10 mortuus, 5 machina, 12 metallum, 6 lucrum");
        Thaumcraft.parseAspects2(Machine.SludgeBoiler, "3 ordo, 3 venenum, 3 terra, 2 aqua, 5 machina, 2 ignis");
        Thaumcraft.parseAspects2(Machine.SteamBoiler, "3 fabrico, 7 aqua, 5 machina, 10 ignis, 3 perditio");
        Thaumcraft.parseAspects2(Machine.SteamTurbine, "3 vacuos, 3 aqua, 5 machina, 10 potentia, 1 fabrico, 3 ordo");
        Thaumcraft.parseAspects2(Machine.Unifier, "5 ordo, 2 alienis, 5 machina");
        Thaumcraft.parseAspects2(Machine.Vet, "4 sano, 5 machina, 4 bestia");
        Thaumcraft.parseAspects2(Machine.WeatherCollector, " 4 vacuos, 5 machina, 5 metallum, 4 tempestas");
        ThaumcraftHelper.parseAspects((String)"mfrEntityPinkSlime", (String)"1 aqua, 2 limus, 1 corpus, 1 bestia");
        ThaumcraftHelper.parseAspects((Block)MFRThings.milkLiquid, (String)"4 fames, 4 sano, 4 aqua, 2 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.chocolateMilkLiquid, (String)"4 fames, 2 motus, 2 potentia, 4 aqua");
        ThaumcraftHelper.parseAspects((Block)MFRThings.essenceLiquid, (String)"4 praecantatio, 2 cognitio, 2 aqua");
        ThaumcraftHelper.parseAspects((Block)MFRThings.mushroomSoupLiquid, (String)"4 fames, 4 herba, 1 aqua");
        ThaumcraftHelper.parseAspects((Block)MFRThings.pinkSlimeLiquid, (String)"4 limus, 4 corpus, 2 aqua");
        ThaumcraftHelper.parseAspects((Block)MFRThings.sewageLiquid, (String)"4 venenum, 2 bestia, 2 aqua, 1 vitium");
        ThaumcraftHelper.parseAspects((Block)MFRThings.sludgeLiquid, (String)"4 venenum, 2 terra, 2 aqua, 1 mortuus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.machineItem, (int)0, (String)"2 fabrico, 2 machina, 1 terra");
        ThaumcraftHelper.parseAspects((Block)MFRThings.machineItem, (int)1, (String)"1 cognitio, 3 machina");
        ThaumcraftHelper.parseAspects((Item)MFRThings.rubberBarItem, (String)"1 motus, 1 arbor, 1 ignis");
        ThaumcraftHelper.parseAspects((Block)MFRThings.rubberLeavesBlock, (String)"1 herba");
        ThaumcraftHelper.parseAspects((Block)MFRThings.rubberSaplingBlock, (String)"1 arbor, 1 herba");
        ThaumcraftHelper.parseAspects((Block)MFRThings.rubberWoodBlock, (int)0, (String)"3 arbor");
        ThaumcraftHelper.parseAspects((Block)MFRThings.rubberWoodBlock, (int)1, (String)"3 arbor, 1 limus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.rawRubberItem, (String)"2 limus, 1 arbor");
        ThaumcraftHelper.parseAspects((Item)MFRThings.rawPlasticItem, (String)"1 fabrico, 1 ignis, 1 ordo, 1 perditio");
        ThaumcraftHelper.parseAspects((Item)MFRThings.plasticSheetItem, (String)"1 fabrico, 1 ignis, 2 ordo");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryPlasticBlock, (String)"1 iter, 1 fabrico, 1 sensus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.plasticPipeBlock, (String)"1 aqua, 1 machina", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.plasticTank, (String)"4 aqua, 4 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.bioFuelBucketItem, (String)"2 herba, 1 potentia, 1 aqua, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Block)MFRThings.biofuelLiquid, (String)"4 herba, 2 potentia, 2 aqua");
        ThaumcraftHelper.parseAspects((Item)MFRThings.blankRecordItem, (String)"4 sensus, 4 aer, 4 lucrum, 4 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.ceramicDyeItem, (String)"1 terra, 1 aqua, 1 sensus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.chocolateMilkBucketItem, (String)"2 fames, 1 motus, 1 potentia, 2 aqua, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Block)MFRThings.conveyorBlock, (String)"3 motus, 1 iter, 1 machina");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryGlassBlock, (String)"1 vitreus, 1 sensus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.factoryHammerItem, (String)"1 instrumentum, 2 fabrico, 2 ignis, 3 ordo");
        ThaumcraftHelper.parseAspects((Item)MFRThings.fertilizerItem, (String)"1 arbor, 1 herba, 1 messis, 1 sensus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.laserFocusItem, (String)"1 ordo, 1 vitreus, 4 lucrum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.meatBucketItem, (String)"3 corpus, 1 bestia, 1 aqua, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.meatIngotCookedItem, (String)"3 corpus, 2 fames, 1 ignis");
        ThaumcraftHelper.parseAspects((Item)MFRThings.meatIngotRawItem, (String)"3 corpus, 2 fames, 1 bestia");
        ThaumcraftHelper.parseAspects((Block)MFRThings.meatLiquid, (String)"6 corpus, 2 aqua, 2 bestia");
        ThaumcraftHelper.parseAspects((Item)MFRThings.meatNuggetCookedItem, (String)"1 fames");
        ThaumcraftHelper.parseAspects((Item)MFRThings.meatNuggetRawItem, (String)"1 corpus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.milkBottleItem, (String)"1 fames, 1 sano, 1 victus, 1 vitreus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.mobEssenceBucketItem, (String)"2 praecantatio, 1 cognitio, 1 aqua, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.mushroomSoupBucketItem, (String)"2 fames, 2 herba, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.pinkSlimeItem, (String)"1 limus, 1 corpus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.pinkSlimeBlock, (String)"9 limus, 9 corpus, 2 aqua");
        ThaumcraftHelper.parseAspects((Item)MFRThings.pinkSlimeBucketItem, (String)"2 limus, 2 corpus, 1 aqua, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.portaSpawnerItem, (String)"8 alienis, 4 bestia, 4 exanimis, 4 iter, 8 praecantatio, 8 permutatio");
        ThaumcraftHelper.parseAspects((Block)MFRThings.rednetCableBlock, (int)0, (String)"1 cognitio, 1 machina", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.rednetCableBlock, (int)1, (String)"1 cognitio, 1 machina, 1 vitreus", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.rednetCableBlock, (int)2, (String)"1 cognitio, 1 machina, 3 potentia", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.rednetCableBlock, (int)3, (String)"1 cognitio, 1 machina, 3 potentia, 1 vitreus", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.rednetLogicBlock, (String)"15 cognitio, 5 machina", (boolean)true);
        ThaumcraftHelper.parseAspects((Item)MFRThings.rednetMemoryCardItem, (String)"3 cognitio, 1 machina");
        ThaumcraftHelper.parseAspects((Item)MFRThings.rednetMeterItem, (int)0, (String)"1 instrumentum, 1 sensus, 1 machina");
        ThaumcraftHelper.parseAspects((Item)MFRThings.rednetMeterItem, (int)1, (String)"4 instrumentum, 1 sensus, 2 machina");
        ThaumcraftHelper.parseAspects((Block)MFRThings.rednetPanelBlock, (String)"2 sensus, 2 cognitio, 2 machina");
        ThaumcraftHelper.parseAspects((Item)MFRThings.rulerItem, (String)"1 instrumentum, 1 sensus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.safariNetItem, (String)"4 spiritus, 8 alienis, 8 iter, 4 praecantatio, 8 vinculum, 4 fabrico");
        ThaumcraftHelper.parseAspects((Item)MFRThings.safariNetJailerItem, (String)"10 vinculum, 1 praecantatio, 4 spiritus, 2 metallum, 1 fabrico");
        ThaumcraftHelper.parseAspects((Item)MFRThings.safariNetLauncherItem, (String)"2 volatus, 2 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.safariNetSingleItem, (String)"4 vinculum, 4 spiritus, 2 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.sewageBucketItem, (String)"2 venenum, 1 bestia, 1 aqua, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.sludgeBucketItem, (String)"2 venenum, 1 terra, 1 aqua, 1 vitium, 8 metallum, 1 vacuos");
        ThaumcraftHelper.parseAspects((Item)MFRThings.spyglassItem, (String)"2 victus, 6 sensus");
        ThaumcraftHelper.parseAspects((Item)MFRThings.strawItem, (String)"1 vacuos, 4 aqua, 4 fames, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.sugarCharcoalItem, (String)"2 potentia, 2 ignis");
        ThaumcraftHelper.parseAspects((Item)MFRThings.syringeCureItem, (String)"2 sano, 1 exanimis, 1 humanus, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.syringeEmptyItem, (String)"1 vacuos, 1 sano, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.syringeGrowthItem, (String)"1 tempus, 2 sano, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.syringeHealthItem, (String)"2 sano, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.syringeSlimeItem, (String)"1 sano, 1 limus, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Item)MFRThings.syringeZombieItem, (String)"1 tempus, 1 sano, 1 exanimis, 1 instrumentum");
        ThaumcraftHelper.parseAspects((Block)MFRThings.vineScaffoldBlock, (String)"1 herba, 1 fabrico");
        ThaumcraftHelper.parseAspects((Item)MFRThings.xpExtractorItem, (String)"1 praecantatio, 1 permutatio, 1 vacuos, 1 instrumentum, 1 meto");
        ThaumcraftHelper.parseAspects((Item)MFRThings.upgradeItem, (String)"2 cognitio");
        int n = 10;
        for (int i = 0; i <= n; ++i) {
            ThaumcraftHelper.parseAspects((Item)MFRThings.upgradeItem, (int)i, (String)"2 cognitio", (boolean)true);
        }
        ThaumcraftHelper.parseAspects((Item)MFRThings.upgradeItem, (int)11, (String)"1 cognitio", (boolean)true);
        ThaumcraftHelper.parseAspects((Item)MFRThings.logicCardItem, (int)0, (String)"4 cognitio", (boolean)true);
        ThaumcraftHelper.parseAspects((Item)MFRThings.logicCardItem, (int)1, (String)"7 cognitio", (boolean)true);
        ThaumcraftHelper.parseAspects((Item)MFRThings.logicCardItem, (int)2, (String)"10 cognitio", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)0, (String)"2 gelum, 1 terra");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)1, (String)"1 terra, 3 lux, 2 sensus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)2, (String)"2 terra, 4 sensus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)3, (String)"2 terra, 3 ignis, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)4, (String)"2 terra, 1 ordo");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)5, (String)"1 gelum, 1 terra");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)6, (String)"2 gelum, 1 terra");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)7, (String)"1 terra, 3 lux, 2 sensus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)8, (String)"2 terra, 4 sensus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)9, (String)"3 ignis, 2 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)10, (String)"3 terra");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)12, (String)"1 gelum, 1 terra");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)12, (String)"3 corpus, 2 fames, 1 bestia", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)13, (String)"3 corpus, 2 fames, 1 ignis", (boolean)true);
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)14, (String)"4 terra, 4 ignis");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeBrickBlock, (int)15, (String)"10 ignis, 10 potentia");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)0, (String)"2 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)1, (String)"2 terra, 1 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)2, (String)"1 perditio, 1 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)3, (String)"1 perditio, 1 terra, 1 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)4, (String)"2 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)5, (String)"2 terra, 1 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)6, (String)"3 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)7, (String)"3 terra, 1 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)8, (String)"2 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)9, (String)"2 terra, 1 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)10, (String)"3 terra, 1 tenebrae");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryDecorativeStoneBlock, (int)11, (String)"3 terra, 1 victus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryRoadBlock, (int)0, (String)"3 iter, 1 terra, 1 sensus");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryRoadBlock, (int)1, (String)"3 iter, 1 terra, 1 sensus, 3 lux");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryRoadBlock, (int)2, (String)"3 iter, 1 terra, 1 sensus, 3 lux");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryRoadBlock, (int)3, (String)"3 iter, 1 terra, 1 sensus, 3 lux");
        ThaumcraftHelper.parseAspects((Block)MFRThings.factoryRoadBlock, (int)4, (String)"3 iter, 1 terra, 1 sensus, 3 lux");
    }
}

