/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.gui.client;

import cofh.core.CoFHProps;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.gui.GuiBase;
import cofh.lib.util.RegistryUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryInventory;
import powercrystals.minefactoryreloaded.gui.slot.SlotFake;
import powercrystals.minefactoryreloaded.net.Packets;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;

public class GuiFactoryInventory
extends GuiBase {
    protected static DecimalFormat decimal_format = new DecimalFormat();
    protected TileEntityFactoryInventory _tileEntity;
    protected ContainerFactoryInventory _container;
    protected int _barSizeMax;
    protected int _tankSizeMax;
    protected int _tanksOffsetX;
    protected int _tanksOffsetY;
    protected int _xOffset;
    protected boolean _renderTanks;

    public GuiFactoryInventory(ContainerFactoryInventory containerFactoryInventory, TileEntityFactoryInventory tileEntityFactoryInventory) {
        super((Container)containerFactoryInventory, new ResourceLocation("minefactoryreloaded:textures/gui/" + tileEntityFactoryInventory.getGuiBackground() + ".png"));
        ResourceLocation resourceLocation;
        decimal_format.setMaximumFractionDigits(1);
        decimal_format.setMinimumFractionDigits(1);
        this._barSizeMax = 60;
        this._tankSizeMax = 60;
        this._tanksOffsetX = 122;
        this._tanksOffsetY = 15;
        this._xOffset = 8;
        this._renderTanks = true;
        this._container = containerFactoryInventory;
        this.drawTitle = false;
        this.drawInventory = false;
        this._tileEntity = tileEntityFactoryInventory;
        if (CoFHProps.enableColorBlindTextures && RegistryUtils.textureExists((ResourceLocation)(resourceLocation = new ResourceLocation("minefactoryreloaded:textures/gui/" + this._tileEntity.getGuiBackground() + "_cb.png")))) {
            this.texture = resourceLocation;
        }
    }

    protected boolean isPointInRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.func_146978_c(n, n2, n3, n4, n5, n6);
    }

    protected void func_73864_a(int n, int n2, int n3) {
        super.func_73864_a(n, n2, n3);
        n -= ((GuiContainer)this).field_147003_i;
        n2 -= ((GuiContainer)this).field_147009_r;
        for (Object e : ((GuiContainer)this).field_147002_h.field_75151_b) {
            if (!(e instanceof SlotFake)) continue;
            SlotFake slotFake = (SlotFake)((Object)e);
            if (n < slotFake.field_75223_e || n > slotFake.field_75223_e + 16 || n2 < slotFake.field_75221_f || n2 > slotFake.field_75221_f + 16) continue;
            Packets.sendToServer((short)20, this._tileEntity, Minecraft.func_71410_x().field_71439_g.func_145782_y(), slotFake.field_75222_d, (byte)n3);
        }
    }

    protected void func_146979_b(int n, int n2) {
        super.func_146979_b(n, n2);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)this).field_146289_q.func_78276_b(this._tileEntity.func_145825_b(), this._xOffset, 6, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), this._xOffset, ((GuiContainer)this).field_147000_g - 96 + 3, 0x404040);
        if (this._renderTanks) {
            int n3;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FluidTankInfo[] fluidTankInfoArray = this._tileEntity.getTankInfo(ForgeDirection.UNKNOWN);
            int n4 = n3 = fluidTankInfoArray.length > 3 ? 3 : fluidTankInfoArray.length;
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    if (fluidTankInfoArray[i].fluid == null) continue;
                    int n5 = fluidTankInfoArray[i].fluid.amount * this._tankSizeMax / fluidTankInfoArray[i].capacity;
                    this.drawTank(this._tanksOffsetX - i * 20, this._tanksOffsetY + this._tankSizeMax, fluidTankInfoArray[i].fluid, n5);
                }
            }
        }
    }

    public void func_73863_a(int n, int n2, float f) {
        super.func_73863_a(n, n2, f);
        this.drawTooltips(n, n2);
    }

    protected void drawTooltips(int n, int n2) {
        int n3;
        int n4;
        FluidTankAdv[] fluidTankAdvArray = this._tileEntity.getTanks();
        int n5 = n4 = fluidTankAdvArray.length > 3 ? 3 : fluidTankAdvArray.length;
        if (n4 > 0 && this.isPointInRegion(this._tanksOffsetX - (n4 - 1) * 20 + 1, this._tanksOffsetY + 1, n4 * 20 - n4 - 1, this._tankSizeMax - 2, n, n2) && (n3 = n - ((GuiContainer)this).field_147003_i - this._tanksOffsetX + (n4 - 1) * 20) % 20 < 16) {
            n3 /= 20;
            n3 = n4 - n3 - 1;
            this.drawTankTooltip(fluidTankAdvArray[n3], n, n2);
        }
    }

    protected final void drawBar(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n6 = n3 > 0 ? (int)((long)n4 * (long)this._barSizeMax / (long)n3) : 0;
        if (n6 > this._barSizeMax) {
            n6 = n3;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        this.bindTexture(this.texture);
        this.func_73729_b(n, n2 - n6, ((GuiContainer)this).field_146999_f + n5 * 8 + n5, 60 + this._barSizeMax - n6, 8, n6);
    }

    protected void drawTank(int n, int n2, FluidStack fluidStack, int n3) {
        if (fluidStack == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        IIcon iIcon = fluid.getIcon(fluidStack);
        if (iIcon == null) {
            iIcon = Blocks.field_150356_k.func_149691_a(0, 0);
        }
        int n4 = 0;
        this.bindTexture(fluid);
        while (n3 > 0) {
            int n5 = 0;
            if (n3 > 16) {
                n5 = 16;
                n3 -= 16;
            } else {
                n5 = n3;
                n3 = 0;
            }
            this.func_94065_a(n, n2 - n5 - n4, iIcon, 16, n5);
            n4 += 16;
        }
        this.bindTexture(this.texture);
        this.func_73729_b(n, n2 - 60, 176, 0, 16, 60);
    }

    protected void bindTexture(Fluid fluid) {
        if (fluid.getSpriteNumber() == 0) {
            ((GuiScreen)this).field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        } else {
            GL11.glBindTexture((int)3553, (int)fluid.getSpriteNumber());
        }
    }

    protected void drawTankTooltip(FluidTankAdv fluidTankAdv, int n, int n2) {
        FluidStack fluidStack = fluidTankAdv.getFluid();
        if (fluidStack != null) {
            this.drawBarTooltip(MFRUtil.getFluidName(fluidStack), "mB", fluidStack.amount, fluidTankAdv.getCapacity(), n, n2);
        } else {
            this.drawBarTooltip(MFRUtil.empty(), "mB", 0, fluidTankAdv.getCapacity(), n, n2);
        }
    }

    protected void drawBarTooltip(String string, String string2, int n, int n2, int n3, int n4) {
        this.drawBarTooltip(string, string2, n, n2, n3, n4, null);
    }

    protected void drawBarTooltip(String string, String string2, int n, int n2, int n3, int n4, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        String string3 = String.valueOf(n2);
        String string4 = String.valueOf(n);
        while (string4.length() < string3.length()) {
            string4 = " " + string4;
        }
        arrayList.add(string4 + " / " + string3 + " " + string2);
        if (stringArray != null) {
            for (String string5 : stringArray) {
                arrayList.add(string5);
            }
        }
        this.drawTooltip(arrayList, n3, n4);
    }

    protected void drawBarTooltip(String string, String string2, float f, float f2, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        String string3 = decimal_format.format(f2);
        String string4 = decimal_format.format(f);
        while (string4.length() < string3.length()) {
            string4 = " " + string4;
        }
        arrayList.add(string4 + " / " + string3 + " " + string2);
        this.drawTooltip(arrayList, n, n2);
    }

    protected void drawTooltip(List<String> list, int n, int n2) {
        int n3;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        int n4 = 0;
        for (n3 = 0; n3 < list.size(); ++n3) {
            int n5 = ((GuiScreen)this).field_146289_q.func_78256_a(list.get(n3));
            if (n5 <= n4) continue;
            n4 = n5;
        }
        int n6 = n + 12;
        int n7 = n2 - 12;
        n3 = 8;
        if (list.size() > 1) {
            n3 += 2 + (list.size() - 1) * 10;
        }
        if (n6 + n4 + 6 > ((GuiScreen)this).field_146294_l) {
            n6 -= 28 + n4;
            n6 &= ~n6 >> 31;
        }
        if (((GuiContainer)this).field_147009_r + n7 + n3 + 6 > ((GuiScreen)this).field_146295_m) {
            n7 = ((GuiScreen)this).field_146295_m - n3 - ((GuiContainer)this).field_147009_r - 6;
        }
        ((Gui)this).field_73735_i = 300.0f;
        GuiScreen.field_146296_j.field_77023_b = 300.0f;
        int n8 = -267386864;
        this.func_73733_a(n6 - 3, n7 - 4, n6 + n4 + 3, n7 - 3, n8, n8);
        this.func_73733_a(n6 - 3, n7 + n3 + 3, n6 + n4 + 3, n7 + n3 + 4, n8, n8);
        this.func_73733_a(n6 - 3, n7 - 3, n6 + n4 + 3, n7 + n3 + 3, n8, n8);
        this.func_73733_a(n6 - 4, n7 - 3, n6 - 3, n7 + n3 + 3, n8, n8);
        this.func_73733_a(n6 + n4 + 3, n7 - 3, n6 + n4 + 4, n7 + n3 + 3, n8, n8);
        int n9 = 0x505000FF;
        int n10 = (n9 & 0xFEFEFE) >> 1 | n9 & 0xFF000000;
        this.func_73733_a(n6 - 3, n7 - 3 + 1, n6 - 3 + 1, n7 + n3 + 3 - 1, n9, n10);
        this.func_73733_a(n6 + n4 + 2, n7 - 3 + 1, n6 + n4 + 3, n7 + n3 + 3 - 1, n9, n10);
        this.func_73733_a(n6 - 3, n7 - 3, n6 + n4 + 3, n7 - 3 + 1, n9, n9);
        this.func_73733_a(n6 - 3, n7 + n3 + 2, n6 + n4 + 3, n7 + n3 + 3, n10, n10);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            string = i == 0 ? "\u00a7F" + string : "\u00a77" + string;
            ((GuiScreen)this).field_146289_q.func_78261_a(string, n6, n7, -1);
            if (i == 0) {
                n7 += 2;
            }
            n7 += 10;
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        ((Gui)this).field_73735_i = 0.0f;
        GuiScreen.field_146296_j.field_77023_b = 0.0f;
    }

    public void func_94065_a(int n, int n2, IIcon iIcon, int n3, int n4) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + n4), (double)((Gui)this).field_73735_i, (double)iIcon.func_94209_e(), (double)iIcon.func_94207_b((double)n4));
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + n4), (double)((Gui)this).field_73735_i, (double)iIcon.func_94214_a((double)n3), (double)iIcon.func_94207_b((double)n4));
        tessellator.func_78374_a((double)(n + n3), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)iIcon.func_94214_a((double)n3), (double)iIcon.func_94206_g());
        tessellator.func_78374_a((double)(n + 0), (double)(n2 + 0), (double)((Gui)this).field_73735_i, (double)iIcon.func_94209_e(), (double)iIcon.func_94206_g());
        tessellator.func_78381_a();
    }
}

