/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownPlacementValidator;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.world_gen.StructureEntry;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldGenTickHandler;

public class WorldTownGenerator
implements IWorldGenerator {
    public static final WorldTownGenerator INSTANCE = new WorldTownGenerator();

    private WorldTownGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ChunkCoordinates cc = world.func_72861_E();
        float distSq = cc.func_71569_e(chunkX * 16, cc.field_71572_b, chunkZ * 16);
        if (AWStructureStatics.withinProtectionRange(distSq)) {
            return;
        }
        if (random.nextFloat() < AWStructureStatics.townGenerationChance) {
            WorldGenTickHandler.INSTANCE.addChunkForTownGeneration(world, chunkX, chunkZ);
        }
    }

    public void attemptGeneration(World world, int blockX, int blockZ) {
        TownBoundingArea area = TownPlacementValidator.findGenerationPosition(world, blockX, blockZ);
        if (area == null) {
            return;
        }
        TownTemplate template = TownTemplateManager.INSTANCE.selectTemplateForGeneration(world, blockX, blockZ, area);
        if (template == null) {
            return;
        }
        if (area.getChunkWidth() - 1 > template.getMaxSize()) {
            area.chunkMaxX = area.chunkMinX + template.getMaxSize();
        }
        if (area.getChunkLength() - 1 > template.getMaxSize()) {
            area.chunkMaxZ = area.chunkMinZ + template.getMaxSize();
        }
        if (!TownPlacementValidator.validateAreaForPlacement(world, area)) {
            return;
        }
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        StructureBB bb = new StructureBB(new BlockPosition(area.getBlockMinX(), area.getMinY(), area.getBlockMinZ()), new BlockPosition(area.getBlockMaxX(), area.getMaxY(), area.getBlockMaxZ()));
        StructureEntry entry = new StructureEntry(bb, template.getTownTypeName(), template.getClusterValue());
        map.setGeneratedAt(world, area.getCenterX(), area.getSurfaceY(), area.getCenterZ(), 0, entry, false);
        AWGameData.INSTANCE.getPerWorldData(world, TownMap.class).setGenerated(bb);
        new TownGenerator(world, area, template).generate();
    }
}

