/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.api.AWBlocks;
import net.shadowmage.ancientwarfare.core.api.ModuleStatus;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.interfaces.IOwnable;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.upgrade.WorksiteUpgrade;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderTicked;

public class TileStructureBuilder
extends TileEntity
implements IWorkSite,
IOwnable {
    protected UUID owningPlayer;
    private EntityPlayer owner;
    StructureBuilderTicked builder;
    private boolean shouldRemove = false;
    public boolean isStarted = false;
    int workDelay = 20;
    double maxEnergyStored = AWCoreStatics.energyPerWorkUnit * 3.0;
    double maxInput = AWCoreStatics.energyPerWorkUnit;
    private double storedEnergy;
    public StructureBB clientBB;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = super.getRenderBoundingBox();
        if (this.clientBB != null) {
            bb.func_72321_a((double)(this.clientBB.min.x - this.field_145851_c), (double)(this.clientBB.min.y - this.field_145848_d), (double)(this.clientBB.min.z - this.field_145849_e));
            bb.func_72321_a((double)(this.clientBB.max.x - this.field_145851_c), (double)(this.clientBB.max.y - this.field_145848_d), (double)(this.clientBB.max.z - this.field_145849_e));
        }
        return bb;
    }

    @Override
    public EnumSet<WorksiteUpgrade> getUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public EnumSet<WorksiteUpgrade> getValidUpgrades() {
        return EnumSet.noneOf(WorksiteUpgrade.class);
    }

    @Override
    public void addUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public void removeUpgrade(WorksiteUpgrade upgrade) {
    }

    @Override
    public float getClientOutputRotation(ForgeDirection from, float delta) {
        return 0.0f;
    }

    @Override
    public boolean useOutputRotation(ForgeDirection from) {
        return false;
    }

    @Override
    public double addTorque(ForgeDirection from, double energy) {
        if (this.canInputTorque(from)) {
            if (energy + this.getTorqueStored(null) > this.getMaxTorque(null)) {
                energy = this.getMaxTorque(null) - this.getTorqueStored(null);
            }
            if (energy > this.getMaxTorqueInput(null)) {
                energy = this.getMaxTorqueInput(null);
            }
            this.storedEnergy += energy;
            return energy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTorque(ForgeDirection from) {
        return this.maxEnergyStored;
    }

    @Override
    public double getTorqueStored(ForgeDirection from) {
        return this.storedEnergy;
    }

    @Override
    public double getMaxTorqueInput(ForgeDirection from) {
        return this.maxInput;
    }

    @Override
    public boolean canInputTorque(ForgeDirection from) {
        return true;
    }

    public void func_145845_h() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.shouldRemove || this.builder == null || this.builder.invalid || this.builder.isFinished()) {
            this.shouldRemove = true;
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        if (this.builder.getWorld() == null) {
            this.builder.setWorld(this.field_145850_b);
        }
        if (ModuleStatus.automationLoaded || ModuleStatus.npcsLoaded) {
            if (this.storedEnergy >= AWCoreStatics.energyPerWorkUnit) {
                this.storedEnergy -= AWCoreStatics.energyPerWorkUnit;
                this.processWork();
            }
        } else if (this.workDelay-- <= 0) {
            this.processWork();
            this.workDelay = 20;
        }
    }

    public void processWork() {
        this.isStarted = true;
        this.builder.tick(this.getOwnerAsPlayer());
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owningPlayer = player.func_110124_au();
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owningPlayer == null || this.owningPlayer.equals(player.func_110124_au());
    }

    @Override
    public String getOwnerName() {
        return this.getOwnerAsPlayer().func_70005_c_();
    }

    public final EntityPlayer getOwnerAsPlayer() {
        if (this.owner == null || !this.owner.func_70089_S() || this.owner.func_85032_ar()) {
            this.owner = AncientWarfareCore.proxy.getFakePlayer(this.func_145831_w(), null, this.owningPlayer);
        }
        return this.owner;
    }

    public void setBuilder(StructureBuilderTicked builder) {
        this.builder = builder;
    }

    @Override
    public void onBlockBroken() {
        if (!this.field_145850_b.field_72995_K && !this.isStarted && this.builder != null && this.builder.getTemplate() != null) {
            this.isStarted = true;
            ItemStack item = new ItemStack(AWBlocks.builderBlock);
            item.func_77983_a("structureName", (NBTBase)new NBTTagString(this.builder.getTemplate().name));
        }
    }

    public void onBlockClicked(EntityPlayer player) {
        int pass = this.builder.getPass() + 1;
        int max = this.builder.getMaxPasses();
        float percent = this.builder.getPercentDoneWithPass() * 100.0f;
        String perc = String.format("%.2f", Float.valueOf(percent)) + "%";
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("guistrings.structure.builder.state", new Object[]{perc, pass, max}));
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        StructureBB bb = this.builder.getBoundingBox();
        if (bb != null) {
            tag.func_74782_a("bbMin", (NBTBase)bb.min.writeToNBT(new NBTTagCompound()));
            tag.func_74782_a("bbMax", (NBTBase)bb.max.writeToNBT(new NBTTagCompound()));
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag.func_74764_b("bbMin") && tag.func_74764_b("bbMax")) {
            this.clientBB = new StructureBB(new BlockPosition(tag.func_74775_l("bbMin")), new BlockPosition(tag.func_74775_l("bbMax")));
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("builder")) {
            this.builder = new StructureBuilderTicked();
            this.builder.readFromNBT(tag.func_74775_l("builder"));
        } else {
            this.shouldRemove = true;
        }
        this.isStarted = tag.func_74767_n("started");
        this.storedEnergy = tag.func_74769_h("storedEnergy");
        if (tag.func_74764_b("ownerId")) {
            this.owningPlayer = UUID.fromString(tag.func_74779_i("ownerId"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.builder != null) {
            NBTTagCompound builderTag = new NBTTagCompound();
            this.builder.writeToNBT(builderTag);
            tag.func_74782_a("builder", (NBTBase)builderTag);
        }
        tag.func_74757_a("started", this.isStarted);
        tag.func_74780_a("storedEnergy", this.storedEnergy);
        if (this.owningPlayer != null) {
            tag.func_74778_a("ownerId", this.owningPlayer.toString());
        }
    }

    @Override
    public boolean hasWork() {
        return this.storedEnergy < this.maxEnergyStored;
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public final Team getTeam() {
        if (this.owningPlayer != null) {
            this.field_145850_b.func_96441_U().func_96509_i(this.getOwnerName());
        }
        return null;
    }

    @Override
    public void addEnergyFromWorker(IWorker worker) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit * (double)worker.getWorkEffectiveness(this.getWorkType());
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public void addEnergyFromPlayer(EntityPlayer player) {
        this.storedEnergy += AWCoreStatics.energyPerWorkUnit;
        if (this.storedEnergy > this.getMaxTorque(null)) {
            this.storedEnergy = this.getMaxTorque(null);
        }
    }

    @Override
    public double getMaxTorqueOutput(ForgeDirection from) {
        return 0.0;
    }

    @Override
    public boolean canOutputTorque(ForgeDirection towards) {
        return false;
    }

    @Override
    public double drainTorque(ForgeDirection from, double energy) {
        return 0.0;
    }
}

